/*
 * Decompiled with CFR 0.152.
 */
package checkers.nullness;

import checkers.basetype.BaseTypeChecker;
import checkers.basetype.BaseTypeValidator;
import checkers.basetype.BaseTypeVisitor;
import checkers.nullness.KeyForAnnotatedTypeFactory;
import checkers.nullness.quals.KeyFor;
import checkers.source.Result;
import checkers.types.AnnotatedTypeFactory;
import checkers.types.AnnotatedTypeMirror;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.util.List;
import javacutils.AnnotationUtils;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Modifier;

public class KeyForVisitor
extends BaseTypeVisitor<KeyForAnnotatedTypeFactory> {
    public KeyForVisitor(BaseTypeChecker checker) {
        super(checker);
    }

    @Override
    protected BaseTypeValidator createTypeValidator() {
        return new KeyForTypeValidator(this.checker, this, this.atypeFactory);
    }

    private static final class KeyForTypeValidator
    extends BaseTypeValidator {
        public KeyForTypeValidator(BaseTypeChecker checker, BaseTypeVisitor<?> visitor2, AnnotatedTypeFactory atypeFactory) {
            super(checker, visitor2, atypeFactory);
        }

        @Override
        public Void visitDeclared(AnnotatedTypeMirror.AnnotatedDeclaredType type2, Tree p) {
            AnnotationMirror kf = type2.getAnnotation(KeyFor.class);
            if (kf != null) {
                ModifiersTree mt;
                List<String> maps = AnnotationUtils.getElementValueArray(kf, "value", String.class, false);
                boolean inStatic = false;
                if (p.getKind() == Tree.Kind.VARIABLE && (mt = ((VariableTree)p).getModifiers()).getFlags().contains((Object)Modifier.STATIC)) {
                    inStatic = true;
                }
                for (String map3 : maps) {
                    if (map3.equals("this")) {
                        if (!inStatic) continue;
                        this.checker.report(Result.failure("keyfor.type.invalid", type2.getAnnotations(), type2.toString()), p);
                        continue;
                    }
                    if (!map3.matches("#(\\d+)")) continue;
                }
            }
            return super.visitDeclared(type2, p);
        }
    }
}

