/*
 * Decompiled with CFR 0.152.
 */
package checkers.regex;

import checkers.flow.CFAbstractTransfer;
import checkers.flow.CFStore;
import checkers.flow.CFValue;
import checkers.regex.RegexAnalysis;
import checkers.regex.RegexAnnotatedTypeFactory;
import checkers.regex.quals.Regex;
import checkers.util.FlowExpressionParseUtil;
import dataflow.analysis.ConditionalTransferResult;
import dataflow.analysis.FlowExpressions;
import dataflow.analysis.RegularTransferResult;
import dataflow.analysis.TransferInput;
import dataflow.analysis.TransferResult;
import dataflow.cfg.node.ClassNameNode;
import dataflow.cfg.node.IntegerLiteralNode;
import dataflow.cfg.node.MethodAccessNode;
import dataflow.cfg.node.MethodInvocationNode;
import dataflow.cfg.node.Node;
import javacutils.AnnotationUtils;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;

public class RegexTransfer
extends CFAbstractTransfer<CFValue, CFStore, RegexTransfer> {
    protected RegexAnalysis analysis;

    public RegexTransfer(RegexAnalysis analysis) {
        super(analysis);
        this.analysis = analysis;
    }

    @Override
    public TransferResult<CFValue, CFStore> visitMethodInvocation(MethodInvocationNode n, TransferInput<CFValue, CFStore> in) {
        RegexAnnotatedTypeFactory factory = (RegexAnnotatedTypeFactory)this.analysis.getTypeFactory();
        TransferResult<CFValue, CFStore> result2 = super.visitMethodInvocation(n, in);
        MethodAccessNode target = n.getTarget();
        ExecutableElement method = target.getMethod();
        Node receiver = target.getReceiver();
        if (receiver instanceof ClassNameNode) {
            ClassNameNode cn = (ClassNameNode)receiver;
            String receiverName = cn.getElement().toString();
            if (this.isRegexUtil(receiverName) && method.toString().equals("isRegex(java.lang.String,int)")) {
                ConditionalTransferResult<CFValue, CFStore> newResult;
                block9: {
                    CFStore thenStore = result2.getRegularStore();
                    CFStore elseStore = (CFStore)thenStore.copy();
                    newResult = new ConditionalTransferResult<CFValue, CFStore>(result2.getResultValue(), thenStore, elseStore);
                    FlowExpressionParseUtil.FlowExpressionContext context = FlowExpressionParseUtil.buildFlowExprContextForUse(n, factory);
                    try {
                        FlowExpressions.Receiver firstParam = FlowExpressionParseUtil.parse("#1", context, factory.getPath(n.getTree()));
                        Node count2 = n.getArgument(1);
                        if (count2 instanceof IntegerLiteralNode) {
                            IntegerLiteralNode iln = (IntegerLiteralNode)count2;
                            Integer groupCount = iln.getValue();
                            AnnotationMirror regexAnnotation = factory.createRegexAnnotation(groupCount);
                            thenStore.insertValue(firstParam, regexAnnotation);
                        } else {
                            AnnotationMirror regexAnnotation = AnnotationUtils.fromClass(factory.getElementUtils(), Regex.class);
                            thenStore.insertValue(firstParam, regexAnnotation);
                        }
                    }
                    catch (FlowExpressionParseUtil.FlowExpressionParseException e) {
                        if ($assertionsDisabled) break block9;
                        throw new AssertionError();
                    }
                }
                return newResult;
            }
            if (this.isRegexUtil(receiverName) && method.toString().equals("asRegex(java.lang.String,int)")) {
                AnnotationMirror regexAnnotation;
                Node count3 = n.getArgument(1);
                if (count3 instanceof IntegerLiteralNode) {
                    IntegerLiteralNode iln = (IntegerLiteralNode)count3;
                    Integer groupCount = iln.getValue();
                    regexAnnotation = factory.createRegexAnnotation(groupCount);
                } else {
                    regexAnnotation = AnnotationUtils.fromClass(factory.getElementUtils(), Regex.class);
                }
                CFValue newResultValue = (CFValue)this.analysis.createSingleAnnotationValue(regexAnnotation, result2.getResultValue().getType().getUnderlyingType());
                return new RegularTransferResult<CFValue, CFStore>(newResultValue, result2.getRegularStore());
            }
        }
        return result2;
    }

    private boolean isRegexUtil(String receiver) {
        return receiver.equals("RegexUtil") || receiver.endsWith(".RegexUtil");
    }
}

