/*
 * Decompiled with CFR 0.152.
 */
package checkers.types;

import checkers.basetype.BaseTypeChecker;
import checkers.flow.CFAbstractAnalysis;
import checkers.flow.CFAbstractStore;
import checkers.flow.CFAbstractTransfer;
import checkers.flow.CFAbstractValue;
import checkers.flow.CFAnalysis;
import checkers.flow.CFCFGBuilder;
import checkers.flow.CFTransfer;
import checkers.flow.CFValue;
import checkers.quals.DefaultFor;
import checkers.quals.DefaultLocation;
import checkers.quals.DefaultQualifierInHierarchy;
import checkers.quals.MonotonicQualifier;
import checkers.quals.Unqualified;
import checkers.types.AnnotatedTypeFactory;
import checkers.types.AnnotatedTypeMirror;
import checkers.types.QualifierHierarchy;
import checkers.types.TreeAnnotator;
import checkers.types.TypeAnnotator;
import checkers.util.QualifierDefaults;
import checkers.util.QualifierPolymorphism;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import dataflow.analysis.Analysis;
import dataflow.analysis.AnalysisResult;
import dataflow.analysis.TransferInput;
import dataflow.analysis.TransferResult;
import dataflow.cfg.CFGBuilder;
import dataflow.cfg.ControlFlowGraph;
import dataflow.cfg.UnderlyingAST;
import dataflow.cfg.node.Node;
import dataflow.cfg.node.ReturnNode;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import javacutils.AnnotationUtils;
import javacutils.ErrorReporter;
import javacutils.InternalUtils;
import javacutils.Pair;
import javacutils.TreeUtils;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;

public abstract class AbstractBasicAnnotatedTypeFactory<Value extends CFAbstractValue<Value>, Store extends CFAbstractStore<Value, Store>, TransferFunction extends CFAbstractTransfer<Value, Store, TransferFunction>, FlowAnalysis extends CFAbstractAnalysis<Value, Store, TransferFunction>>
extends AnnotatedTypeFactory {
    protected static boolean FLOW_BY_DEFAULT = true;
    private Set<Class<? extends Annotation>> supportedMonotonicQuals;
    protected TypeAnnotator typeAnnotator;
    protected TreeAnnotator treeAnnotator;
    protected QualifierPolymorphism poly;
    protected QualifierDefaults defaults;
    protected boolean useFlow;
    private Store emptyStore;
    protected final Map<ClassTree, ScanState> scannedClasses;
    protected AnalysisResult<Value, Store> flowResult;
    protected IdentityHashMap<Tree, Store> regularExitStores;
    protected IdentityHashMap<MethodTree, List<Pair<ReturnNode, TransferResult<Value, Store>>>> returnStatementStores;
    protected IdentityHashMap<MethodInvocationTree, Store> methodInvocationStores;
    protected final Deque<FlowAnalysis> analyses;
    protected Store initializationStore;
    protected Store initializationStaticStore;

    public AbstractBasicAnnotatedTypeFactory(BaseTypeChecker checker, boolean useFlow) {
        super(checker);
        this.useFlow = useFlow;
        this.analyses = new LinkedList<FlowAnalysis>();
        this.scannedClasses = new HashMap<ClassTree, ScanState>();
        this.flowResult = null;
        this.regularExitStores = null;
        this.methodInvocationStores = null;
        this.returnStatementStores = null;
        this.initializationStore = null;
        this.initializationStaticStore = null;
    }

    @Override
    protected void postInit() {
        super.postInit();
        this.defaults = this.createQualifierDefaults();
        this.treeAnnotator = this.createTreeAnnotator();
        this.typeAnnotator = this.createTypeAnnotator();
        this.poly = this.createQualifierPolymorphism();
        this.buildIndexTypes();
    }

    public AbstractBasicAnnotatedTypeFactory(BaseTypeChecker checker) {
        this(checker, FLOW_BY_DEFAULT);
    }

    @Override
    public void setRoot(CompilationUnitTree root) {
        super.setRoot(root);
        this.analyses.clear();
        this.scannedClasses.clear();
        this.flowResult = null;
        this.regularExitStores = null;
        this.methodInvocationStores = null;
        this.returnStatementStores = null;
        this.initializationStore = null;
        this.initializationStaticStore = null;
    }

    public final Set<Class<? extends Annotation>> getSupportedMonotonicTypeQualifiers() {
        if (this.supportedMonotonicQuals == null) {
            this.supportedMonotonicQuals = new HashSet<Class<? extends Annotation>>();
            for (Class<? extends Annotation> anno : this.getSupportedTypeQualifiers()) {
                MonotonicQualifier mono = anno.getAnnotation(MonotonicQualifier.class);
                if (mono == null) continue;
                this.supportedMonotonicQuals.add(anno);
            }
        }
        return this.supportedMonotonicQuals;
    }

    protected TreeAnnotator createTreeAnnotator() {
        return new TreeAnnotator(this);
    }

    protected TypeAnnotator createTypeAnnotator() {
        return new TypeAnnotator(this);
    }

    protected FlowAnalysis createFlowAnalysis(List<Pair<VariableElement, Value>> fieldValues) {
        for (Class<?> checkerClass = this.checker.getClass(); checkerClass != BaseTypeChecker.class; checkerClass = checkerClass.getSuperclass()) {
            String classToLoad = checkerClass.getName().replace("Checker", "Analysis").replace("Subchecker", "Analysis");
            CFAbstractAnalysis result2 = (CFAbstractAnalysis)BaseTypeChecker.invokeConstructorFor(classToLoad, new Class[]{BaseTypeChecker.class, this.getClass(), List.class}, new Object[]{this.checker, this, fieldValues});
            if (result2 == null) continue;
            return (FlowAnalysis)result2;
        }
        ArrayList<Pair<VariableElement, CFValue>> tmp = new ArrayList<Pair<VariableElement, CFValue>>();
        for (Pair<VariableElement, Value> fieldVal : fieldValues) {
            assert (fieldVal.second instanceof CFValue);
            tmp.add(Pair.of(fieldVal.first, (CFValue)fieldVal.second));
        }
        return (FlowAnalysis)new CFAnalysis(this.checker, this, (List<Pair<VariableElement, CFValue>>)tmp);
    }

    public TransferFunction createFlowTransferFunction(CFAbstractAnalysis<Value, Store, TransferFunction> analysis) {
        for (Class<?> checkerClass = this.checker.getClass(); checkerClass != BaseTypeChecker.class; checkerClass = checkerClass.getSuperclass()) {
            String classToLoad = checkerClass.getName().replace("Checker", "Transfer").replace("Subchecker", "Transfer");
            CFAbstractTransfer result2 = (CFAbstractTransfer)BaseTypeChecker.invokeConstructorFor(classToLoad, new Class[]{analysis.getClass()}, new Object[]{analysis});
            if (result2 == null) continue;
            return (TransferFunction)result2;
        }
        CFTransfer ret = new CFTransfer(analysis);
        return (TransferFunction)ret;
    }

    protected QualifierDefaults createQualifierDefaults() {
        QualifierDefaults defs = new QualifierDefaults(this.elements, this);
        boolean foundDefaultOtherwise = false;
        for (Class<? extends Annotation> qual : this.getSupportedTypeQualifiers()) {
            DefaultFor defaultFor = qual.getAnnotation(DefaultFor.class);
            boolean hasDefaultFor = false;
            if (defaultFor != null) {
                defs.addAbsoluteDefaults(AnnotationUtils.fromClass(this.elements, qual), defaultFor.value());
                hasDefaultFor = true;
                for (DefaultLocation dl : defaultFor.value()) {
                    if (dl != DefaultLocation.OTHERWISE) continue;
                    foundDefaultOtherwise = true;
                }
            }
            if (qual.getAnnotation(DefaultQualifierInHierarchy.class) == null) continue;
            if (hasDefaultFor) {
                ErrorReporter.errorAbort("AbstractBasicAnnotatedTypeFactory.createQualifierDefaults: qualifier has both @DefaultFor and @DefaultQualifierInHierarchy annotations: " + qual.getCanonicalName());
                continue;
            }
            defs.addAbsoluteDefault(AnnotationUtils.fromClass(this.elements, qual), DefaultLocation.OTHERWISE);
            foundDefaultOtherwise = true;
        }
        AnnotationMirror unqualified = AnnotationUtils.fromClass(this.elements, Unqualified.class);
        if (!foundDefaultOtherwise && this.isSupportedQualifier(unqualified)) {
            defs.addAbsoluteDefault(unqualified, DefaultLocation.OTHERWISE);
        }
        return defs;
    }

    protected QualifierPolymorphism createQualifierPolymorphism() {
        return new QualifierPolymorphism(this.processingEnv, this);
    }

    @Override
    protected void postDirectSuperTypes(AnnotatedTypeMirror type2, List<? extends AnnotatedTypeMirror> supertypes2) {
        super.postDirectSuperTypes(type2, supertypes2);
        if (type2.getKind() == TypeKind.DECLARED) {
            for (AnnotatedTypeMirror annotatedTypeMirror : supertypes2) {
                Element elt = ((DeclaredType)annotatedTypeMirror.getUnderlyingType()).asElement();
                this.annotateImplicit(elt, annotatedTypeMirror);
            }
        }
    }

    public Store getRegularExitStore(Tree t) {
        return (Store)((CFAbstractStore)this.regularExitStores.get(t));
    }

    public List<Pair<ReturnNode, TransferResult<Value, Store>>> getReturnStatementStores(MethodTree methodTree) {
        assert (this.returnStatementStores.containsKey(methodTree));
        return this.returnStatementStores.get(methodTree);
    }

    public Store getStoreBefore(Tree tree2) {
        Node node;
        if (this.analyses == null || this.analyses.isEmpty()) {
            return (Store)((CFAbstractStore)this.flowResult.getStoreBefore(tree2));
        }
        CFAbstractAnalysis analysis = (CFAbstractAnalysis)this.analyses.getFirst();
        TransferInput prevStore = analysis.getInput((node = analysis.getNodeForTree(tree2)).getBlock());
        if (prevStore == null) {
            return null;
        }
        CFAbstractStore store = (CFAbstractStore)AnalysisResult.runAnalysisFor(node, true, prevStore);
        return (Store)store;
    }

    public Store getStoreAfter(Tree tree2) {
        if (this.analyses == null || this.analyses.isEmpty()) {
            return (Store)((CFAbstractStore)this.flowResult.getStoreAfter(tree2));
        }
        CFAbstractAnalysis analysis = (CFAbstractAnalysis)this.analyses.getFirst();
        Node node = analysis.getNodeForTree(tree2);
        CFAbstractStore store = (CFAbstractStore)AnalysisResult.runAnalysisFor(node, false, analysis.getInput(node.getBlock()));
        return (Store)store;
    }

    public Node getNodeForTree(Tree tree2) {
        return this.flowResult.getNodeForTree(tree2);
    }

    public HashMap<Element, Value> getFinalLocalValues() {
        return this.flowResult.getFinalLocalValues();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performFlowAnalysis(ClassTree classTree) {
        if (this.flowResult == null) {
            this.regularExitStores = new IdentityHashMap();
            this.returnStatementStores = new IdentityHashMap();
            this.flowResult = new AnalysisResult();
        }
        if (classTree.getKind() == Tree.Kind.INTERFACE || classTree.getKind() == Tree.Kind.ANNOTATION_TYPE) {
            this.scannedClasses.put(classTree, ScanState.FINISHED);
            return;
        }
        LinkedList<ClassTree> queue = new LinkedList<ClassTree>();
        ArrayList<Pair<VariableElement, Value>> fieldValues = new ArrayList<Pair<VariableElement, Value>>();
        queue.add(classTree);
        while (!queue.isEmpty()) {
            ClassTree ct = (ClassTree)queue.remove();
            this.scannedClasses.put(ct, ScanState.IN_PROGRESS);
            AnnotatedTypeMirror.AnnotatedDeclaredType preClassType = this.visitorState.getClassType();
            ClassTree preClassTree = this.visitorState.getClassTree();
            AnnotatedTypeMirror.AnnotatedDeclaredType preAMT = this.visitorState.getMethodReceiver();
            MethodTree preMT = this.visitorState.getMethodTree();
            this.visitorState.setClassType(this.getAnnotatedType(ct));
            this.visitorState.setClassTree(ct);
            this.visitorState.setMethodReceiver(null);
            this.visitorState.setMethodTree(null);
            this.initializationStaticStore = null;
            this.initializationStore = null;
            try {
                ArrayList<MethodTree> methods2 = new ArrayList<MethodTree>();
                block11: for (Tree tree2 : ct.getMembers()) {
                    switch (tree2.getKind()) {
                        case METHOD: {
                            MethodTree mt = (MethodTree)tree2;
                            ModifiersTree modifiers = mt.getModifiers();
                            if (modifiers != null) {
                                Set<Modifier> flags = modifiers.getFlags();
                                if (flags.contains((Object)Modifier.ABSTRACT)) continue block11;
                                if (flags.contains((Object)Modifier.NATIVE)) break;
                            }
                            methods2.add(mt);
                            break;
                        }
                        case VARIABLE: {
                            VariableTree vt = (VariableTree)tree2;
                            ExpressionTree initializer = vt.getInitializer();
                            if (initializer == null) continue block11;
                            this.analyze(queue, new UnderlyingAST.CFGStatement(vt), fieldValues, classTree, true, false);
                            CFAbstractValue value2 = (CFAbstractValue)this.flowResult.getValue(initializer);
                            if (value2 == null) continue block11;
                            VariableElement element = TreeUtils.elementFromDeclaration(vt);
                            fieldValues.add(Pair.of(element, value2));
                            break;
                        }
                        case CLASS: {
                            queue.add((ClassTree)tree2);
                            break;
                        }
                        case ANNOTATION_TYPE: 
                        case INTERFACE: 
                        case ENUM: {
                            break;
                        }
                        case BLOCK: {
                            BlockTree b = (BlockTree)tree2;
                            this.analyze(queue, new UnderlyingAST.CFGStatement(b), fieldValues, ct, true, b.isStatic());
                            break;
                        }
                        default: {
                            assert (false) : "Unexpected member: " + (Object)((Object)tree2.getKind());
                            continue block11;
                        }
                    }
                }
                for (MethodTree methodTree : methods2) {
                    this.analyze(queue, new UnderlyingAST.CFGMethod(methodTree, TreeUtils.enclosingClass(this.getPath(methodTree))), fieldValues, classTree, false, false);
                }
                if (this.initializationStaticStore == null) {
                    this.regularExitStores.put(ct, this.emptyStore);
                } else {
                    this.regularExitStores.put(ct, this.initializationStaticStore);
                }
            }
            finally {
                this.visitorState.setClassType(preClassType);
                this.visitorState.setClassTree(preClassTree);
                this.visitorState.setMethodReceiver(preAMT);
                this.visitorState.setMethodTree(preMT);
            }
            this.scannedClasses.put(ct, ScanState.FINISHED);
        }
    }

    protected void analyze(Queue<ClassTree> queue, UnderlyingAST ast, List<Pair<VariableElement, Value>> fieldValues, ClassTree currentClass, boolean isInitializationCode, boolean isStatic) {
        Store initStore;
        CFCFGBuilder builder = new CFCFGBuilder(this.checker, this);
        ControlFlowGraph cfg = ((CFGBuilder)builder).run(this.root, this.processingEnv, ast);
        FlowAnalysis newAnalysis = this.createFlowAnalysis(fieldValues);
        if (this.emptyStore == null) {
            this.emptyStore = ((CFAbstractAnalysis)newAnalysis).createEmptyStore(!this.checker.hasOption("concurrentSemantics"));
        }
        this.analyses.addFirst(newAnalysis);
        Store Store2 = initStore = isStatic ? this.initializationStore : this.initializationStaticStore;
        if (isInitializationCode && initStore != null) {
            CFAbstractTransfer transfer = (CFAbstractTransfer)((Analysis)newAnalysis).getTransferFunction();
            transfer.setFixedInitialStore(initStore);
        }
        ((CFAbstractAnalysis)this.analyses.getFirst()).performAnalysis(cfg);
        AnalysisResult result2 = ((CFAbstractAnalysis)this.analyses.getFirst()).getResult();
        this.flowResult.combine(result2);
        if (ast.getKind() == UnderlyingAST.Kind.METHOD) {
            UnderlyingAST.CFGMethod mast = (UnderlyingAST.CFGMethod)ast;
            MethodTree method = mast.getMethod();
            CFAbstractStore regularExitStore = (CFAbstractStore)((CFAbstractAnalysis)this.analyses.getFirst()).getRegularExitStore();
            if (regularExitStore != null) {
                this.regularExitStores.put(method, regularExitStore);
            }
            this.returnStatementStores.put(method, ((CFAbstractAnalysis)this.analyses.getFirst()).getReturnStatementStores());
        } else if (ast.getKind() == UnderlyingAST.Kind.ARBITRARY_CODE) {
            UnderlyingAST.CFGStatement block = (UnderlyingAST.CFGStatement)ast;
            CFAbstractStore regularExitStore = (CFAbstractStore)((CFAbstractAnalysis)this.analyses.getFirst()).getRegularExitStore();
            if (regularExitStore != null) {
                this.regularExitStores.put(block.getCode(), regularExitStore);
            }
        }
        if (isInitializationCode) {
            CFAbstractStore newInitStore = (CFAbstractStore)((CFAbstractAnalysis)this.analyses.getFirst()).getRegularExitStore();
            if (isStatic) {
                this.initializationStore = newInitStore;
            } else {
                this.initializationStaticStore = newInitStore;
            }
        }
        if (this.checker.hasOption("flowdotdir")) {
            String dotfilename = this.checker.getOption("flowdotdir") + "/" + this.dotOutputFileName(ast) + ".dot";
            dotfilename = dotfilename.replace("<", "_").replace(">", "");
            System.err.println("Output to DOT file: " + dotfilename);
            ((CFAbstractAnalysis)this.analyses.getFirst()).outputToDotFile(dotfilename);
        }
        this.analyses.removeFirst();
        queue.addAll(builder.getDeclaredClasses());
    }

    protected String dotOutputFileName(UnderlyingAST ast) {
        if (ast.getKind() == UnderlyingAST.Kind.ARBITRARY_CODE) {
            return "initializer-" + ast.hashCode();
        }
        if (ast.getKind() == UnderlyingAST.Kind.METHOD) {
            return ((UnderlyingAST.CFGMethod)ast).getMethod().getName().toString();
        }
        assert (false);
        return null;
    }

    public AnnotatedTypeMirror getDefaultedAnnotatedType(Tree tree2, ExpressionTree valueTree) {
        AnnotatedTypeMirror res = null;
        if (tree2 instanceof VariableTree) {
            res = this.fromMember(tree2);
            this.annotateImplicit(tree2, res, false);
        } else if (tree2 instanceof AssignmentTree) {
            res = this.fromExpression(((AssignmentTree)tree2).getVariable());
            this.annotateImplicit(tree2, res, false);
        } else if (tree2 instanceof CompoundAssignmentTree) {
            res = this.fromExpression(((CompoundAssignmentTree)tree2).getVariable());
            this.annotateImplicit(tree2, res, false);
        } else if (TreeUtils.isExpressionTree(tree2)) {
            res = this.fromExpression((ExpressionTree)tree2);
            this.annotateImplicit(tree2, res, false);
        } else assert (false);
        return res;
    }

    @Override
    public Pair<AnnotatedTypeMirror.AnnotatedExecutableType, List<AnnotatedTypeMirror>> constructorFromUse(NewClassTree tree2) {
        Pair<AnnotatedTypeMirror.AnnotatedExecutableType, List<AnnotatedTypeMirror>> mfuPair = super.constructorFromUse(tree2);
        AnnotatedTypeMirror.AnnotatedExecutableType method = (AnnotatedTypeMirror.AnnotatedExecutableType)mfuPair.first;
        this.poly.annotate(tree2, method);
        return mfuPair;
    }

    protected void annotateImplicit(Tree tree2, AnnotatedTypeMirror type2, boolean iUseFlow) {
        assert (this.root != null) : "AbstractBasicAnnotatedTypeFactory.annotateImplicit:  root needs to be set when used on trees; factory: " + this.getClass();
        if (iUseFlow) {
            this.annotateImplicitWithFlow(tree2, type2);
        } else {
            this.treeAnnotator.visit(tree2, type2);
            Element elt = InternalUtils.symbol(tree2);
            this.typeAnnotator.visit(type2, elt);
            this.defaults.annotate(tree2, type2);
        }
    }

    @Override
    public final void annotateImplicit(Tree tree2, AnnotatedTypeMirror type2) {
        this.annotateImplicit(tree2, type2, this.useFlow);
    }

    protected void annotateImplicitWithFlow(Tree tree2, AnnotatedTypeMirror type2) {
        ClassTree classTree;
        assert (this.useFlow) : "useFlow must be true to use flow analysis";
        if (tree2 instanceof ClassTree && !this.scannedClasses.containsKey(classTree = (ClassTree)tree2)) {
            this.performFlowAnalysis(classTree);
        }
        this.treeAnnotator.visit(tree2, type2);
        Element elt = InternalUtils.symbol(tree2);
        this.typeAnnotator.visit(type2, elt);
        this.defaults.annotate(tree2, type2);
        Value as = this.getInferredValueFor(tree2);
        if (as != null) {
            this.applyInferredAnnotations(type2, as);
        }
    }

    public Value getInferredValueFor(Tree tree2) {
        CFAbstractValue as = null;
        if (!this.analyses.isEmpty() && tree2 != null) {
            as = (CFAbstractValue)((CFAbstractAnalysis)this.analyses.getFirst()).getValue(tree2);
        }
        if (as == null && tree2 != null && this.flowResult != null) {
            as = (CFAbstractValue)this.flowResult.getValue(tree2);
        }
        return (Value)as;
    }

    protected void applyInferredAnnotations(AnnotatedTypeMirror type2, Value as) {
        AnnotatedTypeMirror inferred = ((CFAbstractValue)as).getType();
        for (AnnotationMirror annotationMirror : this.getQualifierHierarchy().getTopAnnotations()) {
            AnnotationMirror inferredAnnotation = QualifierHierarchy.canHaveEmptyAnnotationSet(type2) ? inferred.getAnnotationInHierarchy(annotationMirror) : inferred.getEffectiveAnnotationInHierarchy(annotationMirror);
            if (inferredAnnotation == null) {
                type2.removeAnnotationInHierarchy(annotationMirror);
                continue;
            }
            AnnotationMirror present = type2.getAnnotationInHierarchy(annotationMirror);
            if (present != null) {
                if (!this.getQualifierHierarchy().isSubtype(inferredAnnotation, present)) continue;
                type2.replaceAnnotation(inferredAnnotation);
                continue;
            }
            type2.addAnnotation(inferredAnnotation);
        }
    }

    @Override
    public void annotateImplicit(Element elt, AnnotatedTypeMirror type2) {
        this.typeAnnotator.visit(type2, elt);
        this.defaults.annotate(elt, type2);
    }

    @Override
    public Pair<AnnotatedTypeMirror.AnnotatedExecutableType, List<AnnotatedTypeMirror>> methodFromUse(MethodInvocationTree tree2) {
        Pair<AnnotatedTypeMirror.AnnotatedExecutableType, List<AnnotatedTypeMirror>> mfuPair = super.methodFromUse(tree2);
        AnnotatedTypeMirror.AnnotatedExecutableType method = (AnnotatedTypeMirror.AnnotatedExecutableType)mfuPair.first;
        this.poly.annotate(tree2, method);
        return mfuPair;
    }

    public Store getEmptyStore() {
        return this.emptyStore;
    }

    public boolean getUseFlow() {
        return this.useFlow;
    }

    public void setUseFlow(boolean useFlow) {
        this.useFlow = useFlow;
    }

    protected static enum ScanState {
        IN_PROGRESS,
        FINISHED;

    }
}

