/*
 * Decompiled with CFR 0.152.
 */
package checkers.types;

import checkers.types.AnnotatedTypeFactory;
import checkers.types.AnnotatedTypeMirror;
import checkers.types.TypeFromElement;
import checkers.util.AnnotatedTypes;
import com.sun.source.tree.AnnotatedTypeTree;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.UnionTypeTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WildcardTree;
import com.sun.source.util.SimpleTreeVisitor;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.TargetType;
import com.sun.tools.javac.util.List;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javacutils.AnnotationUtils;
import javacutils.ErrorReporter;
import javacutils.InternalUtils;
import javacutils.Pair;
import javacutils.TreeUtils;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeVariable;

abstract class TypeFromTree
extends SimpleTreeVisitor<AnnotatedTypeMirror, AnnotatedTypeFactory> {
    public static final TypeFromExpression TypeFromExpressionINSTANCE = new TypeFromExpression();
    public static final TypeFromMember TypeFromMemberINSTANCE = new TypeFromMember();
    public static final TypeFromClass TypeFromClassINSTANCE = new TypeFromClass();
    public static final TypeFromTypeTree TypeFromTypeTreeINSTANCE = new TypeFromTypeTree();

    TypeFromTree() {
    }

    @Override
    public AnnotatedTypeMirror defaultAction(Tree node, AnnotatedTypeFactory f) {
        if (node == null) {
            ErrorReporter.errorAbort("TypeFromTree.defaultAction: null tree");
            return null;
        }
        ErrorReporter.errorAbort("TypeFromTree.defaultAction: conversion undefined for tree type " + (Object)((Object)node.getKind()));
        return null;
    }

    private static class TypeFromTypeTree
    extends TypeFromTree {
        private final Map<Tree, AnnotatedTypeMirror> visitedBounds = new HashMap<Tree, AnnotatedTypeMirror>();

        private TypeFromTypeTree() {
        }

        @Override
        public AnnotatedTypeMirror visitAnnotatedType(AnnotatedTypeTree node, AnnotatedTypeFactory f) {
            AnnotatedTypeMirror type2 = (AnnotatedTypeMirror)this.visit(node.getUnderlyingType(), f);
            if (type2 == null) {
                type2 = f.toAnnotatedType(f.types.getNoType(TypeKind.NONE));
            }
            assert (AnnotatedTypeFactory.validAnnotatedType(type2));
            java.util.List<? extends AnnotationMirror> annos = InternalUtils.annotationsFromTree(node);
            type2.addAnnotations(annos);
            if (type2.getKind() == TypeKind.TYPEVAR) {
                ((AnnotatedTypeMirror.AnnotatedTypeVariable)type2).getUpperBound().addMissingAnnotations(annos);
            }
            if (type2.getKind() == TypeKind.WILDCARD) {
                ((AnnotatedTypeMirror.AnnotatedWildcardType)type2).getExtendsBound().addMissingAnnotations(annos);
            }
            return type2;
        }

        @Override
        public AnnotatedTypeMirror visitArrayType(ArrayTypeTree node, AnnotatedTypeFactory f) {
            AnnotatedTypeMirror component = (AnnotatedTypeMirror)this.visit(node.getType(), f);
            AnnotatedTypeMirror result2 = f.type(node);
            assert (result2 instanceof AnnotatedTypeMirror.AnnotatedArrayType);
            ((AnnotatedTypeMirror.AnnotatedArrayType)result2).setComponentType(component);
            return result2;
        }

        @Override
        public AnnotatedTypeMirror visitParameterizedType(ParameterizedTypeTree node, AnnotatedTypeFactory f) {
            LinkedList args2 = new LinkedList();
            for (Tree tree2 : node.getTypeArguments()) {
                args2.add(this.visit(tree2, f));
            }
            AnnotatedTypeMirror result2 = f.type(node);
            AnnotatedTypeMirror annotatedTypeMirror = (AnnotatedTypeMirror)this.visit(node.getType(), f);
            result2.addAnnotations(annotatedTypeMirror.getAnnotations());
            if (result2 instanceof AnnotatedTypeMirror.AnnotatedDeclaredType) {
                assert (result2 instanceof AnnotatedTypeMirror.AnnotatedDeclaredType) : node + " --> " + result2;
                ((AnnotatedTypeMirror.AnnotatedDeclaredType)result2).setTypeArguments(args2);
            }
            return result2;
        }

        @Override
        public AnnotatedTypeMirror visitPrimitiveType(PrimitiveTypeTree node, AnnotatedTypeFactory f) {
            return f.type(node);
        }

        @Override
        public AnnotatedTypeMirror visitTypeParameter(TypeParameterTree node, AnnotatedTypeFactory f) {
            LinkedList<AnnotatedTypeMirror> bounds = new LinkedList<AnnotatedTypeMirror>();
            for (Tree tree2 : node.getBounds()) {
                AnnotatedTypeMirror bound;
                if (this.visitedBounds.containsKey(tree2) && f == this.visitedBounds.get((Object)tree2).atypeFactory) {
                    bound = this.visitedBounds.get(tree2);
                } else {
                    this.visitedBounds.put(tree2, f.type(tree2));
                    bound = (AnnotatedTypeMirror)this.visit(tree2, f);
                    this.visitedBounds.remove(tree2);
                }
                bounds.add(bound);
            }
            AnnotatedTypeMirror.AnnotatedTypeVariable result2 = (AnnotatedTypeMirror.AnnotatedTypeVariable)f.type(node);
            java.util.List<? extends AnnotationMirror> list2 = InternalUtils.annotationsFromTree(node);
            result2.addAnnotations(list2);
            result2.getUpperBound().addAnnotations(list2);
            assert (result2 instanceof AnnotatedTypeMirror.AnnotatedTypeVariable);
            switch (bounds.size()) {
                case 0: {
                    break;
                }
                case 1: {
                    result2.setUpperBound((AnnotatedTypeMirror)bounds.get(0));
                    break;
                }
                default: {
                    AnnotatedTypeMirror.AnnotatedIntersectionType upperBound = (AnnotatedTypeMirror.AnnotatedIntersectionType)result2.getUpperBound();
                    ArrayList<AnnotatedTypeMirror.AnnotatedDeclaredType> superBounds = new ArrayList<AnnotatedTypeMirror.AnnotatedDeclaredType>(bounds.size());
                    for (AnnotatedTypeMirror b : bounds) {
                        superBounds.add((AnnotatedTypeMirror.AnnotatedDeclaredType)b);
                    }
                    upperBound.setDirectSuperTypes(superBounds);
                }
            }
            return result2;
        }

        @Override
        public AnnotatedTypeMirror visitWildcard(WildcardTree node, AnnotatedTypeFactory f) {
            AnnotatedTypeMirror bound = (AnnotatedTypeMirror)this.visit(node.getBound(), f);
            AnnotatedTypeMirror result2 = f.type(node);
            assert (result2 instanceof AnnotatedTypeMirror.AnnotatedWildcardType);
            if (node.getKind() == Tree.Kind.SUPER_WILDCARD) {
                ((AnnotatedTypeMirror.AnnotatedWildcardType)result2).setSuperBound(bound);
            } else if (node.getKind() == Tree.Kind.EXTENDS_WILDCARD) {
                ((AnnotatedTypeMirror.AnnotatedWildcardType)result2).setExtendsBound(bound);
            }
            return result2;
        }

        private AnnotatedTypeMirror forTypeVariable(AnnotatedTypeMirror type2, AnnotatedTypeFactory f) {
            if (type2.getKind() != TypeKind.TYPEVAR) {
                ErrorReporter.errorAbort("TypeFromTree.forTypeVariable: should only be called on type variables");
                return null;
            }
            TypeVariable typeVar = (TypeVariable)type2.getUnderlyingType();
            TypeParameterElement tpe = (TypeParameterElement)typeVar.asElement();
            Element elt = tpe.getGenericElement();
            if (elt instanceof TypeElement) {
                TypeElement typeElt = (TypeElement)elt;
                int idx = typeElt.getTypeParameters().indexOf(tpe);
                ClassTree cls = (ClassTree)f.declarationFromElement(typeElt);
                if (cls != null) {
                    AnnotatedTypeMirror result2 = (AnnotatedTypeMirror)this.visit(cls.getTypeParameters().get(idx), f);
                    return result2;
                }
                return type2;
            }
            if (elt instanceof ExecutableElement) {
                ExecutableElement exElt = (ExecutableElement)elt;
                int idx = exElt.getTypeParameters().indexOf(tpe);
                MethodTree meth = (MethodTree)f.declarationFromElement(exElt);
                if (meth != null) {
                    AnnotatedTypeMirror result3 = (AnnotatedTypeMirror)this.visit(meth.getTypeParameters().get(idx), f);
                    return result3;
                }
                return type2;
            }
            if (InternalUtils.isCaptured(typeVar)) {
                return type2;
            }
            ErrorReporter.errorAbort("TypeFromTree.forTypeVariable: not a supported element: " + elt);
            return null;
        }

        @Override
        public AnnotatedTypeMirror visitIdentifier(IdentifierTree node, AnnotatedTypeFactory f) {
            AnnotatedTypeMirror type2 = f.type(node);
            if (type2.getKind() == TypeKind.TYPEVAR) {
                return this.forTypeVariable(type2, f);
            }
            return type2;
        }

        @Override
        public AnnotatedTypeMirror visitMemberSelect(MemberSelectTree node, AnnotatedTypeFactory f) {
            AnnotatedTypeMirror type2 = f.type(node);
            if (type2.getKind() == TypeKind.TYPEVAR) {
                return this.forTypeVariable(type2, f);
            }
            return type2;
        }

        @Override
        public AnnotatedTypeMirror visitUnionType(UnionTypeTree node, AnnotatedTypeFactory f) {
            AnnotatedTypeMirror type2 = f.type(node);
            if (type2.getKind() == TypeKind.TYPEVAR) {
                return this.forTypeVariable(type2, f);
            }
            return type2;
        }
    }

    private static class TypeFromClass
    extends TypeFromTree {
        private TypeFromClass() {
        }

        @Override
        public AnnotatedTypeMirror visitClass(ClassTree node, AnnotatedTypeFactory f) {
            TypeElement elt = TreeUtils.elementFromDeclaration(node);
            AnnotatedTypeMirror result2 = f.toAnnotatedType(elt.asType());
            TypeFromElement.annotate(result2, elt);
            return result2;
        }
    }

    private static class TypeFromMember
    extends TypeFromTree {
        private TypeFromMember() {
        }

        @Override
        public AnnotatedTypeMirror visitVariable(VariableTree node, AnnotatedTypeFactory f) {
            AnnotatedTypeMirror result2 = f.fromTypeTree(node.getType());
            VariableElement elt = TreeUtils.elementFromDeclaration(node);
            TypeFromElement.annotate(result2, elt);
            return result2;
        }

        @Override
        public AnnotatedTypeMirror visitMethod(MethodTree node, AnnotatedTypeFactory f) {
            ExecutableElement elt = TreeUtils.elementFromDeclaration(node);
            AnnotatedTypeMirror.AnnotatedExecutableType result2 = (AnnotatedTypeMirror.AnnotatedExecutableType)f.toAnnotatedType(elt.asType());
            result2.setElement(elt);
            TypeFromElement.annotate((AnnotatedTypeMirror)result2, elt);
            return result2;
        }
    }

    private static class TypeFromExpression
    extends TypeFromTree {
        private TypeFromExpression() {
        }

        @Override
        public AnnotatedTypeMirror visitAnnotatedType(AnnotatedTypeTree node, AnnotatedTypeFactory f) {
            return f.fromTypeTree(node);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AnnotatedTypeMirror visitArrayAccess(ArrayAccessTree node, AnnotatedTypeFactory f) {
            Pair<Tree, AnnotatedTypeMirror> preAssCtxt = f.visitorState.getAssignmentContext();
            try {
                f.visitorState.setAssignmentContext(null);
                AnnotatedTypeMirror type2 = f.getAnnotatedType(node.getExpression());
                assert (type2 instanceof AnnotatedTypeMirror.AnnotatedArrayType);
                AnnotatedTypeMirror annotatedTypeMirror = ((AnnotatedTypeMirror.AnnotatedArrayType)type2).getComponentType();
                return annotatedTypeMirror;
            }
            finally {
                f.visitorState.setAssignmentContext(preAssCtxt);
            }
        }

        @Override
        public AnnotatedTypeMirror visitAssignment(AssignmentTree node, AnnotatedTypeFactory f) {
            return (AnnotatedTypeMirror)this.visit(node.getVariable(), f);
        }

        @Override
        public AnnotatedTypeMirror visitBinary(BinaryTree node, AnnotatedTypeFactory f) {
            AnnotatedTypeMirror res = f.type(node);
            res.clearAnnotations();
            return res;
        }

        @Override
        public AnnotatedTypeMirror visitCompoundAssignment(CompoundAssignmentTree node, AnnotatedTypeFactory f) {
            AnnotatedTypeMirror res = (AnnotatedTypeMirror)this.visit(node.getVariable(), f);
            res.clearAnnotations();
            return res;
        }

        @Override
        public AnnotatedTypeMirror visitConditionalExpression(ConditionalExpressionTree node, AnnotatedTypeFactory f) {
            AnnotatedTypeMirror falseType;
            AnnotatedTypeMirror trueType = f.getAnnotatedType(node.getTrueExpression());
            if (trueType.equals(falseType = f.getAnnotatedType(node.getFalseExpression()))) {
                return trueType;
            }
            AnnotatedTypeMirror alub = f.type(node);
            AnnotatedTypeMirror assuper = AnnotatedTypes.asSuper(f.types, f, trueType, alub);
            if (assuper != null) {
                trueType = assuper;
            }
            if ((assuper = AnnotatedTypes.asSuper(f.types, f, falseType, alub)) != null) {
                falseType = assuper;
            }
            if (trueType != null && trueType.equals(falseType)) {
                return trueType;
            }
            ArrayList<AnnotatedTypeMirror> types = new ArrayList<AnnotatedTypeMirror>();
            types.add(trueType);
            types.add(falseType);
            AnnotatedTypes.annotateAsLub(f.processingEnv, f, alub, types);
            return alub;
        }

        @Override
        public AnnotatedTypeMirror visitIdentifier(IdentifierTree node, AnnotatedTypeFactory f) {
            if (node.getName().contentEquals("this") || node.getName().contentEquals("super")) {
                AnnotatedTypeMirror.AnnotatedDeclaredType res = f.getSelfType(node);
                return res;
            }
            Element elt = TreeUtils.elementFromUse(node);
            AnnotatedTypeMirror.AnnotatedDeclaredType selfType = f.getImplicitReceiverType(node);
            if (selfType != null) {
                return AnnotatedTypes.asMemberOf(f.types, f, (AnnotatedTypeMirror)selfType, elt);
            }
            return f.getAnnotatedType(elt);
        }

        @Override
        public AnnotatedTypeMirror visitInstanceOf(InstanceOfTree node, AnnotatedTypeFactory f) {
            return f.type(node);
        }

        @Override
        public AnnotatedTypeMirror visitLiteral(LiteralTree node, AnnotatedTypeFactory f) {
            return f.type(node);
        }

        @Override
        public AnnotatedTypeMirror visitMemberSelect(MemberSelectTree node, AnnotatedTypeFactory f) {
            Element elt = TreeUtils.elementFromUse(node);
            if (elt.getKind().isClass() || elt.getKind().isInterface()) {
                return f.fromElement(elt);
            }
            if (!(node.getExpression() instanceof PrimitiveTypeTree)) {
                if (node.getIdentifier().contentEquals("this")) {
                    return f.getEnclosingType((TypeElement)InternalUtils.symbol(node.getExpression()), node);
                }
                AnnotatedTypeMirror t = f.getAnnotatedType(node.getExpression());
                if (t instanceof AnnotatedTypeMirror.AnnotatedDeclaredType) {
                    return AnnotatedTypes.asMemberOf(f.types, f, t, elt);
                }
            }
            return f.fromElement(elt);
        }

        @Override
        public AnnotatedTypeMirror visitMethodInvocation(MethodInvocationTree node, AnnotatedTypeFactory f) {
            AnnotatedTypeMirror.AnnotatedExecutableType ex = (AnnotatedTypeMirror.AnnotatedExecutableType)f.methodFromUse((MethodInvocationTree)node).first;
            return ex.getReturnType();
        }

        @Override
        public AnnotatedTypeMirror visitNewArray(NewArrayTree node, AnnotatedTypeFactory f) {
            AnnotatedTypeMirror.AnnotatedArrayType result2 = (AnnotatedTypeMirror.AnnotatedArrayType)f.type(node);
            if (node.getType() == null) {
                return result2;
            }
            this.annotateArrayAsArray(result2, node, f);
            return result2;
        }

        private AnnotatedTypeMirror descendBy(AnnotatedTypeMirror type2, int depth) {
            AnnotatedTypeMirror result2 = type2;
            while (depth > 0) {
                result2 = ((AnnotatedTypeMirror.AnnotatedArrayType)result2).getComponentType();
                --depth;
            }
            return result2;
        }

        private void annotateArrayAsArray(AnnotatedTypeMirror.AnnotatedArrayType result2, NewArrayTree node, AnnotatedTypeFactory f) {
            AnnotatedTypeMirror treeElem = f.fromTypeTree(node.getType());
            boolean hasInit = node.getInitializers() != null;
            AnnotatedTypeMirror typeElem = this.descendBy(result2, hasInit ? 1 : node.getDimensions().size());
            while (true) {
                typeElem.addAnnotations(treeElem.getAnnotations());
                if (!(treeElem instanceof AnnotatedTypeMirror.AnnotatedArrayType)) break;
                assert (typeElem instanceof AnnotatedTypeMirror.AnnotatedArrayType);
                treeElem = ((AnnotatedTypeMirror.AnnotatedArrayType)treeElem).getComponentType();
                typeElem = ((AnnotatedTypeMirror.AnnotatedArrayType)typeElem).getComponentType();
            }
            int idx = 0;
            AnnotatedTypeMirror level = result2;
            while (level.getKind() == TypeKind.ARRAY) {
                AnnotatedTypeMirror.AnnotatedArrayType array = level;
                java.util.List<? extends AnnotationMirror> annos = InternalUtils.annotationsFromArrayCreation(node, idx++);
                array.addAnnotations(annos);
                level = array.getComponentType();
            }
            result2.addAnnotations(InternalUtils.annotationsFromArrayCreation(node, -1));
        }

        @Override
        public AnnotatedTypeMirror visitNewClass(NewClassTree node, AnnotatedTypeFactory f) {
            AnnotatedTypeMirror.AnnotatedDeclaredType type2 = f.fromNewClass(node);
            if (this.isNewEnum(type2)) {
                return type2;
            }
            AnnotatedTypeMirror.AnnotatedExecutableType ex = (AnnotatedTypeMirror.AnnotatedExecutableType)f.constructorFromUse((NewClassTree)node).first;
            ExecutableElement ctor = TreeUtils.elementFromUse(node);
            List<Attribute.TypeCompound> decall = ((Symbol)((Object)ctor)).getRawTypeAttributes();
            Set<AnnotationMirror> decret = AnnotationUtils.createAnnotationSet();
            for (Attribute.TypeCompound da : decall) {
                if (da.position.type != TargetType.METHOD_RETURN) continue;
                decret.add(da);
            }
            block1: for (AnnotationMirror cta : ex.getReturnType().getAnnotations()) {
                if (!f.isSupportedQualifier(cta) || type2.isAnnotatedInHierarchy(cta)) continue;
                for (AnnotationMirror fromDecl : decret) {
                    if (!f.isSupportedQualifier(fromDecl) || !AnnotationUtils.areSame(f.getQualifierHierarchy().getTopAnnotation(cta), f.getQualifierHierarchy().getTopAnnotation(fromDecl))) continue;
                    type2.addAnnotation(cta);
                    continue block1;
                }
            }
            return type2;
        }

        private boolean isNewEnum(AnnotatedTypeMirror.AnnotatedDeclaredType type2) {
            return type2.getUnderlyingType().asElement().getKind() == ElementKind.ENUM;
        }

        @Override
        public AnnotatedTypeMirror visitParenthesized(ParenthesizedTree node, AnnotatedTypeFactory f) {
            return (AnnotatedTypeMirror)this.visit(node.getExpression(), f);
        }

        @Override
        public AnnotatedTypeMirror visitTypeCast(TypeCastTree node, AnnotatedTypeFactory f) {
            return f.fromTypeTree(node.getType());
        }

        @Override
        public AnnotatedTypeMirror visitUnary(UnaryTree node, AnnotatedTypeFactory f) {
            return f.type(node);
        }

        @Override
        public AnnotatedTypeMirror visitWildcard(WildcardTree node, AnnotatedTypeFactory f) {
            AnnotatedTypeMirror bound = (AnnotatedTypeMirror)this.visit(node.getBound(), f);
            AnnotatedTypeMirror result2 = f.type(node);
            assert (result2 instanceof AnnotatedTypeMirror.AnnotatedWildcardType);
            if (node.getKind() == Tree.Kind.SUPER_WILDCARD) {
                ((AnnotatedTypeMirror.AnnotatedWildcardType)result2).setSuperBound(bound);
            } else if (node.getKind() == Tree.Kind.EXTENDS_WILDCARD) {
                ((AnnotatedTypeMirror.AnnotatedWildcardType)result2).setExtendsBound(bound);
            }
            return result2;
        }

        @Override
        public AnnotatedTypeMirror visitPrimitiveType(PrimitiveTypeTree node, AnnotatedTypeFactory f) {
            return f.fromTypeTree(node);
        }

        @Override
        public AnnotatedTypeMirror visitArrayType(ArrayTypeTree node, AnnotatedTypeFactory f) {
            return f.fromTypeTree(node);
        }

        @Override
        public AnnotatedTypeMirror visitParameterizedType(ParameterizedTypeTree node, AnnotatedTypeFactory f) {
            return f.fromTypeTree(node);
        }
    }
}

