/*
 * Decompiled with CFR 0.152.
 */
package checkers.types.visitors;

import checkers.types.AnnotatedTypeMirror;
import checkers.types.visitors.AnnotatedTypeVisitor;
import java.util.IdentityHashMap;
import java.util.Map;

public class AnnotatedTypeScanner<R, P>
implements AnnotatedTypeVisitor<R, P> {
    protected final Map<AnnotatedTypeMirror, R> visitedNodes = new IdentityHashMap<AnnotatedTypeMirror, R>();

    public void reset() {
        this.visitedNodes.clear();
    }

    @Override
    public final R visit(AnnotatedTypeMirror t) {
        return this.visit(t, null);
    }

    @Override
    public final R visit(AnnotatedTypeMirror type2, P p) {
        this.reset();
        return this.scan(type2, p);
    }

    protected R scan(AnnotatedTypeMirror type2, P p) {
        return type2 == null ? null : (R)type2.accept(this, p);
    }

    protected R scan(Iterable<? extends AnnotatedTypeMirror> types, P p) {
        if (types == null) {
            return null;
        }
        R r = null;
        boolean first2 = true;
        for (AnnotatedTypeMirror annotatedTypeMirror : types) {
            r = (R)(first2 ? this.scan(annotatedTypeMirror, p) : this.scanAndReduce(annotatedTypeMirror, p, r));
            first2 = false;
        }
        return r;
    }

    protected R scanAndReduce(Iterable<? extends AnnotatedTypeMirror> types, P p, R r) {
        return this.reduce(this.scan(types, p), r);
    }

    public R scanAndReduce(AnnotatedTypeMirror type2, P p, R r) {
        return this.reduce(this.scan(type2, p), r);
    }

    protected R reduce(R r1, R r2) {
        if (r1 == null) {
            return r2;
        }
        return r1;
    }

    @Override
    public R visitDeclared(AnnotatedTypeMirror.AnnotatedDeclaredType type2, P p) {
        if (this.visitedNodes.containsKey(type2)) {
            return this.visitedNodes.get(type2);
        }
        this.visitedNodes.put(type2, null);
        R r = this.scan(type2.getTypeArguments(), p);
        return r;
    }

    @Override
    public R visitIntersection(AnnotatedTypeMirror.AnnotatedIntersectionType type2, P p) {
        if (this.visitedNodes.containsKey(type2)) {
            return this.visitedNodes.get(type2);
        }
        this.visitedNodes.put(type2, null);
        R r = this.scan(type2.directSuperTypes(), p);
        return r;
    }

    @Override
    public R visitUnion(AnnotatedTypeMirror.AnnotatedUnionType type2, P p) {
        if (this.visitedNodes.containsKey(type2)) {
            return this.visitedNodes.get(type2);
        }
        this.visitedNodes.put(type2, null);
        R r = this.scan(type2.getAlternatives(), p);
        return r;
    }

    @Override
    public R visitArray(AnnotatedTypeMirror.AnnotatedArrayType type2, P p) {
        R r = this.scan(type2.getComponentType(), p);
        return r;
    }

    @Override
    public R visitExecutable(AnnotatedTypeMirror.AnnotatedExecutableType type2, P p) {
        R r = this.scan(type2.getReturnType(), p);
        r = this.scanAndReduce(type2.getReceiverType(), p, r);
        r = this.scanAndReduce(type2.getParameterTypes(), p, r);
        r = this.scanAndReduce(type2.getThrownTypes(), p, r);
        r = this.scanAndReduce(type2.getTypeVariables(), p, r);
        return r;
    }

    @Override
    public R visitTypeVariable(AnnotatedTypeMirror.AnnotatedTypeVariable type2, P p) {
        if (this.visitedNodes.containsKey(type2)) {
            return this.visitedNodes.get(type2);
        }
        this.visitedNodes.put(type2, null);
        R r = this.scan(type2.getLowerBoundField(), p);
        this.visitedNodes.put(type2, r);
        r = this.scanAndReduce(type2.getUpperBoundField(), p, r);
        this.visitedNodes.put(type2, r);
        return r;
    }

    @Override
    public R visitNoType(AnnotatedTypeMirror.AnnotatedNoType type2, P p) {
        return null;
    }

    @Override
    public R visitNull(AnnotatedTypeMirror.AnnotatedNullType type2, P p) {
        return null;
    }

    @Override
    public R visitPrimitive(AnnotatedTypeMirror.AnnotatedPrimitiveType type2, P p) {
        return null;
    }

    @Override
    public R visitWildcard(AnnotatedTypeMirror.AnnotatedWildcardType type2, P p) {
        if (this.visitedNodes.containsKey(type2)) {
            return this.visitedNodes.get(type2);
        }
        this.visitedNodes.put(type2, null);
        R r = this.scan(type2.getExtendsBoundField(), p);
        this.visitedNodes.put(type2, r);
        r = this.scanAndReduce(type2.getSuperBoundField(), p, r);
        this.visitedNodes.put(type2, r);
        return r;
    }
}

