/*
 * Decompiled with CFR 0.152.
 */
package checkers.util;

import dataflow.quals.SideEffectFree;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javacutils.ErrorReporter;
import javacutils.InternalUtils;
import javacutils.TypesUtils;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.AnnotationValueVisitor;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public class AnnotationBuilder {
    private final Elements elements;
    private final Types types;
    private final TypeElement annotationElt;
    private final DeclaredType annotationType;
    private final Map<ExecutableElement, AnnotationValue> elementValues;
    private boolean wasBuilt = false;

    public AnnotationBuilder(ProcessingEnvironment env, Class<? extends Annotation> anno) {
        this(env, anno.getCanonicalName());
    }

    public AnnotationBuilder(ProcessingEnvironment env, CharSequence name) {
        this.elements = env.getElementUtils();
        this.types = env.getTypeUtils();
        this.annotationElt = this.elements.getTypeElement(name);
        assert (this.annotationElt.getKind() == ElementKind.ANNOTATION_TYPE);
        this.annotationType = (DeclaredType)this.annotationElt.asType();
        this.elementValues = new LinkedHashMap<ExecutableElement, AnnotationValue>();
    }

    public AnnotationBuilder(ProcessingEnvironment env, AnnotationMirror annotation) {
        this.elements = env.getElementUtils();
        this.types = env.getTypeUtils();
        this.annotationType = annotation.getAnnotationType();
        this.annotationElt = (TypeElement)this.annotationType.asElement();
        this.elementValues = new LinkedHashMap<ExecutableElement, AnnotationValue>();
        this.elementValues.putAll(annotation.getElementValues());
    }

    private void assertNotBuilt() {
        if (this.wasBuilt) {
            ErrorReporter.errorAbort("AnnotationBuilder: error: type was already built");
        }
    }

    public AnnotationMirror build() {
        this.assertNotBuilt();
        this.wasBuilt = true;
        return new AnnotationMirror(){

            @Override
            public DeclaredType getAnnotationType() {
                return AnnotationBuilder.this.annotationType;
            }

            @Override
            public Map<? extends ExecutableElement, ? extends AnnotationValue> getElementValues() {
                return Collections.unmodifiableMap(AnnotationBuilder.this.elementValues);
            }

            @SideEffectFree
            public String toString() {
                StringBuilder buf = new StringBuilder();
                buf.append("@");
                buf.append(AnnotationBuilder.this.annotationType);
                int len = AnnotationBuilder.this.elementValues.size();
                if (len > 0) {
                    buf.append('(');
                    boolean first2 = true;
                    for (Map.Entry pair : AnnotationBuilder.this.elementValues.entrySet()) {
                        if (!first2) {
                            buf.append(", ");
                        }
                        first2 = false;
                        String name = ((ExecutableElement)pair.getKey()).getSimpleName().toString();
                        if (len > 1 || !name.equals("value")) {
                            buf.append(name);
                            buf.append('=');
                        }
                        buf.append(pair.getValue());
                    }
                    buf.append(')');
                }
                return buf.toString();
            }
        };
    }

    public AnnotationBuilder setValue(CharSequence elementName, AnnotationMirror value2) {
        this.setValue(elementName, (Object)value2);
        return this;
    }

    public AnnotationBuilder setValue(CharSequence elementName, List<? extends Object> values2) {
        this.assertNotBuilt();
        ArrayList<AnnotationValue> value2 = new ArrayList<AnnotationValue>(values2.size());
        ExecutableElement var = this.findElement(elementName);
        TypeMirror expectedType = var.getReturnType();
        if (expectedType.getKind() != TypeKind.ARRAY) {
            ErrorReporter.errorAbort("value is an array while expected type is not");
            return null;
        }
        expectedType = ((ArrayType)expectedType).getComponentType();
        for (Object object : values2) {
            this.checkSubtype(expectedType, object);
            value2.add(this.createValue(object));
        }
        AnnotationValue val = this.createValue(value2);
        this.elementValues.put(var, val);
        return this;
    }

    public AnnotationBuilder setValue(CharSequence elementName, Object[] values2) {
        return this.setValue(elementName, Arrays.asList(values2));
    }

    public AnnotationBuilder setValue(CharSequence elementName, Boolean value2) {
        return this.setValue(elementName, (Object)value2);
    }

    public AnnotationBuilder setValue(CharSequence elementName, Character value2) {
        return this.setValue(elementName, (Object)value2);
    }

    public AnnotationBuilder setValue(CharSequence elementName, Double value2) {
        return this.setValue(elementName, (Object)value2);
    }

    public AnnotationBuilder setValue(CharSequence elementName, Float value2) {
        return this.setValue(elementName, (Object)value2);
    }

    public AnnotationBuilder setValue(CharSequence elementName, Integer value2) {
        return this.setValue(elementName, (Object)value2);
    }

    public AnnotationBuilder setValue(CharSequence elementName, Long value2) {
        return this.setValue(elementName, (Object)value2);
    }

    public AnnotationBuilder setValue(CharSequence elementName, Short value2) {
        return this.setValue(elementName, (Object)value2);
    }

    public AnnotationBuilder setValue(CharSequence elementName, String value2) {
        return this.setValue(elementName, (Object)value2);
    }

    public AnnotationBuilder setValue(CharSequence elementName, TypeMirror value2) {
        this.assertNotBuilt();
        AnnotationValue val = this.createValue(value2);
        ExecutableElement var = this.findElement(elementName);
        if (!TypesUtils.isClass(var.getReturnType())) {
            ErrorReporter.errorAbort("expected " + var.getReturnType());
            return null;
        }
        this.elementValues.put(var, val);
        return this;
    }

    private TypeMirror typeFromClass(Class<?> clazz) {
        if (clazz == Void.TYPE) {
            return this.types.getNoType(TypeKind.VOID);
        }
        if (clazz.isPrimitive()) {
            String primitiveName = clazz.getName().toUpperCase();
            TypeKind primitiveKind = TypeKind.valueOf(primitiveName);
            return this.types.getPrimitiveType(primitiveKind);
        }
        if (clazz.isArray()) {
            TypeMirror componentType = this.typeFromClass(clazz.getComponentType());
            return this.types.getArrayType(componentType);
        }
        TypeElement element = this.elements.getTypeElement(clazz.getCanonicalName());
        if (element == null) {
            ErrorReporter.errorAbort("Unrecognized class: " + clazz);
            return null;
        }
        return element.asType();
    }

    public AnnotationBuilder setValue(CharSequence elementName, Class<?> value2) {
        return this.setValue(elementName, this.typeFromClass(value2));
    }

    public AnnotationBuilder setValue(CharSequence elementName, Enum<?> value2) {
        this.assertNotBuilt();
        VariableElement enumElt = this.findEnumElement(value2);
        return this.setValue(elementName, enumElt);
    }

    public AnnotationBuilder setValue(CharSequence elementName, VariableElement value2) {
        ExecutableElement var = this.findElement(elementName);
        if (var.getReturnType().getKind() != TypeKind.DECLARED) {
            ErrorReporter.errorAbort("expected a non enum: " + var.getReturnType());
            return null;
        }
        if (!((DeclaredType)var.getReturnType()).asElement().equals(value2.getEnclosingElement())) {
            ErrorReporter.errorAbort("expected a different type of enum: " + value2.getEnclosingElement());
            return null;
        }
        this.elementValues.put(var, this.createValue(value2));
        return this;
    }

    public AnnotationBuilder setValue(CharSequence elementName, Enum<?>[] values2) {
        this.assertNotBuilt();
        if (values2.length == 0) {
            this.setValue(elementName, Collections.emptyList());
            return this;
        }
        VariableElement enumElt = this.findEnumElement(values2[0]);
        ExecutableElement var = this.findElement(elementName);
        TypeMirror expectedType = var.getReturnType();
        if (expectedType.getKind() != TypeKind.ARRAY) {
            ErrorReporter.errorAbort("expected a non array: " + var.getReturnType());
            return null;
        }
        if ((expectedType = ((ArrayType)expectedType).getComponentType()).getKind() != TypeKind.DECLARED) {
            ErrorReporter.errorAbort("expected a non enum component type: " + var.getReturnType());
            return null;
        }
        if (!((DeclaredType)expectedType).asElement().equals(enumElt.getEnclosingElement())) {
            ErrorReporter.errorAbort("expected a different type of enum: " + enumElt.getEnclosingElement());
            return null;
        }
        ArrayList<AnnotationValue> res = new ArrayList<AnnotationValue>(values2.length);
        for (Enum<?> ev : values2) {
            this.checkSubtype(expectedType, ev);
            enumElt = this.findEnumElement(ev);
            res.add(this.createValue(enumElt));
        }
        AnnotationValue val = this.createValue(res);
        this.elementValues.put(var, val);
        return this;
    }

    public AnnotationBuilder setValue(CharSequence elementName, VariableElement[] values2) {
        this.assertNotBuilt();
        ExecutableElement var = this.findElement(elementName);
        TypeMirror expectedType = var.getReturnType();
        if (expectedType.getKind() != TypeKind.ARRAY) {
            ErrorReporter.errorAbort("expected an array, but found: " + expectedType);
            return null;
        }
        if ((expectedType = ((ArrayType)expectedType).getComponentType()).getKind() != TypeKind.DECLARED) {
            ErrorReporter.errorAbort("expected a declared component type, but found: " + expectedType + " kind: " + (Object)((Object)expectedType.getKind()));
            return null;
        }
        if (!((DeclaredType)expectedType).equals(values2[0].asType())) {
            ErrorReporter.errorAbort("expected a different declared component type: " + expectedType + " vs. " + values2[0]);
            return null;
        }
        ArrayList<AnnotationValue> res = new ArrayList<AnnotationValue>(values2.length);
        for (VariableElement ev : values2) {
            this.checkSubtype(expectedType, ev);
            if (ev.getConstantValue() != null) {
                res.add(this.createValue(ev.getConstantValue()));
                continue;
            }
            res.add(this.createValue(ev));
        }
        AnnotationValue val = this.createValue(res);
        this.elementValues.put(var, val);
        return this;
    }

    private VariableElement findEnumElement(Enum<?> value2) {
        String enumClass = value2.getDeclaringClass().getCanonicalName();
        TypeElement enumClassElt = this.elements.getTypeElement(enumClass);
        assert (enumClassElt != null);
        for (Element element : enumClassElt.getEnclosedElements()) {
            if (!element.getSimpleName().contentEquals(value2.name())) continue;
            return (VariableElement)element;
        }
        ErrorReporter.errorAbort("cannot be here");
        return null;
    }

    private AnnotationBuilder setValue(CharSequence key, Object value2) {
        this.assertNotBuilt();
        AnnotationValue val = this.createValue(value2);
        ExecutableElement var = this.findElement(key);
        this.checkSubtype(var.getReturnType(), value2);
        this.elementValues.put(var, val);
        return this;
    }

    public ExecutableElement findElement(CharSequence key) {
        for (ExecutableElement elt : ElementFilter.methodsIn(this.annotationElt.getEnclosedElements())) {
            if (!elt.getSimpleName().contentEquals(key)) continue;
            return elt;
        }
        ErrorReporter.errorAbort("Couldn't find " + key + " element in " + this.annotationElt);
        return null;
    }

    private boolean checkSubtype(TypeMirror expected, Object givenValue) {
        boolean isSubtype;
        TypeMirror found;
        if (expected.getKind().isPrimitive()) {
            expected = this.types.boxedClass((PrimitiveType)expected).asType();
        }
        if (expected.getKind() == TypeKind.DECLARED && TypesUtils.isClass(expected) && givenValue instanceof TypeMirror) {
            return true;
        }
        if (expected.getKind() == TypeKind.DECLARED && ((DeclaredType)expected).asElement().getKind() == ElementKind.ANNOTATION_TYPE && givenValue instanceof AnnotationMirror) {
            found = ((AnnotationMirror)givenValue).getAnnotationType();
            isSubtype = ((DeclaredType)expected).asElement().equals(((DeclaredType)found).asElement());
        } else if (givenValue instanceof AnnotationMirror) {
            found = ((AnnotationMirror)givenValue).getAnnotationType();
            isSubtype = false;
        } else if (givenValue instanceof VariableElement) {
            found = ((VariableElement)givenValue).asType();
            isSubtype = expected.getKind() == TypeKind.DECLARED ? this.types.isSubtype(this.types.erasure(found), this.types.erasure(expected)) : false;
        } else {
            found = this.elements.getTypeElement(givenValue.getClass().getCanonicalName()).asType();
            isSubtype = this.types.isSubtype(this.types.erasure(found), this.types.erasure(expected));
        }
        if (!isSubtype) {
            if (found.toString().equals(expected.toString())) {
                ErrorReporter.errorAbort("given value differs from expected, but same string representation; this is likely a bootclasspath/classpath issue; found: " + found);
            } else {
                ErrorReporter.errorAbort("given value differs from expected; found: " + found + "; expected: " + expected);
            }
            return false;
        }
        return true;
    }

    private AnnotationValue createValue(final Object obj) {
        return new AnnotationValue(){
            final Object value;
            {
                this.value = obj;
            }

            @Override
            public Object getValue() {
                return this.value;
            }

            @Override
            @SideEffectFree
            public String toString() {
                if (this.value instanceof String) {
                    return "\"" + this.value.toString() + "\"";
                }
                if (this.value instanceof Character) {
                    return "'" + this.value.toString() + "'";
                }
                if (this.value instanceof List) {
                    StringBuilder sb = new StringBuilder();
                    List list2 = (List)this.value;
                    sb.append('{');
                    boolean isFirst = true;
                    for (Object o : list2) {
                        if (!isFirst) {
                            sb.append(", ");
                        }
                        isFirst = false;
                        sb.append(o.toString());
                    }
                    sb.append('}');
                    return sb.toString();
                }
                if (this.value instanceof VariableElement) {
                    VariableElement var = (VariableElement)this.value;
                    String encl = var.getEnclosingElement().toString();
                    if (!encl.isEmpty()) {
                        encl = encl + '.';
                    }
                    return encl + var.toString();
                }
                if (this.value instanceof TypeMirror && InternalUtils.isClassType((TypeMirror)this.value)) {
                    return this.value.toString() + ".class";
                }
                return this.value.toString();
            }

            @Override
            public <R, P> R accept(AnnotationValueVisitor<R, P> v, P p) {
                if (this.value instanceof AnnotationMirror) {
                    return v.visitAnnotation((AnnotationMirror)this.value, p);
                }
                if (this.value instanceof List) {
                    return v.visitArray((List)this.value, p);
                }
                if (this.value instanceof Boolean) {
                    return v.visitBoolean((Boolean)this.value, p);
                }
                if (this.value instanceof Character) {
                    return v.visitChar(((Character)this.value).charValue(), p);
                }
                if (this.value instanceof Double) {
                    return v.visitDouble((Double)this.value, p);
                }
                if (this.value instanceof VariableElement) {
                    return v.visitEnumConstant((VariableElement)this.value, p);
                }
                if (this.value instanceof Float) {
                    return v.visitFloat(((Float)this.value).floatValue(), p);
                }
                if (this.value instanceof Integer) {
                    return v.visitInt((Integer)this.value, p);
                }
                if (this.value instanceof Long) {
                    return v.visitLong((Long)this.value, p);
                }
                if (this.value instanceof Short) {
                    return v.visitShort((Short)this.value, p);
                }
                if (this.value instanceof String) {
                    return v.visitString((String)this.value, p);
                }
                if (this.value instanceof TypeMirror) {
                    return v.visitType((TypeMirror)this.value, p);
                }
                assert (false) : " unknown type : " + v.getClass();
                return v.visitUnknown(this, p);
            }
        };
    }
}

