/*
 * Decompiled with CFR 0.152.
 */
package checkers.util;

import checkers.util.PluginUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;

public class ExecUtil {
    public static final int BLOCK_SIZE = 1024;

    public static int execute(String[] cmd, OutputStream std, OutputStream err) {
        Redirection outRedirect = new Redirection(std, 1024);
        Redirection errRedirect = new Redirection(err, 1024);
        try {
            Process proc = Runtime.getRuntime().exec(cmd);
            outRedirect.redirect(proc.getInputStream());
            errRedirect.redirect(proc.getErrorStream());
            IOException stdExc = outRedirect.join();
            IOException errExc = errRedirect.join();
            int exitStatus = proc.waitFor();
            if (stdExc != null) {
                throw stdExc;
            }
            if (errExc != null) {
                throw errExc;
            }
            return exitStatus;
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Exception executing command: " + PluginUtil.join(" ", Arrays.asList(cmd)), e);
        }
        catch (IOException e) {
            throw new RuntimeException("Exception executing command: " + PluginUtil.join(" ", Arrays.asList(cmd)), e);
        }
    }

    public static void quietlyClose(Writer writer2) {
        try {
            writer2.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void quietlyClose(Reader reader) {
        try {
            reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static class Redirection {
        private final char[] buffer;
        private final OutputStreamWriter out;
        private Thread thread;
        private IOException exception;

        public Redirection(OutputStream out, int bufferSize) {
            this.buffer = new char[bufferSize];
            this.out = new OutputStreamWriter(out);
        }

        public void redirect(final InputStream inStream) {
            this.exception = null;
            this.thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    InputStreamReader in = new InputStreamReader(inStream);
                    try {
                        int read2 = 0;
                        while (read2 > -1) {
                            read2 = in.read(Redirection.this.buffer);
                            if (read2 <= 0) continue;
                            Redirection.this.out.write(Redirection.this.buffer, 0, read2);
                        }
                        Redirection.this.out.flush();
                    }
                    catch (IOException exc) {
                        Redirection.this.exception = exc;
                    }
                    finally {
                        ExecUtil.quietlyClose(in);
                        ExecUtil.quietlyClose(Redirection.this.out);
                    }
                }
            });
            this.thread.start();
        }

        public IOException join() throws InterruptedException {
            this.thread.join();
            return this.exception;
        }
    }
}

