/*
 * Decompiled with CFR 0.152.
 */
package checkers.util;

import checkers.quals.PolymorphicQualifier;
import checkers.types.AnnotatedTypeFactory;
import checkers.types.QualifierHierarchy;
import checkers.util.QualifierPolymorphism;
import dataflow.quals.Pure;
import dataflow.quals.SideEffectFree;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javacutils.AnnotationUtils;
import javacutils.ErrorReporter;
import javax.lang.model.element.AnnotationMirror;

public class MultiGraphQualifierHierarchy
extends QualifierHierarchy {
    protected final Map<AnnotationMirror, Set<AnnotationMirror>> supertypesGraph;
    protected final Map<AnnotationMirror, Set<AnnotationMirror>> supertypesMap;
    protected final Set<AnnotationMirror> tops;
    protected final Set<AnnotationMirror> bottoms;
    protected final AnnotationMirror polymorphicQualifier;
    protected final Map<AnnotationMirror, AnnotationMirror> polyQualifiers;
    protected Set<String> typeQualifiers = null;
    private Map<AnnotationPair, AnnotationMirror> lubs = null;
    private Map<AnnotationPair, AnnotationMirror> glbs = null;

    public MultiGraphQualifierHierarchy(MultiGraphFactory f) {
        this(f, null);
    }

    public MultiGraphQualifierHierarchy(MultiGraphFactory f, Object ... args2) {
        this.supertypesGraph = Collections.unmodifiableMap(f.supertypes);
        Map<AnnotationMirror, Set<AnnotationMirror>> fullMap = this.buildFullMap(f.supertypes);
        Set<AnnotationMirror> newtops = this.findTops(fullMap);
        Set<AnnotationMirror> newbottoms = this.findBottoms(fullMap);
        this.polymorphicQualifier = AnnotationUtils.fromClass(f.atypeFactory.getElementUtils(), PolymorphicQualifier.class);
        this.polyQualifiers = f.polyQualifiers;
        this.addPolyRelations(this, fullMap, this.polyQualifiers, newtops, newbottoms);
        this.finish(this, fullMap, this.polyQualifiers, newtops, newbottoms, args2);
        this.tops = Collections.unmodifiableSet(newtops);
        this.bottoms = Collections.unmodifiableSet(newbottoms);
        this.supertypesMap = Collections.unmodifiableMap(fullMap);
    }

    protected void finish(QualifierHierarchy qualHierarchy, Map<AnnotationMirror, Set<AnnotationMirror>> fullMap, Map<AnnotationMirror, AnnotationMirror> polyQualifiers, Set<AnnotationMirror> tops, Set<AnnotationMirror> bottoms, Object ... args2) {
    }

    @SideEffectFree
    public String toString() {
        return "Supertypes Graph: " + this.supertypesGraph.toString() + "\nSupertypes Map: " + String.valueOf(this.supertypesMap) + "\nTops: " + this.tops + "\nBottoms: " + this.bottoms;
    }

    @Override
    public Set<? extends AnnotationMirror> getTopAnnotations() {
        return this.tops;
    }

    @Override
    public AnnotationMirror getTopAnnotation(AnnotationMirror start) {
        for (AnnotationMirror top : this.tops) {
            if (!AnnotationUtils.areSame(start, top) && !this.isSubtype(start, top)) continue;
            return top;
        }
        ErrorReporter.errorAbort("MultiGraphQualifierHierarchy: did not find the top corresponding to qualifier " + start + " all tops: " + this.tops);
        return null;
    }

    @Override
    public Set<? extends AnnotationMirror> getBottomAnnotations() {
        return this.bottoms;
    }

    @Override
    public AnnotationMirror getBottomAnnotation(AnnotationMirror start) {
        for (AnnotationMirror bot : this.bottoms) {
            if (!AnnotationUtils.areSame(start, bot) && !this.isSubtype(bot, start)) continue;
            return bot;
        }
        ErrorReporter.errorAbort("MultiGraphQualifierHierarchy: did not find the bottom corresponding to qualifier " + start + " all bottoms: " + this.bottoms);
        return null;
    }

    @Override
    public AnnotationMirror getPolymorphicAnnotation(AnnotationMirror start) {
        AnnotationMirror top = this.getTopAnnotation(start);
        if (this.polyQualifiers.containsKey(top)) {
            return this.polyQualifiers.get(top);
        }
        if (this.polyQualifiers.containsKey(this.polymorphicQualifier)) {
            return this.polyQualifiers.get(this.polymorphicQualifier);
        }
        ErrorReporter.errorAbort("MultiGraphQualifierHierarchy: did not find the polymorphic qualifier corresponding to qualifier " + start + " all polymorphic qualifiers: " + this.polyQualifiers);
        return null;
    }

    @Override
    public boolean isSubtype(Collection<? extends AnnotationMirror> rhs, Collection<? extends AnnotationMirror> lhs) {
        if (lhs.isEmpty() || rhs.isEmpty()) {
            ErrorReporter.errorAbort("MultiGraphQualifierHierarchy: empty annotations in lhs: " + lhs + " or rhs: " + rhs);
        }
        if (lhs.size() != rhs.size()) {
            ErrorReporter.errorAbort("MultiGraphQualifierHierarchy: mismatched number of annotations in lhs: " + lhs + " and rhs: " + rhs);
        }
        int valid = 0;
        for (AnnotationMirror annotationMirror : lhs) {
            for (AnnotationMirror annotationMirror2 : rhs) {
                if (!AnnotationUtils.areSame(this.getTopAnnotation(annotationMirror), this.getTopAnnotation(annotationMirror2)) || !this.isSubtype(annotationMirror2, annotationMirror)) continue;
                ++valid;
            }
        }
        return lhs.size() == valid;
    }

    @Override
    public boolean isSubtypeTypeVariable(Collection<? extends AnnotationMirror> rhs, Collection<? extends AnnotationMirror> lhs) {
        for (AnnotationMirror annotationMirror : this.getTopAnnotations()) {
            AnnotationMirror lhsForTop;
            AnnotationMirror rhsForTop = this.getAnnotationInHierarchy(rhs, annotationMirror);
            if (this.isSubtypeTypeVariable(rhsForTop, lhsForTop = this.getAnnotationInHierarchy(lhs, annotationMirror))) continue;
            return false;
        }
        return true;
    }

    @Override
    public Set<? extends AnnotationMirror> getTypeQualifiers() {
        return Collections.unmodifiableSet(this.supertypesMap.keySet());
    }

    @Override
    public AnnotationMirror leastUpperBound(AnnotationMirror a1, AnnotationMirror a2) {
        if (!AnnotationUtils.areSameIgnoringValues(this.getTopAnnotation(a1), this.getTopAnnotation(a2))) {
            return null;
        }
        if (this.isSubtype(a1, a2)) {
            return a2;
        }
        if (this.isSubtype(a2, a1)) {
            return a1;
        }
        if (AnnotationUtils.areSameIgnoringValues(a1, a2)) {
            return this.getTopAnnotation(a1);
        }
        if (this.lubs == null) {
            this.lubs = this.calculateLubs();
        }
        AnnotationPair pair = new AnnotationPair(a1, a2);
        return this.lubs.get(pair);
    }

    @Override
    public AnnotationMirror leastUpperBoundTypeVariable(AnnotationMirror a1, AnnotationMirror a2) {
        if (a1 == null || a2 == null) {
            return null;
        }
        return this.leastUpperBound(a1, a2);
    }

    @Override
    public AnnotationMirror greatestLowerBound(AnnotationMirror a1, AnnotationMirror a2) {
        if (AnnotationUtils.areSameIgnoringValues(a1, a2)) {
            return AnnotationUtils.areSame(a1, a2) ? a1 : this.getBottomAnnotation(a1);
        }
        if (this.glbs == null) {
            this.glbs = this.calculateGlbs();
        }
        AnnotationPair pair = new AnnotationPair(a1, a2);
        return this.glbs.get(pair);
    }

    @Override
    public AnnotationMirror greatestLowerBoundTypeVariable(AnnotationMirror a1, AnnotationMirror a2) {
        if (a1 == null) {
            return a2;
        }
        if (a2 == null) {
            return a1;
        }
        return this.greatestLowerBound(a1, a2);
    }

    @Override
    public boolean isSubtype(AnnotationMirror rhs, AnnotationMirror lhs) {
        this.checkAnnoInGraph(rhs);
        this.checkAnnoInGraph(lhs);
        if (AnnotationUtils.areSameIgnoringValues(rhs, lhs)) {
            return AnnotationUtils.areSame(rhs, lhs);
        }
        Set<AnnotationMirror> supermap1 = this.supertypesMap.get(rhs);
        return AnnotationUtils.containsSame(supermap1, lhs);
    }

    @Override
    public boolean isSubtypeTypeVariable(AnnotationMirror rhs, AnnotationMirror lhs) {
        if (lhs == null) {
            return true;
        }
        if (rhs == null) {
            return false;
        }
        return this.isSubtype(rhs, lhs);
    }

    private final void checkAnnoInGraph(AnnotationMirror a) {
        if (AnnotationUtils.containsSame(this.supertypesMap.keySet(), a) || AnnotationUtils.containsSame(this.polyQualifiers.values(), a)) {
            return;
        }
        if (a == null) {
            ErrorReporter.errorAbort("MultiGraphQualifierHierarchy found an unqualified type.  Please ensure that your implicit rules cover all cases and/or use a @DefaulQualifierInHierarchy annotation.");
        } else {
            ErrorReporter.errorAbort("MultiGraphQualifierHierarchy found the unrecognized qualifier: " + a + ". Please ensure that the qualifier is correctly included in the subtype hierarchy.");
        }
    }

    protected Set<AnnotationMirror> findTops(Map<AnnotationMirror, Set<AnnotationMirror>> supertypes2) {
        Set<AnnotationMirror> possibleTops = AnnotationUtils.createAnnotationSet();
        for (AnnotationMirror anno : supertypes2.keySet()) {
            if (!supertypes2.get(anno).isEmpty()) continue;
            possibleTops.add(anno);
        }
        return possibleTops;
    }

    protected Set<AnnotationMirror> findBottoms(Map<AnnotationMirror, Set<AnnotationMirror>> supertypes2) {
        Set<AnnotationMirror> possibleBottoms = AnnotationUtils.createAnnotationSet();
        possibleBottoms.addAll(supertypes2.keySet());
        for (Set<AnnotationMirror> supers : supertypes2.values()) {
            possibleBottoms.removeAll(supers);
        }
        return possibleBottoms;
    }

    protected Map<AnnotationMirror, Set<AnnotationMirror>> buildFullMap(Map<AnnotationMirror, Set<AnnotationMirror>> supertypes2) {
        Map<AnnotationMirror, Set<AnnotationMirror>> fullMap = AnnotationUtils.createAnnotationMap();
        for (AnnotationMirror anno : supertypes2.keySet()) {
            MultiGraphQualifierHierarchy.findAllSupers(anno, supertypes2, fullMap);
        }
        return fullMap;
    }

    /*
     * WARNING - void declaration
     */
    protected void addPolyRelations(QualifierHierarchy qualHierarchy, Map<AnnotationMirror, Set<AnnotationMirror>> fullMap, Map<AnnotationMirror, AnnotationMirror> polyQualifiers, Set<AnnotationMirror> tops, Set<AnnotationMirror> bottoms) {
        if (polyQualifiers.isEmpty()) {
            return;
        }
        for (Map.Entry<AnnotationMirror, AnnotationMirror> kv : polyQualifiers.entrySet()) {
            void var11_18;
            boolean found;
            AnnotationMirror declTop = kv.getKey();
            AnnotationMirror polyQualifier = kv.getValue();
            if (declTop == null || AnnotationUtils.areSame(declTop, this.polymorphicQualifier)) {
                if (declTop == null || tops.size() == 1) {
                    AnnotationUtils.updateMappingToImmutableSet(fullMap, polyQualifier, tops);
                    for (AnnotationMirror annotationMirror : bottoms) {
                        AnnotationUtils.updateMappingToImmutableSet(fullMap, annotationMirror, Collections.singleton(polyQualifier));
                    }
                    if (declTop != null) continue;
                    for (Map.Entry entry : polyQualifiers.entrySet()) {
                        AnnotationMirror otherTop = (AnnotationMirror)entry.getKey();
                        AnnotationMirror otherPoly = (AnnotationMirror)entry.getValue();
                        if (otherTop == null) continue;
                        AnnotationUtils.updateMappingToImmutableSet(fullMap, otherPoly, Collections.singleton(polyQualifier));
                    }
                    continue;
                }
                ErrorReporter.errorAbort("MultiGraphQualifierHierarchy.addPolyRelations: incorrect top qualifier given in polymorphic qualifier (specify qualifier): " + polyQualifier + "; possible top qualifiers: " + tops);
                continue;
            }
            Set<AnnotationMirror> declSupers = fullMap.get(declTop);
            Object var11_14 = null;
            if (declSupers.isEmpty()) {
                AnnotationMirror annotationMirror = declTop;
            } else {
                for (AnnotationMirror ds : declSupers) {
                    if (!AnnotationUtils.containsSameIgnoringValues(tops, ds)) continue;
                    AnnotationMirror annotationMirror = ds;
                }
            }
            boolean bl = found = var11_18 != null;
            if (found) {
                AnnotationUtils.updateMappingToImmutableSet(fullMap, polyQualifier, Collections.singleton(var11_18));
            } else {
                ErrorReporter.errorAbort("MultiGraphQualifierHierarchy.addPolyRelations: incorrect top qualifier given in polymorphic qualifier: " + polyQualifier + " could not find: " + var11_18);
            }
            found = false;
            AnnotationMirror bottom = null;
            block4: for (AnnotationMirror btm : bottoms) {
                for (AnnotationMirror btmsuper : fullMap.get(btm)) {
                    if (!AnnotationUtils.areSameIgnoringValues(btmsuper, (AnnotationMirror)var11_18)) continue;
                    found = true;
                    bottom = btm;
                    break block4;
                }
            }
            if (!found) continue;
            AnnotationUtils.updateMappingToImmutableSet(fullMap, bottom, Collections.singleton(polyQualifier));
        }
    }

    private Map<AnnotationPair, AnnotationMirror> calculateLubs() {
        HashMap<AnnotationPair, AnnotationMirror> newlubs = new HashMap<AnnotationPair, AnnotationMirror>();
        for (AnnotationMirror a1 : this.supertypesGraph.keySet()) {
            for (AnnotationMirror a2 : this.supertypesGraph.keySet()) {
                AnnotationPair pair;
                if (AnnotationUtils.areSameIgnoringValues(a1, a2) || !AnnotationUtils.areSame(this.getTopAnnotation(a1), this.getTopAnnotation(a2)) || newlubs.containsKey(pair = new AnnotationPair(a1, a2))) continue;
                AnnotationMirror lub = this.findLub(a1, a2);
                newlubs.put(pair, lub);
            }
        }
        return newlubs;
    }

    private AnnotationMirror findLub(AnnotationMirror a1, AnnotationMirror a2) {
        if (this.isSubtype(a1, a2)) {
            return a2;
        }
        if (this.isSubtype(a2, a1)) {
            return a1;
        }
        assert (this.getTopAnnotation(a1) == this.getTopAnnotation(a2)) : "MultiGraphQualifierHierarchy.findLub: this method may only be called with qualifiers from the same hierarchy. Found a1: " + a1 + " [top: " + this.getTopAnnotation(a1) + "], a2: " + a2 + " [top: " + this.getTopAnnotation(a2) + "]";
        Set<AnnotationMirror> outset = AnnotationUtils.createAnnotationSet();
        for (AnnotationMirror a1Super : this.findSmallestTypes(this.supertypesMap.get(a1))) {
            AnnotationMirror a1Lub = this.findLub(a1Super, a2);
            if (a1Lub != null) {
                outset.add(a1Lub);
            }
            if (a1Lub != null || a1Super != null) continue;
            outset.add(null);
        }
        if (outset.size() == 1) {
            return outset.iterator().next();
        }
        if (outset.size() > 1) {
            outset = this.findSmallestTypes(outset);
            return outset.iterator().next();
        }
        ErrorReporter.errorAbort("GraphQualifierHierarchy could not determine LUB for " + a1 + " and " + a2 + ". Please ensure that the checker knows about all type qualifiers.");
        return null;
    }

    private Set<AnnotationMirror> findSmallestTypes(Set<AnnotationMirror> inset) {
        Set<AnnotationMirror> outset = AnnotationUtils.createAnnotationSet();
        outset.addAll(inset);
        for (AnnotationMirror a1 : inset) {
            Iterator<AnnotationMirror> outit = outset.iterator();
            while (outit.hasNext()) {
                AnnotationMirror a2 = outit.next();
                if (a1 == a2 || !this.isSubtype(a1, a2)) continue;
                outit.remove();
            }
        }
        return outset;
    }

    private static Set<AnnotationMirror> findAllSupers(AnnotationMirror anno, Map<AnnotationMirror, Set<AnnotationMirror>> supertypes2, Map<AnnotationMirror, Set<AnnotationMirror>> allSupersSoFar) {
        Set<AnnotationMirror> supers = AnnotationUtils.createAnnotationSet();
        if (allSupersSoFar.containsKey(anno)) {
            return Collections.unmodifiableSet(allSupersSoFar.get(anno));
        }
        allSupersSoFar.put(anno, supers);
        for (AnnotationMirror superAnno : supertypes2.get(anno)) {
            supers.add(superAnno);
            supers.addAll(MultiGraphQualifierHierarchy.findAllSupers(superAnno, supertypes2, allSupersSoFar));
        }
        allSupersSoFar.put(anno, Collections.unmodifiableSet(supers));
        return supers;
    }

    private Map<AnnotationPair, AnnotationMirror> calculateGlbs() {
        HashMap<AnnotationPair, AnnotationMirror> newglbs = new HashMap<AnnotationPair, AnnotationMirror>();
        for (AnnotationMirror a1 : this.supertypesGraph.keySet()) {
            for (AnnotationMirror a2 : this.supertypesGraph.keySet()) {
                AnnotationPair pair;
                if (AnnotationUtils.areSameIgnoringValues(a1, a2) || !AnnotationUtils.areSame(this.getTopAnnotation(a1), this.getTopAnnotation(a2)) || newglbs.containsKey(pair = new AnnotationPair(a1, a2))) continue;
                AnnotationMirror glb = this.findGlb(a1, a2);
                newglbs.put(pair, glb);
            }
        }
        return newglbs;
    }

    private AnnotationMirror findGlb(AnnotationMirror a1, AnnotationMirror a2) {
        if (this.isSubtype(a1, a2)) {
            return a1;
        }
        if (this.isSubtype(a2, a1)) {
            return a2;
        }
        assert (this.getTopAnnotation(a1) == this.getTopAnnotation(a2)) : "MultiGraphQualifierHierarchy.findGlb: this method may only be called with qualifiers from the same hierarchy. Found a1: " + a1 + " [top: " + this.getTopAnnotation(a1) + "], a2: " + a2 + " [top: " + this.getTopAnnotation(a2) + "]";
        Set<AnnotationMirror> outset = AnnotationUtils.createAnnotationSet();
        for (AnnotationMirror a1Sub : this.supertypesGraph.keySet()) {
            AnnotationMirror a1lb;
            if (!this.isSubtype(a1Sub, a1) || a1Sub.equals(a1) || (a1lb = this.findGlb(a1Sub, a2)) == null) continue;
            outset.add(a1lb);
        }
        if (outset.size() == 1) {
            return outset.iterator().next();
        }
        if (outset.size() > 1) {
            outset = this.findGreatestTypes(outset);
            return outset.iterator().next();
        }
        ErrorReporter.errorAbort("MultiGraphQualifierHierarchy could not determine GLB for " + a1 + " and " + a2 + ". Please ensure that the checker knows about all type qualifiers.");
        return null;
    }

    private Set<AnnotationMirror> findGreatestTypes(Set<AnnotationMirror> inset) {
        Set<AnnotationMirror> outset = AnnotationUtils.createAnnotationSet();
        outset.addAll(inset);
        for (AnnotationMirror a1 : inset) {
            Iterator<AnnotationMirror> outit = outset.iterator();
            while (outit.hasNext()) {
                AnnotationMirror a2 = outit.next();
                if (a1 == a2 || !this.isSubtype(a2, a1)) continue;
                outit.remove();
            }
        }
        return outset;
    }

    private static class AnnotationPair {
        public final AnnotationMirror a1;
        public final AnnotationMirror a2;
        private int hashCode = -1;

        public AnnotationPair(AnnotationMirror a1, AnnotationMirror a2) {
            this.a1 = a1;
            this.a2 = a2;
        }

        @Pure
        public int hashCode() {
            if (this.hashCode == -1) {
                this.hashCode = 31;
                if (this.a1 != null) {
                    this.hashCode += 17 * AnnotationUtils.annotationName(this.a1).toString().hashCode();
                }
                if (this.a2 != null) {
                    this.hashCode += 17 * AnnotationUtils.annotationName(this.a2).toString().hashCode();
                }
            }
            return this.hashCode;
        }

        public boolean equals(Object o) {
            if (!(o instanceof AnnotationPair)) {
                return false;
            }
            AnnotationPair other = (AnnotationPair)o;
            if (AnnotationUtils.areSameIgnoringValues(this.a1, other.a1) && AnnotationUtils.areSameIgnoringValues(this.a2, other.a2)) {
                return true;
            }
            return AnnotationUtils.areSameIgnoringValues(this.a2, other.a1) && AnnotationUtils.areSameIgnoringValues(this.a1, other.a2);
        }

        @SideEffectFree
        public String toString() {
            return "AnnotationPair(" + this.a1 + ", " + this.a2 + ")";
        }
    }

    public static class MultiGraphFactory {
        protected final Map<AnnotationMirror, Set<AnnotationMirror>> supertypes = AnnotationUtils.createAnnotationMap();
        protected final Map<AnnotationMirror, AnnotationMirror> polyQualifiers = new HashMap<AnnotationMirror, AnnotationMirror>();
        protected final AnnotatedTypeFactory atypeFactory;
        private boolean wasBuilt = false;

        public MultiGraphFactory(AnnotatedTypeFactory atypeFactory) {
            this.atypeFactory = atypeFactory;
        }

        public void addQualifier(AnnotationMirror qual) {
            this.assertNotBuilt();
            if (this.supertypes.containsKey(qual)) {
                return;
            }
            Class<? extends Annotation> pqtopclass = QualifierPolymorphism.getPolymorphicQualifierTop(this.atypeFactory.getElementUtils(), qual);
            if (pqtopclass != null) {
                AnnotationMirror pqtop = AnnotationUtils.fromClass(this.atypeFactory.getElementUtils(), pqtopclass);
                if (QualifierPolymorphism.isPolyAll(qual)) {
                    this.polyQualifiers.put(null, qual);
                } else {
                    this.polyQualifiers.put(pqtop, qual);
                }
            } else {
                this.supertypes.put(qual, AnnotationUtils.createAnnotationSet());
            }
        }

        public void addSubtype(AnnotationMirror sub, AnnotationMirror sup) {
            this.assertNotBuilt();
            this.addQualifier(sub);
            this.addQualifier(sup);
            this.supertypes.get(sub).add(sup);
        }

        public QualifierHierarchy build() {
            this.assertNotBuilt();
            QualifierHierarchy result2 = this.createQualifierHierarchy();
            this.wasBuilt = true;
            return result2;
        }

        protected QualifierHierarchy createQualifierHierarchy() {
            return this.atypeFactory.createQualifierHierarchy(this);
        }

        protected void assertNotBuilt() {
            if (this.wasBuilt) {
                ErrorReporter.errorAbort("MultiGraphQualifierHierarchy.Factory was already built. Method build can only be called once.");
            }
        }
    }
}

