/*
 * Decompiled with CFR 0.152.
 */
package checkers.util.count;

import checkers.source.SourceChecker;
import checkers.source.SourceVisitor;
import checkers.source.SupportedOptions;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WildcardTree;
import com.sun.source.util.TreePath;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;

@SupportedOptions(value={"nolocations", "annotations"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class Locations
extends SourceChecker {
    @Override
    protected SourceVisitor<?, ?> createSourceVisitor() {
        return new Visitor(this);
    }

    static class Visitor
    extends SourceVisitor<Void, Void> {
        private final boolean locations;
        private final boolean annotations;

        public Visitor(Locations l) {
            super(l);
            this.locations = !l.hasOption("nolocations");
            this.annotations = l.hasOption("annotations");
        }

        @Override
        public Void visitAnnotation(AnnotationTree tree2, Void p) {
            if (this.annotations) {
                boolean isBodyAnnotation = false;
                TreePath path = this.getCurrentPath();
                Tree prev = null;
                for (Tree t : path) {
                    if (prev != null && prev.getKind() == Tree.Kind.BLOCK && t.getKind() == Tree.Kind.METHOD) {
                        isBodyAnnotation = true;
                        break;
                    }
                    prev = t;
                }
                System.out.printf(":annotation %s %s %s %s%n", tree2.getAnnotationType(), tree2, this.root.getSourceFile().getName(), isBodyAnnotation ? "body" : "sig");
            }
            return (Void)super.visitAnnotation(tree2, p);
        }

        @Override
        public Void visitArrayType(ArrayTypeTree tree2, Void p) {
            if (this.locations) {
                System.out.println("array type");
            }
            return (Void)super.visitArrayType(tree2, p);
        }

        @Override
        public Void visitClass(ClassTree tree2, Void p) {
            if (this.locations) {
                System.out.println("class");
                if (tree2.getExtendsClause() != null) {
                    System.out.println("class extends");
                }
                for (Tree tree3 : tree2.getImplementsClause()) {
                    System.out.println("class implements");
                }
            }
            return (Void)super.visitClass(tree2, p);
        }

        @Override
        public Void visitMethod(MethodTree tree2, Void p) {
            if (this.locations) {
                System.out.println("method return");
                System.out.println("method receiver");
                for (Tree tree3 : tree2.getThrows()) {
                    System.out.println("method throws");
                }
                for (Tree tree4 : tree2.getParameters()) {
                    System.out.println("method param");
                }
            }
            return (Void)super.visitMethod(tree2, p);
        }

        @Override
        public Void visitVariable(VariableTree tree2, Void p) {
            if (this.locations) {
                System.out.println("variable");
            }
            return (Void)super.visitVariable(tree2, p);
        }

        @Override
        public Void visitMethodInvocation(MethodInvocationTree tree2, Void p) {
            if (this.locations) {
                for (Tree tree3 : tree2.getTypeArguments()) {
                    System.out.println("method invocation type argument");
                }
            }
            return (Void)super.visitMethodInvocation(tree2, p);
        }

        @Override
        public Void visitNewClass(NewClassTree tree2, Void p) {
            if (this.locations) {
                System.out.println("new class");
                for (Tree tree3 : tree2.getTypeArguments()) {
                    System.out.println("new class type argument");
                }
            }
            return (Void)super.visitNewClass(tree2, p);
        }

        @Override
        public Void visitNewArray(NewArrayTree tree2, Void p) {
            if (this.locations) {
                System.out.println("new array");
                for (Tree tree3 : tree2.getDimensions()) {
                    System.out.println("new array dimension");
                }
            }
            return (Void)super.visitNewArray(tree2, p);
        }

        @Override
        public Void visitTypeCast(TypeCastTree tree2, Void p) {
            if (this.locations) {
                System.out.println("typecast");
            }
            return (Void)super.visitTypeCast(tree2, p);
        }

        @Override
        public Void visitInstanceOf(InstanceOfTree tree2, Void p) {
            if (this.locations) {
                System.out.println("instanceof");
            }
            return (Void)super.visitInstanceOf(tree2, p);
        }

        @Override
        public Void visitParameterizedType(ParameterizedTypeTree tree2, Void p) {
            if (this.locations) {
                for (Tree tree3 : tree2.getTypeArguments()) {
                    System.out.println("parameterized type");
                }
            }
            return (Void)super.visitParameterizedType(tree2, p);
        }

        @Override
        public Void visitTypeParameter(TypeParameterTree tree2, Void p) {
            if (this.locations) {
                for (Tree tree3 : tree2.getBounds()) {
                    System.out.println("type parameter bound");
                }
            }
            return (Void)super.visitTypeParameter(tree2, p);
        }

        @Override
        public Void visitWildcard(WildcardTree tree2, Void p) {
            if (this.locations) {
                System.out.println("wildcard");
            }
            return (Void)super.visitWildcard(tree2, p);
        }
    }
}

