/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind;

import com.google.gson.Gson;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonSerializer;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.internal.ConstructorConstructor;
import com.google.gson.internal.bind.TreeTypeAdapter;
import com.google.gson.reflect.TypeToken;

public final class JsonAdapterAnnotationTypeAdapterFactory
implements TypeAdapterFactory {
    private final ConstructorConstructor constructorConstructor;

    public JsonAdapterAnnotationTypeAdapterFactory(ConstructorConstructor constructorConstructor) {
        this.constructorConstructor = constructorConstructor;
    }

    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> targetType) {
        Class<T> rawType = targetType.getRawType();
        JsonAdapter annotation = rawType.getAnnotation(JsonAdapter.class);
        if (annotation == null) {
            return null;
        }
        return this.getTypeAdapter(this.constructorConstructor, gson, targetType, annotation);
    }

    TypeAdapter<?> getTypeAdapter(ConstructorConstructor constructorConstructor, Gson gson, TypeToken<?> type2, JsonAdapter annotation) {
        TypeAdapter<?> typeAdapter;
        Object instance2 = constructorConstructor.get(TypeToken.get(annotation.value())).construct();
        if (instance2 instanceof TypeAdapter) {
            typeAdapter = (TypeAdapter<?>)instance2;
        } else if (instance2 instanceof TypeAdapterFactory) {
            typeAdapter = ((TypeAdapterFactory)instance2).create(gson, type2);
        } else if (instance2 instanceof JsonSerializer || instance2 instanceof JsonDeserializer) {
            JsonSerializer serializer = instance2 instanceof JsonSerializer ? (JsonSerializer)instance2 : null;
            JsonDeserializer deserializer = instance2 instanceof JsonDeserializer ? (JsonDeserializer)instance2 : null;
            typeAdapter = new TreeTypeAdapter(serializer, deserializer, gson, type2, null);
        } else {
            throw new IllegalArgumentException("Invalid attempt to bind an instance of " + instance2.getClass().getName() + " as a @JsonAdapter for " + type2.toString() + ". @JsonAdapter value must be a TypeAdapter, TypeAdapterFactory, JsonSerializer or JsonDeserializer.");
        }
        if (typeAdapter != null && annotation.nullSafe()) {
            typeAdapter = typeAdapter.nullSafe();
        }
        return typeAdapter;
    }
}

