/*
 * Decompiled with CFR 0.152.
 */
package com.moandjiezana.toml;

import com.moandjiezana.toml.Context;
import com.moandjiezana.toml.Results;
import com.moandjiezana.toml.ValueReader;
import com.moandjiezana.toml.ValueWriter;
import com.moandjiezana.toml.WriterContext;
import java.util.concurrent.atomic.AtomicInteger;

class NumberValueReaderWriter
implements ValueReader,
ValueWriter {
    static final NumberValueReaderWriter NUMBER_VALUE_READER_WRITER = new NumberValueReaderWriter();

    NumberValueReaderWriter() {
    }

    @Override
    public boolean canRead(String s2) {
        char firstChar = s2.charAt(0);
        return firstChar == '+' || firstChar == '-' || Character.isDigit(firstChar);
    }

    @Override
    public Object read(String s2, AtomicInteger index, Context context) {
        boolean signable = true;
        boolean dottable = false;
        boolean exponentable = false;
        boolean terminatable = false;
        boolean underscorable = false;
        String type2 = "";
        StringBuilder sb = new StringBuilder();
        int i = index.get();
        while (i < s2.length()) {
            boolean notLastChar;
            char c = s2.charAt(i);
            boolean bl = notLastChar = s2.length() > i + 1;
            if (Character.isDigit(c)) {
                sb.append(c);
                signable = false;
                terminatable = true;
                if (type2.isEmpty()) {
                    type2 = "integer";
                    dottable = true;
                }
                underscorable = notLastChar;
                exponentable = !type2.equals("exponent");
            } else if ((c == '+' || c == '-') && signable && notLastChar) {
                signable = false;
                terminatable = false;
                if (c == '-') {
                    sb.append('-');
                }
            } else if (c == '.' && dottable && notLastChar) {
                sb.append('.');
                type2 = "float";
                terminatable = false;
                dottable = false;
                exponentable = false;
                underscorable = false;
            } else if ((c == 'E' || c == 'e') && exponentable && notLastChar) {
                sb.append('E');
                type2 = "exponent";
                terminatable = false;
                signable = true;
                dottable = false;
                exponentable = false;
                underscorable = false;
            } else if (c == '_' && underscorable && notLastChar && Character.isDigit(s2.charAt(i + 1))) {
                underscorable = false;
            } else {
                if (!terminatable) {
                    type2 = "";
                }
                index.decrementAndGet();
                break;
            }
            i = index.incrementAndGet();
        }
        if (type2.equals("integer")) {
            return Long.valueOf(sb.toString());
        }
        if (type2.equals("float")) {
            return Double.valueOf(sb.toString());
        }
        if (type2.equals("exponent")) {
            String[] exponentString = sb.toString().split("E");
            return Double.parseDouble(exponentString[0]) * Math.pow(10.0, Double.parseDouble(exponentString[1]));
        }
        Results.Errors errors = new Results.Errors();
        errors.invalidValue(context.identifier.getName(), sb.toString(), context.line.get());
        return errors;
    }

    @Override
    public boolean canWrite(Object value2) {
        return Number.class.isInstance(value2);
    }

    @Override
    public void write(Object value2, WriterContext context) {
        context.write(value2.toString());
    }

    @Override
    public boolean isPrimitiveType() {
        return true;
    }

    public String toString() {
        return "number";
    }
}

