/*
 * Decompiled with CFR 0.152.
 */
package com.moandjiezana.toml;

import com.moandjiezana.toml.MapValueWriter;
import com.moandjiezana.toml.ValueWriter;
import com.moandjiezana.toml.WriterContext;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;

class ObjectValueWriter
implements ValueWriter {
    static final ValueWriter OBJECT_VALUE_WRITER = new ObjectValueWriter();

    @Override
    public boolean canWrite(Object value2) {
        return true;
    }

    @Override
    public void write(Object value2, WriterContext context) {
        LinkedHashMap<String, Object> to = new LinkedHashMap<String, Object>();
        Set<Field> fields2 = ObjectValueWriter.getFields(value2.getClass());
        for (Field field : fields2) {
            to.put(field.getName(), ObjectValueWriter.getFieldValue(field, value2));
        }
        MapValueWriter.MAP_VALUE_WRITER.write(to, context);
    }

    @Override
    public boolean isPrimitiveType() {
        return false;
    }

    private static Set<Field> getFields(Class<?> cls) {
        LinkedHashSet<Field> fields2 = new LinkedHashSet<Field>(Arrays.asList(cls.getDeclaredFields()));
        while (cls != Object.class) {
            fields2.addAll(Arrays.asList(cls.getDeclaredFields()));
            cls = cls.getSuperclass();
        }
        ObjectValueWriter.removeConstantsAndSyntheticFields(fields2);
        return fields2;
    }

    private static void removeConstantsAndSyntheticFields(Set<Field> fields2) {
        Iterator<Field> iterator2 = fields2.iterator();
        while (iterator2.hasNext()) {
            Field field = iterator2.next();
            if ((!Modifier.isFinal(field.getModifiers()) || !Modifier.isStatic(field.getModifiers())) && !field.isSynthetic() && !Modifier.isTransient(field.getModifiers())) continue;
            iterator2.remove();
        }
    }

    private static Object getFieldValue(Field field, Object o) {
        boolean isAccessible = field.isAccessible();
        field.setAccessible(true);
        Object value2 = null;
        try {
            value2 = field.get(o);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        field.setAccessible(isAccessible);
        return value2;
    }

    private ObjectValueWriter() {
    }
}

