/*
 * Decompiled with CFR 0.152.
 */
package com.sun.msv.datatype.xsd;

import com.sun.msv.datatype.SerializationContext;
import com.sun.msv.datatype.xsd.FloatingNumberType;
import com.sun.msv.datatype.xsd.SimpleURType;
import com.sun.msv.datatype.xsd.XSDatatype;
import org.relaxng.datatype.ValidationContext;

public class FloatType
extends FloatingNumberType {
    public static final FloatType theInstance = new FloatType();
    private static final long serialVersionUID = 1L;

    private FloatType() {
        super("float");
    }

    public final XSDatatype getBaseType() {
        return SimpleURType.theInstance;
    }

    public Object _createValue(String lexicalValue, ValidationContext context) {
        return FloatType.load(lexicalValue);
    }

    public static Float load(String s2) {
        try {
            if (s2.equals("NaN")) {
                return new Float(Float.NaN);
            }
            if (s2.equals("INF")) {
                return new Float(Float.POSITIVE_INFINITY);
            }
            if (s2.equals("-INF")) {
                return new Float(Float.NEGATIVE_INFINITY);
            }
            if (s2.length() == 0 || !FloatType.isDigitOrPeriodOrSign(s2.charAt(0)) || !FloatType.isDigitOrPeriodOrSign(s2.charAt(s2.length() - 1))) {
                return null;
            }
            return Float.valueOf(s2);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public Class getJavaObjectType() {
        return Float.class;
    }

    public String convertToLexicalValue(Object value2, SerializationContext context) {
        if (!(value2 instanceof Float)) {
            throw new IllegalArgumentException();
        }
        return FloatType.save((Float)value2);
    }

    public static String save(Float value2) {
        float v = value2.floatValue();
        if (Float.isNaN(v)) {
            return "NaN";
        }
        if (v == Float.POSITIVE_INFINITY) {
            return "INF";
        }
        if (v == Float.NEGATIVE_INFINITY) {
            return "-INF";
        }
        return value2.toString();
    }
}

