/*
 * Decompiled with CFR 0.152.
 */
package com.uchuhimo.konf.source.hocon;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.uchuhimo.konf.source.Provider;
import com.uchuhimo.konf.source.RegisterExtension;
import com.uchuhimo.konf.source.Source;
import com.uchuhimo.konf.source.hocon.HoconSource;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@RegisterExtension(value={"conf"})
@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0000H\u0007J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/uchuhimo/konf/source/hocon/HoconProvider;", "Lcom/uchuhimo/konf/source/Provider;", "()V", "get", "inputStream", "Lcom/uchuhimo/konf/source/Source;", "Ljava/io/InputStream;", "reader", "Ljava/io/Reader;", "konf-hocon"})
public final class HoconProvider
implements Provider {
    public static final HoconProvider INSTANCE;

    @Override
    @NotNull
    public Source reader(@NotNull Reader reader) {
        Intrinsics.checkParameterIsNotNull(reader, "reader");
        Config config = ConfigFactory.parseReader(reader).resolve();
        Intrinsics.checkExpressionValueIsNotNull(config, "ConfigFactory.parseReader(reader).resolve()");
        return new HoconSource(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Source inputStream(@NotNull InputStream inputStream) {
        Intrinsics.checkParameterIsNotNull(inputStream, "inputStream");
        Closeable closeable = inputStream;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        closeable = new InputStreamReader((InputStream)closeable, charset);
        boolean bl2 = false;
        bl = false;
        Throwable throwable = null;
        try {
            InputStreamReader it = (InputStreamReader)closeable;
            boolean bl3 = false;
            Source source = INSTANCE.reader(it);
            return source;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }

    @JvmStatic
    @NotNull
    public static final HoconProvider get() {
        return INSTANCE;
    }

    private HoconProvider() {
    }

    static {
        HoconProvider hoconProvider;
        INSTANCE = hoconProvider = new HoconProvider();
    }

    @Override
    @NotNull
    public Source bytes(@NotNull byte[] content) {
        Intrinsics.checkParameterIsNotNull(content, "content");
        return Provider.DefaultImpls.bytes(this, content);
    }

    @Override
    @NotNull
    public Source bytes(@NotNull byte[] content, int offset, int length2) {
        Intrinsics.checkParameterIsNotNull(content, "content");
        return Provider.DefaultImpls.bytes(this, content, offset, length2);
    }

    @Override
    @NotNull
    public Source file(@NotNull File file2, boolean optional2) {
        Intrinsics.checkParameterIsNotNull(file2, "file");
        return Provider.DefaultImpls.file((Provider)this, file2, optional2);
    }

    @Override
    @NotNull
    public Source file(@NotNull String file2, boolean optional2) {
        Intrinsics.checkParameterIsNotNull(file2, "file");
        return Provider.DefaultImpls.file((Provider)this, file2, optional2);
    }

    @Override
    @NotNull
    public Provider map(@NotNull Function1<? super Source, ? extends Source> transform2) {
        Intrinsics.checkParameterIsNotNull(transform2, "transform");
        return Provider.DefaultImpls.map(this, transform2);
    }

    @Override
    @NotNull
    public Source resource(@NotNull String resource2, boolean optional2) {
        Intrinsics.checkParameterIsNotNull(resource2, "resource");
        return Provider.DefaultImpls.resource(this, resource2, optional2);
    }

    @Override
    @NotNull
    public Source string(@NotNull String content) {
        Intrinsics.checkParameterIsNotNull(content, "content");
        return Provider.DefaultImpls.string(this, content);
    }

    @Override
    @NotNull
    public Source url(@NotNull URL url2, boolean optional2) {
        Intrinsics.checkParameterIsNotNull(url2, "url");
        return Provider.DefaultImpls.url((Provider)this, url2, optional2);
    }

    @Override
    @NotNull
    public Source url(@NotNull String url2, boolean optional2) {
        Intrinsics.checkParameterIsNotNull(url2, "url");
        return Provider.DefaultImpls.url((Provider)this, url2, optional2);
    }
}

