/*
 * Decompiled with CFR 0.152.
 */
package dataflow.analysis;

import dataflow.analysis.AbstractValue;
import dataflow.analysis.Store;
import dataflow.analysis.TransferResult;
import java.util.Map;
import javax.lang.model.type.TypeMirror;

public class ConditionalTransferResult<A extends AbstractValue<A>, S extends Store<S>>
extends TransferResult<A, S> {
    protected S thenStore;
    protected S elseStore;

    public ConditionalTransferResult(A value2, S thenStore, S elseStore) {
        super(value2);
        this.thenStore = thenStore;
        this.elseStore = elseStore;
    }

    public ConditionalTransferResult(A value2, S thenStore, S elseStore, Map<TypeMirror, S> exceptionalStores) {
        super(value2);
        this.exceptionalStores = exceptionalStores;
        this.thenStore = thenStore;
        this.elseStore = elseStore;
    }

    @Override
    public S getRegularStore() {
        return this.thenStore.leastUpperBound(this.elseStore);
    }

    @Override
    public S getThenStore() {
        return this.thenStore;
    }

    @Override
    public S getElseStore() {
        return this.elseStore;
    }

    @Override
    public boolean containsTwoStores() {
        return true;
    }

    public String toString() {
        StringBuilder result2 = new StringBuilder();
        result2.append("RegularTransferResult(");
        result2.append(System.getProperty("line.separator"));
        result2.append("resultValue = " + this.resultValue);
        result2.append(System.getProperty("line.separator"));
        result2.append("thenStore = " + this.thenStore);
        result2.append("elseStore = " + this.elseStore);
        result2.append(System.getProperty("line.separator"));
        result2.append(")");
        return result2.toString();
    }
}

