/*
 * Decompiled with CFR 0.152.
 */
package dataflow.cfg.node;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import dataflow.cfg.node.Node;
import javacutils.TreeUtils;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;

public abstract class AssignmentContext {
    public abstract Element getElementForType();

    public abstract Tree getContextTree();

    public static class MethodReturnContext
    extends AssignmentContext {
        protected final ExecutableElement method;
        protected final Tree ret;

        public MethodReturnContext(MethodTree method) {
            this.method = TreeUtils.elementFromDeclaration(method);
            this.ret = method.getReturnType();
        }

        @Override
        public Element getElementForType() {
            return this.method;
        }

        @Override
        public Tree getContextTree() {
            return this.ret;
        }
    }

    public static class MethodParameterContext
    extends AssignmentContext {
        protected final ExecutableElement method;
        protected final int paramNum;

        public MethodParameterContext(ExecutableElement method, int paramNum) {
            this.method = method;
            this.paramNum = paramNum;
        }

        @Override
        public Element getElementForType() {
            return this.method.getParameters().get(this.paramNum);
        }

        @Override
        public Tree getContextTree() {
            return null;
        }
    }

    public static class AssignmentLhsContext
    extends AssignmentContext {
        protected final Node node;

        public AssignmentLhsContext(Node node) {
            this.node = node;
        }

        @Override
        public Element getElementForType() {
            Tree tree2 = this.node.getTree();
            if (tree2 == null) {
                return null;
            }
            if (tree2 instanceof ExpressionTree) {
                return TreeUtils.elementFromUse((ExpressionTree)tree2);
            }
            if (tree2 instanceof VariableTree) {
                return TreeUtils.elementFromDeclaration((VariableTree)tree2);
            }
            assert (false) : "unexpected tree";
            return null;
        }

        @Override
        public Tree getContextTree() {
            return this.node.getTree();
        }
    }
}

