/*
 * Decompiled with CFR 0.152.
 */
package dataflow.cfg.node;

import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.Tree;
import dataflow.cfg.node.Node;
import dataflow.cfg.node.NodeVisitor;
import dataflow.util.HashCodeUtils;
import java.util.Collection;
import java.util.Collections;
import javacutils.ElementUtils;
import javacutils.InternalUtils;
import javacutils.TreeUtils;
import javax.lang.model.element.VariableElement;

public class FieldAccessNode
extends Node {
    protected Tree tree;
    protected VariableElement element;
    protected String field;
    protected Node receiver;

    public FieldAccessNode(Tree tree2, Node receiver) {
        super(InternalUtils.typeOf(tree2));
        assert (TreeUtils.isFieldAccess(tree2));
        this.tree = tree2;
        this.receiver = receiver;
        this.field = TreeUtils.getFieldName(tree2);
        if (tree2 instanceof MemberSelectTree) {
            this.element = (VariableElement)TreeUtils.elementFromUse((MemberSelectTree)tree2);
        } else {
            assert (tree2 instanceof IdentifierTree);
            this.element = (VariableElement)TreeUtils.elementFromUse((IdentifierTree)tree2);
        }
    }

    public FieldAccessNode(VariableElement element, Node receiver) {
        super(element.asType());
        this.tree = null;
        this.element = element;
        this.receiver = receiver;
        this.field = element.getSimpleName().toString();
    }

    public VariableElement getElement() {
        return this.element;
    }

    public Node getReceiver() {
        return this.receiver;
    }

    public String getFieldName() {
        return this.field;
    }

    @Override
    public Tree getTree() {
        return this.tree;
    }

    @Override
    public <R, P> R accept(NodeVisitor<R, P> visitor2, P p) {
        return visitor2.visitFieldAccess(this, p);
    }

    public String toString() {
        return this.getReceiver() + "." + this.field;
    }

    public boolean isStatic() {
        return ElementUtils.isStatic(this.getElement());
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof FieldAccessNode)) {
            return false;
        }
        FieldAccessNode other = (FieldAccessNode)obj;
        return this.getReceiver().equals(other.getReceiver()) && this.getFieldName().equals(other.getFieldName());
    }

    public int hashCode() {
        return HashCodeUtils.hash(this.getReceiver(), this.getFieldName());
    }

    @Override
    public Collection<Node> getOperands() {
        return Collections.singletonList(this.receiver);
    }
}

