/*
 * Decompiled with CFR 0.152.
 */
package dataflow.cfg.node;

import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.util.TreePath;
import dataflow.cfg.node.AssignmentContext;
import dataflow.cfg.node.MethodAccessNode;
import dataflow.cfg.node.Node;
import dataflow.cfg.node.NodeVisitor;
import dataflow.util.HashCodeUtils;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javacutils.InternalUtils;

public class MethodInvocationNode
extends Node {
    protected MethodInvocationTree tree;
    protected MethodAccessNode target;
    protected List<Node> arguments;
    protected TreePath treePath;

    public MethodInvocationNode(MethodInvocationTree tree2, MethodAccessNode target, List<Node> arguments2, TreePath treePath) {
        super(tree2 != null ? InternalUtils.typeOf(tree2) : target.getMethod().getReturnType());
        this.tree = tree2;
        this.target = target;
        this.arguments = arguments2;
        this.treePath = treePath;
        int i = 0;
        for (Node arg : arguments2) {
            AssignmentContext.MethodParameterContext ctx = new AssignmentContext.MethodParameterContext(target.getMethod(), i++);
            arg.setAssignmentContext(ctx);
        }
    }

    public MethodInvocationNode(MethodAccessNode target, List<Node> arguments2, TreePath treePath) {
        this(null, target, arguments2, treePath);
    }

    public MethodAccessNode getTarget() {
        return this.target;
    }

    public List<Node> getArguments() {
        return this.arguments;
    }

    public Node getArgument(int i) {
        return this.arguments.get(i);
    }

    public TreePath getTreePath() {
        return this.treePath;
    }

    @Override
    public MethodInvocationTree getTree() {
        return this.tree;
    }

    @Override
    public <R, P> R accept(NodeVisitor<R, P> visitor2, P p) {
        return visitor2.visitMethodInvocation(this, p);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.target);
        sb.append("(");
        boolean needComma = false;
        for (Node arg : this.arguments) {
            if (needComma) {
                sb.append(", ");
            }
            sb.append(arg);
            needComma = true;
        }
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof MethodInvocationNode)) {
            return false;
        }
        MethodInvocationNode other = (MethodInvocationNode)obj;
        return this.getTarget().equals(other.getTarget()) && this.getArguments().equals(other.getArguments());
    }

    public int hashCode() {
        int hash2 = 0;
        hash2 = HashCodeUtils.hash((Object)this.target);
        for (Node arg : this.arguments) {
            hash2 = HashCodeUtils.hash(hash2, arg.hashCode());
        }
        return hash2;
    }

    @Override
    public Collection<Node> getOperands() {
        LinkedList<Node> list2 = new LinkedList<Node>();
        list2.add(this.target);
        list2.addAll(this.arguments);
        return list2;
    }
}

