/*
 * Decompiled with CFR 0.152.
 */
package dataflow.cfg.node;

import com.sun.source.tree.Tree;
import dataflow.cfg.block.Block;
import dataflow.cfg.node.AssignmentContext;
import dataflow.cfg.node.NodeVisitor;
import java.util.Collection;
import java.util.LinkedList;
import javax.lang.model.type.TypeMirror;

public abstract class Node {
    protected Block block;
    protected boolean lvalue = false;
    protected AssignmentContext assignmentContext;
    protected boolean inSource = true;
    protected final TypeMirror type;

    public Node(TypeMirror type2) {
        assert (type2 != null);
        this.type = type2;
    }

    public Block getBlock() {
        return this.block;
    }

    public void setBlock(Block b) {
        this.block = b;
    }

    public abstract Tree getTree();

    public TypeMirror getType() {
        return this.type;
    }

    public abstract <R, P> R accept(NodeVisitor<R, P> var1, P var2);

    public boolean isLValue() {
        return this.lvalue;
    }

    public void setLValue() {
        this.lvalue = true;
    }

    public boolean getInSource() {
        return this.inSource;
    }

    public void setInSource(boolean inSrc) {
        this.inSource = inSrc;
    }

    public AssignmentContext getAssignmentContext() {
        return this.assignmentContext;
    }

    public void setAssignmentContext(AssignmentContext assignmentContext) {
        this.assignmentContext = assignmentContext;
    }

    public abstract Collection<Node> getOperands();

    public Collection<Node> getTransitiveOperands() {
        LinkedList<Node> operands = new LinkedList<Node>(this.getOperands());
        LinkedList<Node> transitiveOperands = new LinkedList<Node>();
        while (!operands.isEmpty()) {
            Node next = operands.removeFirst();
            operands.addAll(next.getOperands());
            transitiveOperands.add(next);
        }
        return transitiveOperands;
    }
}

