/*
 * Decompiled with CFR 0.152.
 */
package dataflow.cfg.node;

import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import dataflow.cfg.node.Node;
import dataflow.cfg.node.NodeVisitor;
import dataflow.util.HashCodeUtils;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javacutils.InternalUtils;

public class ObjectCreationNode
extends Node {
    protected NewClassTree tree;
    protected Node constructor;
    protected List<Node> arguments;

    public ObjectCreationNode(NewClassTree tree2, Node constructor, List<Node> arguments2) {
        super(InternalUtils.typeOf(tree2));
        this.tree = tree2;
        this.constructor = constructor;
        this.arguments = arguments2;
    }

    public Node getConstructor() {
        return this.constructor;
    }

    public List<Node> getArguments() {
        return this.arguments;
    }

    public Node getArgument(int i) {
        return this.arguments.get(i);
    }

    @Override
    public Tree getTree() {
        return this.tree;
    }

    @Override
    public <R, P> R accept(NodeVisitor<R, P> visitor2, P p) {
        return visitor2.visitObjectCreation(this, p);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("new " + this.constructor + "(");
        boolean needComma = false;
        for (Node arg : this.arguments) {
            if (needComma) {
                sb.append(", ");
            }
            sb.append(arg);
            needComma = true;
        }
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ObjectCreationNode)) {
            return false;
        }
        ObjectCreationNode other = (ObjectCreationNode)obj;
        if (this.constructor == null && other.getConstructor() != null) {
            return false;
        }
        return this.getConstructor().equals(other.getConstructor()) && this.getArguments().equals(other.getArguments());
    }

    public int hashCode() {
        int hash2 = HashCodeUtils.hash((Object)this.constructor);
        for (Node arg : this.arguments) {
            hash2 = HashCodeUtils.hash(hash2, arg.hashCode());
        }
        return hash2;
    }

    @Override
    public Collection<Node> getOperands() {
        LinkedList<Node> list2 = new LinkedList<Node>();
        list2.add(this.constructor);
        list2.addAll(this.arguments);
        return list2;
    }
}

