/*
 * Decompiled with CFR 0.152.
 */
package javassist.bytecode;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.Map;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ByteArray;
import javassist.bytecode.ConstPool;

public class BootstrapMethodsAttribute
extends AttributeInfo {
    public static final String tag = "BootstrapMethods";

    BootstrapMethodsAttribute(ConstPool cp, int n, DataInputStream in) throws IOException {
        super(cp, n, in);
    }

    public BootstrapMethodsAttribute(ConstPool cp, BootstrapMethod[] methods2) {
        super(cp, tag);
        int size2 = 2;
        for (int i = 0; i < methods2.length; ++i) {
            size2 += 4 + methods2[i].arguments.length * 2;
        }
        byte[] data2 = new byte[size2];
        ByteArray.write16bit(methods2.length, data2, 0);
        int pos = 2;
        for (int i = 0; i < methods2.length; ++i) {
            ByteArray.write16bit(methods2[i].methodRef, data2, pos);
            ByteArray.write16bit(methods2[i].arguments.length, data2, pos + 2);
            int[] args2 = methods2[i].arguments;
            pos += 4;
            for (int k = 0; k < args2.length; ++k) {
                ByteArray.write16bit(args2[k], data2, pos);
                pos += 2;
            }
        }
        this.set(data2);
    }

    public BootstrapMethod[] getMethods() {
        byte[] data2 = this.get();
        int num = ByteArray.readU16bit(data2, 0);
        BootstrapMethod[] methods2 = new BootstrapMethod[num];
        int pos = 2;
        for (int i = 0; i < num; ++i) {
            int ref = ByteArray.readU16bit(data2, pos);
            int len = ByteArray.readU16bit(data2, pos + 2);
            int[] args2 = new int[len];
            pos += 4;
            for (int k = 0; k < len; ++k) {
                args2[k] = ByteArray.readU16bit(data2, pos);
                pos += 2;
            }
            methods2[i] = new BootstrapMethod(ref, args2);
        }
        return methods2;
    }

    @Override
    public AttributeInfo copy(ConstPool newCp, Map<String, String> classnames) {
        BootstrapMethod[] methods2 = this.getMethods();
        ConstPool thisCp = this.getConstPool();
        for (int i = 0; i < methods2.length; ++i) {
            BootstrapMethod m3 = methods2[i];
            m3.methodRef = thisCp.copy(m3.methodRef, newCp, classnames);
            for (int k = 0; k < m3.arguments.length; ++k) {
                m3.arguments[k] = thisCp.copy(m3.arguments[k], newCp, classnames);
            }
        }
        return new BootstrapMethodsAttribute(newCp, methods2);
    }

    public static class BootstrapMethod {
        public int methodRef;
        public int[] arguments;

        public BootstrapMethod(int method, int[] args2) {
            this.methodRef = method;
            this.arguments = args2;
        }
    }
}

