/*
 * Decompiled with CFR 0.152.
 */
package javax.mail;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.EventListener;
import java.util.Vector;
import java.util.concurrent.Executor;
import javax.mail.AuthenticationFailedException;
import javax.mail.EventQueue;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.URLName;
import javax.mail.event.ConnectionEvent;
import javax.mail.event.ConnectionListener;
import javax.mail.event.MailEvent;

public abstract class Service
implements AutoCloseable {
    protected Session session;
    protected volatile URLName url = null;
    protected boolean debug = false;
    private boolean connected = false;
    private final Vector<ConnectionListener> connectionListeners = new Vector();
    private final EventQueue q;

    protected Service(Session session, URLName urlname) {
        this.session = session;
        this.debug = session.getDebug();
        this.url = urlname;
        String protocol = null;
        String host = null;
        int port = -1;
        String user2 = null;
        String password2 = null;
        String file2 = null;
        if (this.url != null) {
            protocol = this.url.getProtocol();
            host = this.url.getHost();
            port = this.url.getPort();
            user2 = this.url.getUsername();
            password2 = this.url.getPassword();
            file2 = this.url.getFile();
        }
        if (protocol != null) {
            if (host == null) {
                host = session.getProperty("mail." + protocol + ".host");
            }
            if (user2 == null) {
                user2 = session.getProperty("mail." + protocol + ".user");
            }
        }
        if (host == null) {
            host = session.getProperty("mail.host");
        }
        if (user2 == null) {
            user2 = session.getProperty("mail.user");
        }
        if (user2 == null) {
            try {
                user2 = System.getProperty("user.name");
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        this.url = new URLName(protocol, host, port, file2, user2, password2);
        String scope2 = session.getProperties().getProperty("mail.event.scope", "folder");
        Executor executor2 = (Executor)session.getProperties().get("mail.event.executor");
        this.q = scope2.equalsIgnoreCase("application") ? EventQueue.getApplicationEventQueue(executor2) : (scope2.equalsIgnoreCase("session") ? session.getEventQueue() : new EventQueue(executor2));
    }

    public void connect() throws MessagingException {
        this.connect(null, null, null);
    }

    public void connect(String host, String user2, String password2) throws MessagingException {
        this.connect(host, -1, user2, password2);
    }

    public void connect(String user2, String password2) throws MessagingException {
        this.connect(null, user2, password2);
    }

    public synchronized void connect(String host, int port, String user2, String password2) throws MessagingException {
        PasswordAuthentication pw;
        if (this.isConnected()) {
            throw new IllegalStateException("already connected");
        }
        boolean connected = false;
        boolean save = false;
        String protocol = null;
        String file2 = null;
        if (this.url != null) {
            protocol = this.url.getProtocol();
            if (host == null) {
                host = this.url.getHost();
            }
            if (port == -1) {
                port = this.url.getPort();
            }
            if (user2 == null) {
                user2 = this.url.getUsername();
                if (password2 == null) {
                    password2 = this.url.getPassword();
                }
            } else if (password2 == null && user2.equals(this.url.getUsername())) {
                password2 = this.url.getPassword();
            }
            file2 = this.url.getFile();
        }
        if (protocol != null) {
            if (host == null) {
                host = this.session.getProperty("mail." + protocol + ".host");
            }
            if (user2 == null) {
                user2 = this.session.getProperty("mail." + protocol + ".user");
            }
        }
        if (host == null) {
            host = this.session.getProperty("mail.host");
        }
        if (user2 == null) {
            user2 = this.session.getProperty("mail.user");
        }
        if (user2 == null) {
            try {
                user2 = System.getProperty("user.name");
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        if (password2 == null && this.url != null) {
            this.setURLName(new URLName(protocol, host, port, file2, user2, null));
            pw = this.session.getPasswordAuthentication(this.getURLName());
            if (pw != null) {
                if (user2 == null) {
                    user2 = pw.getUserName();
                    password2 = pw.getPassword();
                } else if (user2.equals(pw.getUserName())) {
                    password2 = pw.getPassword();
                }
            } else {
                save = true;
            }
        }
        AuthenticationFailedException authEx = null;
        try {
            connected = this.protocolConnect(host, port, user2, password2);
        }
        catch (AuthenticationFailedException ex) {
            authEx = ex;
        }
        if (!connected) {
            InetAddress addr;
            try {
                addr = InetAddress.getByName(host);
            }
            catch (UnknownHostException e) {
                addr = null;
            }
            pw = this.session.requestPasswordAuthentication(addr, port, protocol, null, user2);
            if (pw != null) {
                user2 = pw.getUserName();
                password2 = pw.getPassword();
                connected = this.protocolConnect(host, port, user2, password2);
            }
        }
        if (!connected) {
            if (authEx != null) {
                throw authEx;
            }
            if (user2 == null) {
                throw new AuthenticationFailedException("failed to connect, no user name specified?");
            }
            if (password2 == null) {
                throw new AuthenticationFailedException("failed to connect, no password specified?");
            }
            throw new AuthenticationFailedException("failed to connect");
        }
        this.setURLName(new URLName(protocol, host, port, file2, user2, password2));
        if (save) {
            this.session.setPasswordAuthentication(this.getURLName(), new PasswordAuthentication(user2, password2));
        }
        this.setConnected(true);
        this.notifyConnectionListeners(1);
    }

    protected boolean protocolConnect(String host, int port, String user2, String password2) throws MessagingException {
        return false;
    }

    public synchronized boolean isConnected() {
        return this.connected;
    }

    protected synchronized void setConnected(boolean connected) {
        this.connected = connected;
    }

    @Override
    public synchronized void close() throws MessagingException {
        this.setConnected(false);
        this.notifyConnectionListeners(3);
    }

    public URLName getURLName() {
        URLName url2 = this.url;
        if (url2 != null && (url2.getPassword() != null || url2.getFile() != null)) {
            return new URLName(url2.getProtocol(), url2.getHost(), url2.getPort(), null, url2.getUsername(), null);
        }
        return url2;
    }

    protected void setURLName(URLName url2) {
        this.url = url2;
    }

    public void addConnectionListener(ConnectionListener l) {
        this.connectionListeners.addElement(l);
    }

    public void removeConnectionListener(ConnectionListener l) {
        this.connectionListeners.removeElement(l);
    }

    protected void notifyConnectionListeners(int type2) {
        if (this.connectionListeners.size() > 0) {
            ConnectionEvent e = new ConnectionEvent(this, type2);
            this.queueEvent(e, this.connectionListeners);
        }
        if (type2 == 3) {
            this.q.terminateQueue();
        }
    }

    public String toString() {
        URLName url2 = this.getURLName();
        if (url2 != null) {
            return url2.toString();
        }
        return super.toString();
    }

    protected void queueEvent(MailEvent event, Vector<? extends EventListener> vector) {
        Vector v = (Vector)vector.clone();
        this.q.enqueue(event, v);
    }

    protected void finalize() throws Throwable {
        try {
            this.q.terminateQueue();
        }
        finally {
            super.finalize();
        }
    }

    Session getSession() {
        return this.session;
    }

    EventQueue getEventQueue() {
        return this.q;
    }
}

