/*
 * Decompiled with CFR 0.152.
 */
package nonapi.io.github.classgraph.classloaderhandler;

import io.github.classgraph.ClassGraphClassLoader;
import java.net.URL;
import nonapi.io.github.classgraph.classloaderhandler.ClassLoaderHandler;
import nonapi.io.github.classgraph.classpath.ClassLoaderOrder;
import nonapi.io.github.classgraph.classpath.ClasspathOrder;
import nonapi.io.github.classgraph.scanspec.ScanSpec;
import nonapi.io.github.classgraph.utils.LogNode;

class ClassGraphClassLoaderHandler
implements ClassLoaderHandler {
    private ClassGraphClassLoaderHandler() {
    }

    public static boolean canHandle(Class<?> classLoaderClass, LogNode log) {
        boolean matches = "io.github.classgraph.ClassGraphClassLoader".equals(classLoaderClass.getName());
        if (matches && log != null) {
            log.log("Sharing a `ClassGraphClassLoader` between multiple nested scans is not advisable, because scan criteria may differ between scans. See: https://github.com/classgraph/classgraph/issues/485");
        }
        return matches;
    }

    public static void findClassLoaderOrder(ClassLoader classLoader2, ClassLoaderOrder classLoaderOrder, LogNode log) {
        classLoaderOrder.delegateTo(classLoader2.getParent(), true, log);
        classLoaderOrder.add(classLoader2, log);
    }

    public static void findClasspathOrder(ClassLoader classLoader2, ClasspathOrder classpathOrder, ScanSpec scanSpec, LogNode log) {
        for (URL url2 : ((ClassGraphClassLoader)classLoader2).getURLs()) {
            if (url2 == null) continue;
            classpathOrder.addClasspathEntry((Object)url2, classLoader2, scanSpec, log);
        }
    }
}

