/*
 * Decompiled with CFR 0.152.
 */
package nonapi.io.github.classgraph.classloaderhandler;

import java.lang.reflect.Array;
import java.util.HashSet;
import java.util.Set;
import nonapi.io.github.classgraph.classloaderhandler.ClassLoaderHandler;
import nonapi.io.github.classgraph.classpath.ClassLoaderOrder;
import nonapi.io.github.classgraph.classpath.ClasspathOrder;
import nonapi.io.github.classgraph.scanspec.ScanSpec;
import nonapi.io.github.classgraph.utils.LogNode;
import nonapi.io.github.classgraph.utils.ReflectionUtils;

class EquinoxClassLoaderHandler
implements ClassLoaderHandler {
    private static boolean alreadyReadSystemBundles;
    private static final String[] FIELD_NAMES;

    private EquinoxClassLoaderHandler() {
    }

    public static boolean canHandle(Class<?> classLoaderClass, LogNode log) {
        return "org.eclipse.osgi.internal.loader.EquinoxClassLoader".equals(classLoaderClass.getName());
    }

    public static void findClassLoaderOrder(ClassLoader classLoader2, ClassLoaderOrder classLoaderOrder, LogNode log) {
        classLoaderOrder.delegateTo(classLoader2.getParent(), true, log);
        classLoaderOrder.add(classLoader2, log);
    }

    private static void addBundleFile(Object bundlefile, Set<Object> path, ClassLoader classLoader2, ClasspathOrder classpathOrderOut, ScanSpec scanSpec, LogNode log) {
        if (bundlefile != null && path.add(bundlefile)) {
            Object baseFile = ReflectionUtils.getFieldVal(bundlefile, "basefile", false);
            if (baseFile != null) {
                boolean foundClassPathElement = false;
                for (String fieldName : FIELD_NAMES) {
                    Object baseBundleFile;
                    Object fieldVal = ReflectionUtils.getFieldVal(bundlefile, fieldName, false);
                    if (fieldVal == null) continue;
                    foundClassPathElement = true;
                    Object base = baseFile;
                    String sep = "/";
                    if (bundlefile.getClass().getName().equals("org.eclipse.osgi.storage.bundlefile.NestedDirBundleFile") && (baseBundleFile = ReflectionUtils.getFieldVal(bundlefile, "baseBundleFile", false)) != null && baseBundleFile.getClass().getName().equals("org.eclipse.osgi.storage.bundlefile.ZipBundleFile")) {
                        base = baseBundleFile;
                        sep = "!/";
                    }
                    String pathElement = base.toString() + sep + fieldVal.toString();
                    classpathOrderOut.addClasspathEntry((Object)pathElement, classLoader2, scanSpec, log);
                    break;
                }
                if (!foundClassPathElement) {
                    classpathOrderOut.addClasspathEntry((Object)baseFile.toString(), classLoader2, scanSpec, log);
                }
            }
            EquinoxClassLoaderHandler.addBundleFile(ReflectionUtils.getFieldVal(bundlefile, "wrapped", false), path, classLoader2, classpathOrderOut, scanSpec, log);
            EquinoxClassLoaderHandler.addBundleFile(ReflectionUtils.getFieldVal(bundlefile, "next", false), path, classLoader2, classpathOrderOut, scanSpec, log);
        }
    }

    private static void addClasspathEntries(Object owner, ClassLoader classLoader2, ClasspathOrder classpathOrderOut, ScanSpec scanSpec, LogNode log) {
        Object entries2 = ReflectionUtils.getFieldVal(owner, "entries", false);
        if (entries2 != null) {
            int n = Array.getLength(entries2);
            for (int i = 0; i < n; ++i) {
                Object entry = Array.get(entries2, i);
                Object bundlefile = ReflectionUtils.getFieldVal(entry, "bundlefile", false);
                EquinoxClassLoaderHandler.addBundleFile(bundlefile, new HashSet<Object>(), classLoader2, classpathOrderOut, scanSpec, log);
            }
        }
    }

    public static void findClasspathOrder(ClassLoader classLoader2, ClasspathOrder classpathOrder, ScanSpec scanSpec, LogNode log) {
        Object manager = ReflectionUtils.getFieldVal(classLoader2, "manager", false);
        EquinoxClassLoaderHandler.addClasspathEntries(manager, classLoader2, classpathOrder, scanSpec, log);
        Object fragments2 = ReflectionUtils.getFieldVal(manager, "fragments", false);
        if (fragments2 != null) {
            int fragLength = Array.getLength(fragments2);
            for (int f = 0; f < fragLength; ++f) {
                Object fragment = Array.get(fragments2, f);
                EquinoxClassLoaderHandler.addClasspathEntries(fragment, classLoader2, classpathOrder, scanSpec, log);
            }
        }
        if (!alreadyReadSystemBundles) {
            Object delegate = ReflectionUtils.getFieldVal(classLoader2, "delegate", false);
            Object container = ReflectionUtils.getFieldVal(delegate, "container", false);
            Object storage2 = ReflectionUtils.getFieldVal(container, "storage", false);
            Object moduleContainer = ReflectionUtils.getFieldVal(storage2, "moduleContainer", false);
            Object moduleDatabase = ReflectionUtils.getFieldVal(moduleContainer, "moduleDatabase", false);
            Object modulesById = ReflectionUtils.getFieldVal(moduleDatabase, "modulesById", false);
            Object module0 = ReflectionUtils.invokeMethod(modulesById, "get", Object.class, 0L, false);
            Object bundle = ReflectionUtils.invokeMethod(module0, "getBundle", false);
            Object bundleContext = ReflectionUtils.invokeMethod(bundle, "getBundleContext", false);
            Object bundles = ReflectionUtils.invokeMethod(bundleContext, "getBundles", false);
            if (bundles != null) {
                int n = Array.getLength(bundles);
                for (int i = 0; i < n; ++i) {
                    int fileIdx;
                    Object equinoxBundle = Array.get(bundles, i);
                    Object module = ReflectionUtils.getFieldVal(equinoxBundle, "module", false);
                    String location = (String)ReflectionUtils.getFieldVal(module, "location", false);
                    if (location == null || (fileIdx = location.indexOf("file:")) < 0) continue;
                    location = location.substring(fileIdx);
                    classpathOrder.addClasspathEntry((Object)location, classLoader2, scanSpec, log);
                }
            }
            alreadyReadSystemBundles = true;
        }
    }

    static {
        FIELD_NAMES = new String[]{"cp", "nestedDirName"};
    }
}

