/*
 * Decompiled with CFR 0.152.
 */
package nonapi.io.github.classgraph.classloaderhandler;

import java.nio.file.Path;
import java.util.Collection;
import nonapi.io.github.classgraph.classloaderhandler.ClassLoaderHandler;
import nonapi.io.github.classgraph.classpath.ClassLoaderOrder;
import nonapi.io.github.classgraph.classpath.ClasspathOrder;
import nonapi.io.github.classgraph.scanspec.ScanSpec;
import nonapi.io.github.classgraph.utils.LogNode;
import nonapi.io.github.classgraph.utils.ReflectionUtils;

class QuarkusClassLoaderHandler
implements ClassLoaderHandler {
    private static final String RUNTIME_CLASSLOADER = "io.quarkus.runner.RuntimeClassLoader";
    private static final String QUARKUS_CLASSLOADER = "io.quarkus.bootstrap.classloading.QuarkusClassLoader";

    private QuarkusClassLoaderHandler() {
    }

    public static boolean canHandle(Class<?> classLoaderClass, LogNode log) {
        return RUNTIME_CLASSLOADER.equals(classLoaderClass.getName()) || QUARKUS_CLASSLOADER.equals(classLoaderClass.getName());
    }

    public static void findClassLoaderOrder(ClassLoader classLoader2, ClassLoaderOrder classLoaderOrder, LogNode log) {
        classLoaderOrder.delegateTo(classLoader2.getParent(), true, log);
        classLoaderOrder.add(classLoader2, log);
    }

    public static void findClasspathOrder(ClassLoader classLoader2, ClasspathOrder classpathOrder, ScanSpec scanSpec, LogNode log) {
        String classLoaderName = classLoader2.getClass().getName();
        if (RUNTIME_CLASSLOADER.equals(classLoaderName)) {
            QuarkusClassLoaderHandler.findClasspathOrderForRuntimeClassloader(classLoader2, classpathOrder, scanSpec, log);
        } else if (QUARKUS_CLASSLOADER.equals(classLoaderName)) {
            QuarkusClassLoaderHandler.findClasspathOrderForQuarkusClassloader(classLoader2, classpathOrder, scanSpec, log);
        }
    }

    private static void findClasspathOrderForQuarkusClassloader(ClassLoader classLoader2, ClasspathOrder classpathOrder, ScanSpec scanSpec, LogNode log) {
        for (Object element : (Collection)ReflectionUtils.getFieldVal(classLoader2, "elements", false)) {
            String elementClassName = element.getClass().getName();
            if ("io.quarkus.bootstrap.classloading.JarClassPathElement".equals(elementClassName)) {
                classpathOrder.addClasspathEntry(ReflectionUtils.getFieldVal(element, "file", false), classLoader2, scanSpec, log);
                continue;
            }
            if (!"io.quarkus.bootstrap.classloading.DirectoryClassPathElement".equals(elementClassName)) continue;
            classpathOrder.addClasspathEntry(ReflectionUtils.getFieldVal(element, "root", false), classLoader2, scanSpec, log);
        }
    }

    private static void findClasspathOrderForRuntimeClassloader(ClassLoader classLoader2, ClasspathOrder classpathOrder, ScanSpec scanSpec, LogNode log) {
        Collection applicationClassDirectories = (Collection)ReflectionUtils.getFieldVal(classLoader2, "applicationClassDirectories", false);
        if (applicationClassDirectories != null) {
            for (Path path : applicationClassDirectories) {
                classpathOrder.addClasspathEntryObject(path.toUri(), classLoader2, scanSpec, log);
            }
        }
    }
}

