/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input.buffer;

import java.util.Objects;

public class CircularByteBuffer {
    private final byte[] buffer;
    private int startOffset;
    private int endOffset;
    private int currentNumberOfBytes;

    public CircularByteBuffer(int pSize) {
        this.buffer = new byte[pSize];
        this.startOffset = 0;
        this.endOffset = 0;
        this.currentNumberOfBytes = 0;
    }

    public CircularByteBuffer() {
        this(8192);
    }

    public byte read() {
        if (this.currentNumberOfBytes <= 0) {
            throw new IllegalStateException("No bytes available.");
        }
        byte b = this.buffer[this.startOffset];
        --this.currentNumberOfBytes;
        if (++this.startOffset == this.buffer.length) {
            this.startOffset = 0;
        }
        return b;
    }

    public void read(byte[] targetBuffer, int targetOffset, int length2) {
        Objects.requireNonNull(targetBuffer);
        if (targetOffset < 0 || targetOffset >= targetBuffer.length) {
            throw new IllegalArgumentException("Invalid offset: " + targetOffset);
        }
        if (length2 < 0 || length2 > this.buffer.length) {
            throw new IllegalArgumentException("Invalid length: " + length2);
        }
        if (targetOffset + length2 > targetBuffer.length) {
            throw new IllegalArgumentException("The supplied byte array contains only " + targetBuffer.length + " bytes, but offset, and length would require " + (targetOffset + length2 - 1));
        }
        if (this.currentNumberOfBytes < length2) {
            throw new IllegalStateException("Currently, there are only " + this.currentNumberOfBytes + "in the buffer, not " + length2);
        }
        int offset = targetOffset;
        for (int i = 0; i < length2; ++i) {
            targetBuffer[offset++] = this.buffer[this.startOffset];
            --this.currentNumberOfBytes;
            if (++this.startOffset != this.buffer.length) continue;
            this.startOffset = 0;
        }
    }

    public void add(byte value2) {
        if (this.currentNumberOfBytes >= this.buffer.length) {
            throw new IllegalStateException("No space available");
        }
        this.buffer[this.endOffset] = value2;
        ++this.currentNumberOfBytes;
        if (++this.endOffset == this.buffer.length) {
            this.endOffset = 0;
        }
    }

    public boolean peek(byte[] sourceBuffer, int offset, int length2) {
        Objects.requireNonNull(sourceBuffer, "Buffer");
        if (offset < 0 || offset >= sourceBuffer.length) {
            throw new IllegalArgumentException("Invalid offset: " + offset);
        }
        if (length2 < 0 || length2 > this.buffer.length) {
            throw new IllegalArgumentException("Invalid length: " + length2);
        }
        if (length2 < this.currentNumberOfBytes) {
            return false;
        }
        int localOffset = this.startOffset;
        for (int i = 0; i < length2; ++i) {
            if (this.buffer[localOffset] != sourceBuffer[i + offset]) {
                return false;
            }
            if (++localOffset != this.buffer.length) continue;
            localOffset = 0;
        }
        return true;
    }

    public void add(byte[] targetBuffer, int offset, int length2) {
        Objects.requireNonNull(targetBuffer, "Buffer");
        if (offset < 0 || offset >= targetBuffer.length) {
            throw new IllegalArgumentException("Invalid offset: " + offset);
        }
        if (length2 < 0) {
            throw new IllegalArgumentException("Invalid length: " + length2);
        }
        if (this.currentNumberOfBytes + length2 > this.buffer.length) {
            throw new IllegalStateException("No space available");
        }
        for (int i = 0; i < length2; ++i) {
            this.buffer[this.endOffset] = targetBuffer[offset + i];
            if (++this.endOffset != this.buffer.length) continue;
            this.endOffset = 0;
        }
        this.currentNumberOfBytes += length2;
    }

    public boolean hasSpace() {
        return this.currentNumberOfBytes < this.buffer.length;
    }

    public boolean hasSpace(int count2) {
        return this.currentNumberOfBytes + count2 <= this.buffer.length;
    }

    public boolean hasBytes() {
        return this.currentNumberOfBytes > 0;
    }

    public int getSpace() {
        return this.buffer.length - this.currentNumberOfBytes;
    }

    public int getCurrentNumberOfBytes() {
        return this.currentNumberOfBytes;
    }

    public void clear() {
        this.startOffset = 0;
        this.endOffset = 0;
        this.currentNumberOfBytes = 0;
    }
}

