/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.tree;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.dom4j.DocumentFactory;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class NamespaceStack {
    private DocumentFactory documentFactory;
    private ArrayList<Namespace> namespaceStack = new ArrayList();
    private ArrayList<Map<String, QName>> namespaceCacheList = new ArrayList();
    private Map<String, QName> currentNamespaceCache;
    private Map<String, QName> rootNamespaceCache = new HashMap<String, QName>();
    private Namespace defaultNamespace;

    public NamespaceStack() {
        this.documentFactory = DocumentFactory.getInstance();
    }

    public NamespaceStack(DocumentFactory documentFactory) {
        this.documentFactory = documentFactory;
    }

    public void push(Namespace namespace) {
        this.namespaceStack.add(namespace);
        this.namespaceCacheList.add(null);
        this.currentNamespaceCache = null;
        String prefix2 = namespace.getPrefix();
        if (prefix2 == null || prefix2.length() == 0) {
            this.defaultNamespace = namespace;
        }
    }

    public Namespace pop() {
        return this.remove(this.namespaceStack.size() - 1);
    }

    public int size() {
        return this.namespaceStack.size();
    }

    public void clear() {
        this.namespaceStack.clear();
        this.namespaceCacheList.clear();
        this.rootNamespaceCache.clear();
        this.currentNamespaceCache = null;
    }

    public Namespace getNamespace(int index) {
        return this.namespaceStack.get(index);
    }

    public Namespace getNamespaceForPrefix(String prefix2) {
        if (prefix2 == null) {
            prefix2 = "";
        }
        for (int i = this.namespaceStack.size() - 1; i >= 0; --i) {
            Namespace namespace = this.namespaceStack.get(i);
            if (!prefix2.equals(namespace.getPrefix())) continue;
            return namespace;
        }
        return null;
    }

    public String getURI(String prefix2) {
        Namespace namespace = this.getNamespaceForPrefix(prefix2);
        return namespace != null ? namespace.getURI() : null;
    }

    public boolean contains(Namespace namespace) {
        String prefix2 = namespace.getPrefix();
        Namespace current = prefix2 == null || prefix2.length() == 0 ? this.getDefaultNamespace() : this.getNamespaceForPrefix(prefix2);
        if (current == null) {
            return false;
        }
        if (current == namespace) {
            return true;
        }
        return namespace.getURI().equals(current.getURI());
    }

    public QName getQName(String namespaceURI, String localName, String qualifiedName2) {
        if (localName == null) {
            localName = qualifiedName2;
        } else if (qualifiedName2 == null) {
            qualifiedName2 = localName;
        }
        if (namespaceURI == null) {
            namespaceURI = "";
        }
        String prefix2 = "";
        int index = qualifiedName2.indexOf(":");
        if (index > 0) {
            prefix2 = qualifiedName2.substring(0, index);
            if (localName.trim().length() == 0) {
                localName = qualifiedName2.substring(index + 1);
            }
        } else if (localName.trim().length() == 0) {
            localName = qualifiedName2;
        }
        Namespace namespace = this.createNamespace(prefix2, namespaceURI);
        return this.pushQName(localName, qualifiedName2, namespace, prefix2);
    }

    public QName getAttributeQName(String namespaceURI, String localName, String qualifiedName2) {
        Namespace namespace;
        Map<String, QName> map3;
        QName answer;
        if (qualifiedName2 == null) {
            qualifiedName2 = localName;
        }
        if ((answer = (map3 = this.getNamespaceCache()).get(qualifiedName2)) != null) {
            return answer;
        }
        if (localName == null) {
            localName = qualifiedName2;
        }
        if (namespaceURI == null) {
            namespaceURI = "";
        }
        String prefix2 = "";
        int index = qualifiedName2.indexOf(":");
        if (index > 0) {
            prefix2 = qualifiedName2.substring(0, index);
            namespace = this.createNamespace(prefix2, namespaceURI);
            if (localName.trim().length() == 0) {
                localName = qualifiedName2.substring(index + 1);
            }
        } else {
            namespace = Namespace.NO_NAMESPACE;
            if (localName.trim().length() == 0) {
                localName = qualifiedName2;
            }
        }
        answer = this.pushQName(localName, qualifiedName2, namespace, prefix2);
        map3.put(qualifiedName2, answer);
        return answer;
    }

    public void push(String prefix2, String uri) {
        if (uri == null) {
            uri = "";
        }
        Namespace namespace = this.createNamespace(prefix2, uri);
        this.push(namespace);
    }

    public Namespace addNamespace(String prefix2, String uri) {
        Namespace namespace = this.createNamespace(prefix2, uri);
        this.push(namespace);
        return namespace;
    }

    public Namespace pop(String prefix2) {
        if (prefix2 == null) {
            prefix2 = "";
        }
        Namespace namespace = null;
        for (int i = this.namespaceStack.size() - 1; i >= 0; --i) {
            Namespace ns = this.namespaceStack.get(i);
            if (!prefix2.equals(ns.getPrefix())) continue;
            this.remove(i);
            namespace = ns;
            break;
        }
        if (namespace == null) {
            System.out.println("Warning: missing namespace prefix ignored: " + prefix2);
        }
        return namespace;
    }

    public String toString() {
        return super.toString() + " Stack: " + this.namespaceStack.toString();
    }

    public DocumentFactory getDocumentFactory() {
        return this.documentFactory;
    }

    public void setDocumentFactory(DocumentFactory documentFactory) {
        this.documentFactory = documentFactory;
    }

    public Namespace getDefaultNamespace() {
        if (this.defaultNamespace == null) {
            this.defaultNamespace = this.findDefaultNamespace();
        }
        return this.defaultNamespace;
    }

    protected QName pushQName(String localName, String qualifiedName2, Namespace namespace, String prefix2) {
        if (prefix2 == null || prefix2.length() == 0) {
            this.defaultNamespace = null;
        }
        return this.createQName(localName, qualifiedName2, namespace);
    }

    protected QName createQName(String localName, String qualifiedName2, Namespace namespace) {
        return this.documentFactory.createQName(localName, namespace);
    }

    protected Namespace createNamespace(String prefix2, String namespaceURI) {
        return this.documentFactory.createNamespace(prefix2, namespaceURI);
    }

    protected Namespace findDefaultNamespace() {
        for (int i = this.namespaceStack.size() - 1; i >= 0; --i) {
            String prefix2;
            Namespace namespace = this.namespaceStack.get(i);
            if (namespace == null || (prefix2 = namespace.getPrefix()) != null && namespace.getPrefix().length() != 0) continue;
            return namespace;
        }
        return null;
    }

    protected Namespace remove(int index) {
        Namespace namespace = this.namespaceStack.remove(index);
        this.namespaceCacheList.remove(index);
        this.defaultNamespace = null;
        this.currentNamespaceCache = null;
        return namespace;
    }

    protected Map<String, QName> getNamespaceCache() {
        if (this.currentNamespaceCache == null) {
            int index = this.namespaceStack.size() - 1;
            if (index < 0) {
                this.currentNamespaceCache = this.rootNamespaceCache;
            } else {
                this.currentNamespaceCache = this.namespaceCacheList.get(index);
                if (this.currentNamespaceCache == null) {
                    this.currentNamespaceCache = new HashMap<String, QName>();
                    this.namespaceCacheList.set(index, this.currentNamespaceCache);
                }
            }
        }
        return this.currentNamespaceCache;
    }
}

