/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.github.core;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.egit.github.core.IRepositoryIdProvider;

public class RepositoryId
implements IRepositoryIdProvider,
Serializable {
    private static final long serialVersionUID = -57313931704393200L;
    private final String owner;
    private final String name;

    public static RepositoryId createFromUrl(URL url2) {
        return url2 != null ? RepositoryId.createFromId(url2.getPath()) : null;
    }

    public static RepositoryId createFromId(String id2) {
        if (id2 == null || id2.length() == 0) {
            return null;
        }
        String owner = null;
        String name = null;
        String[] stringArray = id2.split("/");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            if (segment.length() > 0) {
                if (owner == null) {
                    owner = segment;
                } else {
                    if (name != null) break;
                    name = segment;
                }
            }
            ++n2;
        }
        return owner != null && owner.length() > 0 && name != null && name.length() > 0 ? new RepositoryId(owner, name) : null;
    }

    public static RepositoryId createFromUrl(String url2) {
        if (url2 == null || url2.length() == 0) {
            return null;
        }
        try {
            return RepositoryId.createFromUrl(new URL(url2));
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public static RepositoryId create(String owner, String name) {
        return new RepositoryId(owner, name);
    }

    public RepositoryId(String owner, String name) {
        if (owner == null) {
            throw new IllegalArgumentException("Owner cannot be null");
        }
        if (owner.length() == 0) {
            throw new IllegalArgumentException("Owner cannot be empty");
        }
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException("Name cannot be empty");
        }
        this.owner = owner;
        this.name = name;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String generateId() {
        return String.valueOf(this.owner) + "/" + this.name;
    }

    public int hashCode() {
        return this.generateId().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RepositoryId)) {
            return false;
        }
        RepositoryId other = (RepositoryId)obj;
        return this.name.equals(other.name) && this.owner.equals(other.owner);
    }

    public String toString() {
        return this.generateId();
    }
}

