/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.github.core.service;

import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.util.List;
import org.eclipse.egit.github.core.IRepositoryIdProvider;
import org.eclipse.egit.github.core.User;
import org.eclipse.egit.github.core.client.GitHubClient;
import org.eclipse.egit.github.core.client.PagedRequest;
import org.eclipse.egit.github.core.service.GitHubService;

public class CollaboratorService
extends GitHubService {
    public CollaboratorService() {
    }

    public CollaboratorService(GitHubClient client2) {
        super(client2);
    }

    public List<User> getCollaborators(IRepositoryIdProvider repository) throws IOException {
        String id2 = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id2);
        uri.append("/collaborators");
        PagedRequest request2 = this.createPagedRequest();
        request2.setUri(uri);
        request2.setType(new TypeToken<List<User>>(){}.getType());
        return this.getAll(request2);
    }

    protected String createUpdateUri(IRepositoryIdProvider repository, String user2) {
        String id2 = this.getId(repository);
        if (user2 == null) {
            throw new IllegalArgumentException("User cannot be null");
        }
        if (user2.length() == 0) {
            throw new IllegalArgumentException("User cannot be empty");
        }
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id2);
        uri.append("/collaborators");
        uri.append('/').append(user2);
        return uri.toString();
    }

    public boolean isCollaborator(IRepositoryIdProvider repository, String user2) throws IOException {
        return this.check(this.createUpdateUri(repository, user2));
    }

    public void addCollaborator(IRepositoryIdProvider repository, String user2) throws IOException {
        this.client.put(this.createUpdateUri(repository, user2));
    }

    public void removeCollaborator(IRepositoryIdProvider repository, String user2) throws IOException {
        this.client.delete(this.createUpdateUri(repository, user2));
    }
}

