/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.github.core.service;

import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.egit.github.core.Blob;
import org.eclipse.egit.github.core.Commit;
import org.eclipse.egit.github.core.IRepositoryIdProvider;
import org.eclipse.egit.github.core.Reference;
import org.eclipse.egit.github.core.ShaResource;
import org.eclipse.egit.github.core.Tag;
import org.eclipse.egit.github.core.Tree;
import org.eclipse.egit.github.core.TreeEntry;
import org.eclipse.egit.github.core.TypedResource;
import org.eclipse.egit.github.core.client.GitHubClient;
import org.eclipse.egit.github.core.client.GitHubRequest;
import org.eclipse.egit.github.core.client.PagedRequest;
import org.eclipse.egit.github.core.service.GitHubService;

public class DataService
extends GitHubService {
    public DataService() {
    }

    public DataService(GitHubClient client2) {
        super(client2);
    }

    public Blob getBlob(IRepositoryIdProvider repository, String sha) throws IOException {
        String id2 = this.getId(repository);
        if (sha == null) {
            throw new IllegalArgumentException("SHA-1 cannot be null");
        }
        if (sha.length() == 0) {
            throw new IllegalArgumentException("SHA-1 cannot be empty");
        }
        StringBuilder uri = new StringBuilder();
        uri.append("/repos");
        uri.append('/').append(id2);
        uri.append("/git");
        uri.append("/blobs");
        uri.append('/').append(sha);
        GitHubRequest request2 = this.createRequest();
        request2.setType((Type)((Object)Blob.class));
        request2.setUri(uri);
        return (Blob)this.client.get(request2).getBody();
    }

    public String createBlob(IRepositoryIdProvider repository, Blob blob) throws IOException {
        String id2 = this.getId(repository);
        if (blob == null) {
            throw new IllegalArgumentException("Blob cannot be null");
        }
        StringBuilder uri = new StringBuilder();
        uri.append("/repos");
        uri.append('/').append(id2);
        uri.append("/git");
        uri.append("/blobs");
        ShaResource created = (ShaResource)this.client.post(uri.toString(), blob, (Type)((Object)ShaResource.class));
        return created != null ? created.getSha() : null;
    }

    public Tree getTree(IRepositoryIdProvider repository, String sha) throws IOException {
        return this.getTree(repository, sha, false);
    }

    public Tree getTree(IRepositoryIdProvider repository, String sha, boolean recursive) throws IOException {
        String id2 = this.getId(repository);
        if (sha == null) {
            throw new IllegalArgumentException("SHA-1 cannot be null");
        }
        if (sha.length() == 0) {
            throw new IllegalArgumentException("SHA-1 cannot be empty");
        }
        StringBuilder uri = new StringBuilder();
        uri.append("/repos");
        uri.append('/').append(id2);
        uri.append("/git");
        uri.append("/trees");
        uri.append('/').append(sha);
        GitHubRequest request2 = this.createRequest();
        request2.setType((Type)((Object)Tree.class));
        request2.setUri(uri);
        if (recursive) {
            request2.setParams(Collections.singletonMap("recursive", "1"));
        }
        return (Tree)this.client.get(request2).getBody();
    }

    public Tree createTree(IRepositoryIdProvider repository, Collection<TreeEntry> entries2) throws IOException {
        return this.createTree(repository, entries2, null);
    }

    public Tree createTree(IRepositoryIdProvider repository, Collection<TreeEntry> entries2, String baseTree) throws IOException {
        String id2 = this.getId(repository);
        StringBuilder uri = new StringBuilder();
        uri.append("/repos");
        uri.append('/').append(id2);
        uri.append("/git");
        uri.append("/trees");
        GitHubRequest request2 = this.createRequest();
        request2.setType((Type)((Object)Tree.class));
        request2.setUri(uri);
        HashMap<String, Object> params2 = new HashMap<String, Object>();
        if (entries2 != null) {
            params2.put("tree", entries2.toArray());
        }
        if (baseTree != null) {
            params2.put("base_tree", baseTree);
        }
        return (Tree)this.client.post(uri.toString(), params2, (Type)((Object)Tree.class));
    }

    public Reference getReference(IRepositoryIdProvider repository, String name) throws IOException {
        String id2 = this.getId(repository);
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException("Name cannot be empty");
        }
        StringBuilder uri = new StringBuilder();
        uri.append("/repos");
        uri.append('/').append(id2);
        uri.append("/git");
        if (!name.startsWith("refs/")) {
            uri.append("/refs");
        }
        uri.append('/').append(name);
        GitHubRequest request2 = this.createRequest();
        request2.setType((Type)((Object)Reference.class));
        request2.setUri(uri);
        return (Reference)this.client.get(request2).getBody();
    }

    public List<Reference> getReferences(IRepositoryIdProvider repository) throws IOException {
        String id2 = this.getId(repository);
        StringBuilder uri = new StringBuilder();
        uri.append("/repos");
        uri.append('/').append(id2);
        uri.append("/git");
        uri.append("/refs");
        PagedRequest request2 = this.createPagedRequest();
        request2.setType(new TypeToken<List<Reference>>(){}.getType());
        request2.setUri(uri);
        return this.getAll(request2);
    }

    public Reference createReference(IRepositoryIdProvider repository, Reference reference) throws IOException {
        String id2 = this.getId(repository);
        if (reference == null) {
            throw new IllegalArgumentException("Reference cannot be null");
        }
        TypedResource object = reference.getObject();
        if (object == null) {
            throw new IllegalArgumentException("Reference object cannot be null");
        }
        StringBuilder uri = new StringBuilder();
        uri.append("/repos");
        uri.append('/').append(id2);
        uri.append("/git");
        uri.append("/refs");
        HashMap<String, String> params2 = new HashMap<String, String>();
        params2.put("sha", object.getSha());
        params2.put("ref", reference.getRef());
        return (Reference)this.client.post(uri.toString(), params2, (Type)((Object)Reference.class));
    }

    public Reference editReference(IRepositoryIdProvider repository, Reference reference) throws IOException {
        return this.editReference(repository, reference, false);
    }

    public Reference editReference(IRepositoryIdProvider repository, Reference reference, boolean force) throws IOException {
        String id2 = this.getId(repository);
        if (reference == null) {
            throw new IllegalArgumentException("Reference cannot be null");
        }
        TypedResource object = reference.getObject();
        if (object == null) {
            throw new IllegalArgumentException("Object cannot be null");
        }
        String ref = reference.getRef();
        if (ref == null) {
            throw new IllegalArgumentException("Ref cannot be null");
        }
        if (ref.length() == 0) {
            throw new IllegalArgumentException("Ref cannot be empty");
        }
        StringBuilder uri = new StringBuilder();
        uri.append("/repos");
        uri.append('/').append(id2);
        uri.append("/git");
        if (!ref.startsWith("refs/")) {
            uri.append("/refs");
        }
        uri.append('/').append(ref);
        HashMap<String, Object> params2 = new HashMap<String, Object>();
        params2.put("sha", object.getSha());
        if (force) {
            params2.put("force", Boolean.TRUE);
        }
        return (Reference)this.client.post(uri.toString(), params2, (Type)((Object)Reference.class));
    }

    public Commit getCommit(IRepositoryIdProvider repository, String sha) throws IOException {
        String id2 = this.getId(repository);
        if (sha == null) {
            throw new IllegalArgumentException("SHA-1 cannot be null");
        }
        if (sha.length() == 0) {
            throw new IllegalArgumentException("SHA-1 cannot be empty");
        }
        StringBuilder uri = new StringBuilder();
        uri.append("/repos");
        uri.append('/').append(id2);
        uri.append("/git");
        uri.append("/commits");
        uri.append('/').append(sha);
        GitHubRequest request2 = this.createRequest();
        request2.setType((Type)((Object)Commit.class));
        request2.setUri(uri);
        return (Commit)this.client.get(request2).getBody();
    }

    public Commit createCommit(IRepositoryIdProvider repository, Commit commit) throws IOException {
        Tree tree2;
        String id2 = this.getId(repository);
        if (commit == null) {
            throw new IllegalArgumentException("Commit cannot be null");
        }
        StringBuilder uri = new StringBuilder();
        uri.append("/repos");
        uri.append('/').append(id2);
        uri.append("/git");
        uri.append("/commits");
        HashMap<String, Object> params2 = new HashMap<String, Object>();
        params2.put("author", commit.getAuthor());
        params2.put("committer", commit.getCommitter());
        params2.put("message", commit.getMessage());
        List<Commit> parents = commit.getParents();
        if (parents != null && parents.size() > 0) {
            ArrayList<String> parentIds = new ArrayList<String>();
            for (Commit parent : parents) {
                parentIds.add(parent.getSha());
            }
            params2.put("parents", parentIds);
        }
        if ((tree2 = commit.getTree()) != null) {
            params2.put("tree", tree2.getSha());
        }
        return (Commit)this.client.post(uri.toString(), params2, (Type)((Object)Commit.class));
    }

    public Tag getTag(IRepositoryIdProvider repository, String sha) throws IOException {
        String id2 = this.getId(repository);
        if (sha == null) {
            throw new IllegalArgumentException("SHA-1 cannot be null");
        }
        if (sha.length() == 0) {
            throw new IllegalArgumentException("SHA-1 cannot be empty");
        }
        StringBuilder uri = new StringBuilder();
        uri.append("/repos");
        uri.append('/').append(id2);
        uri.append("/git");
        uri.append("/tags");
        uri.append('/').append(sha);
        GitHubRequest request2 = this.createRequest();
        request2.setType((Type)((Object)Tag.class));
        request2.setUri(uri);
        return (Tag)this.client.get(request2).getBody();
    }

    public List<Reference> listTags(IRepositoryIdProvider repository) throws IOException {
        String id2 = this.getId(repository);
        StringBuilder uri = new StringBuilder();
        uri.append("/repos");
        uri.append('/').append(id2);
        uri.append("/git");
        uri.append("/refs");
        uri.append("/tags");
        PagedRequest request2 = this.createPagedRequest();
        request2.setType(new TypeToken<List<Reference>>(){}.getType());
        request2.setUri(uri);
        return this.getAll(request2);
    }

    public Tag createTag(IRepositoryIdProvider repository, Tag tag) throws IOException {
        String id2 = this.getId(repository);
        if (tag == null) {
            throw new IllegalArgumentException("Tag cannot be null");
        }
        StringBuilder uri = new StringBuilder();
        uri.append("/repos");
        uri.append('/').append(id2);
        uri.append("/git");
        uri.append("/tags");
        HashMap<String, Object> params2 = new HashMap<String, Object>();
        params2.put("tag", tag.getTag());
        params2.put("message", tag.getMessage());
        TypedResource object = tag.getObject();
        if (object != null) {
            params2.put("object", object.getSha());
            params2.put("type", object.getType());
        }
        params2.put("tagger", tag.getTagger());
        return (Tag)this.client.post(uri.toString(), params2, (Type)((Object)Tag.class));
    }

    public void deleteReference(IRepositoryIdProvider repository, Reference reference) throws IOException {
        String id2 = this.getId(repository);
        if (reference == null) {
            throw new IllegalArgumentException("Reference cannot be null");
        }
        String ref = reference.getRef();
        if (ref == null) {
            throw new IllegalArgumentException("Ref cannot be null");
        }
        if (ref.length() == 0) {
            throw new IllegalArgumentException("Ref cannot be empty");
        }
        StringBuilder uri = new StringBuilder();
        uri.append("/repos");
        uri.append('/').append(id2);
        uri.append("/git");
        if (!ref.startsWith("refs/")) {
            uri.append("/refs");
        }
        uri.append('/').append(ref);
        this.client.delete(uri.toString());
    }

    public void deleteBranch(IRepositoryIdProvider repository, String branchName) throws IOException {
        String id2 = this.getId(repository);
        if (branchName == null || branchName.isEmpty()) {
            throw new IllegalArgumentException("BranchName cannot be null");
        }
        StringBuilder uri = new StringBuilder();
        uri.append("/repos");
        uri.append('/').append(id2);
        uri.append("/git");
        uri.append("/refs");
        uri.append("/heads").append('/').append(branchName);
        this.client.delete(uri.toString());
    }

    public void deleteTag(IRepositoryIdProvider repository, Tag tag) throws IOException {
        String id2 = this.getId(repository);
        if (tag == null) {
            throw new IllegalArgumentException("Tag cannot be null");
        }
        if (tag.getTag() == null || tag.getTag().isEmpty()) {
            throw new IllegalArgumentException("Tag Name cannot be empty");
        }
        StringBuilder uri = new StringBuilder();
        uri.append("/repos");
        uri.append('/').append(id2);
        uri.append("/git");
        uri.append("/refs");
        uri.append("/tags").append('/').append(tag.getTag());
        this.client.delete(uri.toString());
    }
}

