/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.github.core.service;

import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.List;
import org.eclipse.egit.github.core.IRepositoryIdProvider;
import org.eclipse.egit.github.core.Key;
import org.eclipse.egit.github.core.client.GitHubClient;
import org.eclipse.egit.github.core.client.GitHubRequest;
import org.eclipse.egit.github.core.client.PagedRequest;
import org.eclipse.egit.github.core.service.GitHubService;

public class DeployKeyService
extends GitHubService {
    public DeployKeyService() {
    }

    public DeployKeyService(GitHubClient client2) {
        super(client2);
    }

    public List<Key> getKeys(IRepositoryIdProvider repository) throws IOException {
        String id2 = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id2);
        uri.append("/keys");
        PagedRequest request2 = this.createPagedRequest();
        request2.setUri(uri);
        request2.setType(new TypeToken<List<Key>>(){}.getType());
        return this.getAll(request2);
    }

    public Key getKey(IRepositoryIdProvider repository, int id2) throws IOException {
        String repoId = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(repoId);
        uri.append("/keys");
        uri.append('/').append(id2);
        GitHubRequest request2 = this.createRequest();
        request2.setUri(uri);
        request2.setType((Type)((Object)Key.class));
        return (Key)this.client.get(request2).getBody();
    }

    public Key createKey(IRepositoryIdProvider repository, Key key) throws IOException {
        String id2 = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id2);
        uri.append("/keys");
        return (Key)this.client.post(uri.toString(), key, (Type)((Object)Key.class));
    }

    public Key editKey(IRepositoryIdProvider repository, Key key) throws IOException {
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null");
        }
        String repoId = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(repoId);
        uri.append("/keys");
        uri.append('/').append(key.getId());
        return (Key)this.client.post(uri.toString(), key, (Type)((Object)Key.class));
    }

    public void deleteKey(IRepositoryIdProvider repository, int id2) throws IOException {
        String repoId = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(repoId);
        uri.append("/keys");
        uri.append('/').append(id2);
        this.client.delete(uri.toString());
    }
}

