/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.github.core.service;

import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.egit.github.core.Download;
import org.eclipse.egit.github.core.DownloadResource;
import org.eclipse.egit.github.core.IRepositoryIdProvider;
import org.eclipse.egit.github.core.client.GitHubClient;
import org.eclipse.egit.github.core.client.GitHubRequest;
import org.eclipse.egit.github.core.client.PageIterator;
import org.eclipse.egit.github.core.client.PagedRequest;
import org.eclipse.egit.github.core.service.GitHubService;
import org.eclipse.egit.github.core.util.MultiPartUtils;

public class DownloadService
extends GitHubService {
    public static final String UPLOAD_KEY = "key";
    public static final String UPLOAD_ACL = "acl";
    public static final String UPLOAD_SUCCESS_ACTION_STATUS = "success_action_status";
    public static final String UPLOAD_FILENAME = "Filename";
    public static final String UPLOAD_AWS_ACCESS_KEY_ID = "AWSAccessKeyId";
    public static final String UPLOAD_POLICY = "Policy";
    public static final String UPLOAD_SIGNATURE = "Signature";
    public static final String UPLOAD_FILE = "file";
    public static final String UPLOAD_CONTENT_TYPE = "Content-Type";

    public DownloadService() {
    }

    public DownloadService(GitHubClient client2) {
        super(client2);
    }

    public Download getDownload(IRepositoryIdProvider repository, int id2) throws IOException {
        String repoId = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(repoId);
        uri.append("/downloads");
        uri.append('/').append(id2);
        GitHubRequest request2 = this.createRequest();
        request2.setUri(uri);
        request2.setType((Type)((Object)Download.class));
        return (Download)this.client.get(request2).getBody();
    }

    protected PagedRequest<Download> createDownloadsRequest(IRepositoryIdProvider repository, int start, int size2) {
        String repoId = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(repoId);
        uri.append("/downloads");
        PagedRequest<Download> request2 = this.createPagedRequest(start, size2);
        request2.setType(new TypeToken<List<Download>>(){}.getType());
        request2.setUri(uri);
        return request2;
    }

    public List<Download> getDownloads(IRepositoryIdProvider repository) throws IOException {
        return this.getAll(this.pageDownloads(repository));
    }

    public PageIterator<Download> pageDownloads(IRepositoryIdProvider repository) {
        return this.pageDownloads(repository, 100);
    }

    public PageIterator<Download> pageDownloads(IRepositoryIdProvider repository, int size2) {
        return this.pageDownloads(repository, 1, size2);
    }

    public PageIterator<Download> pageDownloads(IRepositoryIdProvider repository, int start, int size2) {
        PagedRequest<Download> request2 = this.createDownloadsRequest(repository, start, size2);
        return this.createPageIterator(request2);
    }

    public void deleteDownload(IRepositoryIdProvider repository, int id2) throws IOException {
        String repoId = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(repoId);
        uri.append("/downloads");
        uri.append('/').append(id2);
        this.client.delete(uri.toString());
    }

    public DownloadResource createResource(IRepositoryIdProvider repository, Download download) throws IOException {
        String repoId = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(repoId);
        uri.append("/downloads");
        return (DownloadResource)this.client.post(uri.toString(), download, (Type)((Object)DownloadResource.class));
    }

    public void uploadResource(DownloadResource resource2, InputStream content, long size2) throws IOException {
        if (resource2 == null) {
            throw new IllegalArgumentException("Download resource cannot be null");
        }
        if (content == null) {
            throw new IllegalArgumentException("Content input stream cannot be null");
        }
        LinkedHashMap<String, Object> parts = new LinkedHashMap<String, Object>();
        parts.put(UPLOAD_KEY, resource2.getPath());
        parts.put(UPLOAD_ACL, resource2.getAcl());
        parts.put(UPLOAD_SUCCESS_ACTION_STATUS, Integer.toString(201));
        parts.put(UPLOAD_FILENAME, resource2.getName());
        parts.put(UPLOAD_AWS_ACCESS_KEY_ID, resource2.getAccesskeyid());
        parts.put(UPLOAD_POLICY, resource2.getPolicy());
        parts.put(UPLOAD_SIGNATURE, resource2.getSignature());
        parts.put(UPLOAD_CONTENT_TYPE, resource2.getMimeType());
        parts.put(UPLOAD_FILE, content);
        HttpURLConnection connection = MultiPartUtils.post(resource2.getS3Url(), parts);
        int status = connection.getResponseCode();
        if (status != 201) {
            throw new IOException("Unexpected response status of " + status);
        }
    }

    public DownloadResource createDownload(IRepositoryIdProvider repository, Download download, InputStream content, long size2) throws IOException {
        DownloadResource resource2 = this.createResource(repository, download);
        this.uploadResource(resource2, content, size2);
        return resource2;
    }

    public DownloadResource createDownload(IRepositoryIdProvider repository, Download download, File file2) throws IOException {
        if (file2 == null) {
            throw new IllegalArgumentException("File cannot be null");
        }
        return this.createDownload(repository, download, Files.newInputStream(file2.toPath(), new OpenOption[0]), file2.length());
    }
}

