/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.github.core.service;

import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.egit.github.core.Comment;
import org.eclipse.egit.github.core.Gist;
import org.eclipse.egit.github.core.client.GitHubClient;
import org.eclipse.egit.github.core.client.GitHubRequest;
import org.eclipse.egit.github.core.client.PageIterator;
import org.eclipse.egit.github.core.client.PagedRequest;
import org.eclipse.egit.github.core.service.GitHubService;

public class GistService
extends GitHubService {
    public GistService() {
    }

    public GistService(GitHubClient client2) {
        super(client2);
    }

    protected String checkGistId(String gistId) {
        if (gistId == null) {
            throw new IllegalArgumentException("Gist id cannot be null");
        }
        if (gistId.length() == 0) {
            throw new IllegalArgumentException("Gist id cannot be empty");
        }
        return gistId;
    }

    public Gist getGist(String id2) throws IOException {
        this.checkGistId(id2);
        StringBuilder uri = new StringBuilder("/gists");
        uri.append('/').append(id2);
        GitHubRequest request2 = this.createRequest();
        request2.setUri(uri);
        request2.setType((Type)((Object)Gist.class));
        return (Gist)this.client.get(request2).getBody();
    }

    public PageIterator<Gist> pageStarredGists() {
        return this.pageStarredGists(100);
    }

    public PageIterator<Gist> pageStarredGists(int size2) {
        return this.pageStarredGists(1, size2);
    }

    public PageIterator<Gist> pageStarredGists(int start, int size2) {
        PagedRequest request2 = this.createPagedRequest(start, size2);
        request2.setUri("/gists/starred");
        request2.setType(new TypeToken<List<Gist>>(){}.getType());
        return this.createPageIterator(request2);
    }

    public List<Gist> getStarredGists() throws IOException {
        return this.getAll(this.pageStarredGists());
    }

    protected PagedRequest<Gist> createUserGistRequest(String user2, int start, int size2) {
        if (user2 == null) {
            throw new IllegalArgumentException("User cannot be null");
        }
        if (user2.length() == 0) {
            throw new IllegalArgumentException("User cannot be empty");
        }
        StringBuilder uri = new StringBuilder("/users");
        uri.append('/').append(user2);
        uri.append("/gists");
        PagedRequest<Gist> request2 = this.createPagedRequest(start, size2);
        request2.setUri(uri).setType(new TypeToken<List<Gist>>(){}.getType());
        return request2;
    }

    public List<Gist> getGists(String user2) throws IOException {
        return this.getAll(this.pageGists(user2));
    }

    public PageIterator<Gist> pageGists(String user2) {
        return this.pageGists(user2, 100);
    }

    public PageIterator<Gist> pageGists(String user2, int size2) {
        return this.pageGists(user2, 1, size2);
    }

    public PageIterator<Gist> pageGists(String user2, int start, int size2) {
        PagedRequest<Gist> request2 = this.createUserGistRequest(user2, start, size2);
        return this.createPageIterator(request2);
    }

    public PageIterator<Gist> pagePublicGists() {
        return this.pagePublicGists(100);
    }

    public PageIterator<Gist> pagePublicGists(int size2) {
        return this.pagePublicGists(1, size2);
    }

    public PageIterator<Gist> pagePublicGists(int start, int size2) {
        PagedRequest request2 = this.createPagedRequest(start, size2);
        request2.setUri("/gists/public");
        request2.setType(new TypeToken<List<Gist>>(){}.getType());
        return this.createPageIterator(request2);
    }

    public Gist createGist(Gist gist) throws IOException {
        if (gist == null) {
            throw new IllegalArgumentException("Gist cannot be null");
        }
        return (Gist)this.client.post("/gists", gist, (Type)((Object)Gist.class));
    }

    public Gist updateGist(Gist gist) throws IOException {
        if (gist == null) {
            throw new IllegalArgumentException("Gist cannot be null");
        }
        String id2 = gist.getId();
        this.checkGistId(id2);
        StringBuilder uri = new StringBuilder("/gists");
        uri.append('/').append(id2);
        return (Gist)this.client.post(uri.toString(), gist, (Type)((Object)Gist.class));
    }

    public Comment createComment(String gistId, String comment) throws IOException {
        this.checkGistId(gistId);
        if (comment == null) {
            throw new IllegalArgumentException("Gist comment cannot be null");
        }
        StringBuilder uri = new StringBuilder("/gists");
        uri.append('/').append(gistId);
        uri.append("/comments");
        Map<String, String> params2 = Collections.singletonMap("body", comment);
        return (Comment)this.client.post(uri.toString(), params2, (Type)((Object)Comment.class));
    }

    public List<Comment> getComments(String gistId) throws IOException {
        this.checkGistId(gistId);
        StringBuilder uri = new StringBuilder("/gists");
        uri.append('/').append(gistId);
        uri.append("/comments");
        PagedRequest request2 = this.createPagedRequest();
        request2.setUri(uri).setType(new TypeToken<List<Comment>>(){}.getType());
        return this.getAll(request2);
    }

    public void deleteGist(String gistId) throws IOException {
        this.checkGistId(gistId);
        StringBuilder uri = new StringBuilder("/gists");
        uri.append('/').append(gistId);
        this.client.delete(uri.toString());
    }

    public Comment getComment(long commentId) throws IOException {
        StringBuilder uri = new StringBuilder("/gists/comments");
        uri.append('/').append(commentId);
        GitHubRequest request2 = this.createRequest();
        request2.setUri(uri);
        request2.setType((Type)((Object)Comment.class));
        return (Comment)this.client.get(request2).getBody();
    }

    public Comment editComment(Comment comment) throws IOException {
        if (comment == null) {
            throw new IllegalArgumentException("Comment cannot be null");
        }
        StringBuilder uri = new StringBuilder("/gists/comments");
        uri.append('/').append(comment.getId());
        return (Comment)this.client.post(uri.toString(), comment, (Type)((Object)Comment.class));
    }

    public void deleteComment(long commentId) throws IOException {
        StringBuilder uri = new StringBuilder("/gists/comments");
        uri.append('/').append(commentId);
        this.client.delete(uri.toString());
    }

    public void starGist(String gistId) throws IOException {
        this.checkGistId(gistId);
        StringBuilder uri = new StringBuilder("/gists");
        uri.append('/').append(gistId);
        uri.append("/star");
        this.client.put(uri.toString());
    }

    public void unstarGist(String gistId) throws IOException {
        this.checkGistId(gistId);
        StringBuilder uri = new StringBuilder("/gists");
        uri.append('/').append(gistId);
        uri.append("/star");
        this.client.delete(uri.toString());
    }

    public boolean isStarred(String gistId) throws IOException {
        this.checkGistId(gistId);
        StringBuilder uri = new StringBuilder("/gists");
        uri.append('/').append(gistId);
        uri.append("/star");
        return this.check(uri.toString());
    }

    public Gist forkGist(String gistId) throws IOException {
        this.checkGistId(gistId);
        StringBuilder uri = new StringBuilder("/gists");
        uri.append('/').append(gistId);
        uri.append("/fork");
        return (Gist)this.client.post(uri.toString(), null, (Type)((Object)Gist.class));
    }
}

