/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.github.core.service;

import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.List;
import org.eclipse.egit.github.core.IRepositoryIdProvider;
import org.eclipse.egit.github.core.Label;
import org.eclipse.egit.github.core.client.GitHubClient;
import org.eclipse.egit.github.core.client.GitHubRequest;
import org.eclipse.egit.github.core.client.PagedRequest;
import org.eclipse.egit.github.core.service.GitHubService;

public class LabelService
extends GitHubService {
    public LabelService() {
    }

    public LabelService(GitHubClient client2) {
        super(client2);
    }

    public List<Label> getLabels(IRepositoryIdProvider repository) throws IOException {
        String repoId = this.getId(repository);
        return this.getLabels(repoId);
    }

    public List<Label> getLabels(String user2, String repository) throws IOException {
        this.verifyRepository(user2, repository);
        String repoId = String.valueOf(user2) + '/' + repository;
        return this.getLabels(repoId);
    }

    private List<Label> getLabels(String id2) throws IOException {
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id2);
        uri.append("/labels");
        PagedRequest request2 = this.createPagedRequest();
        request2.setUri(uri);
        request2.setType(new TypeToken<List<Label>>(){}.getType());
        return this.getAll(request2);
    }

    public List<Label> setLabels(IRepositoryIdProvider repository, String issueId, List<Label> labels) throws IOException {
        String repoId = this.getId(repository);
        return this.setLabels(repoId, issueId, labels);
    }

    public List<Label> setLabels(String user2, String repository, String issueId, List<Label> labels) throws IOException {
        this.verifyRepository(user2, repository);
        String repoId = String.valueOf(user2) + '/' + repository;
        return this.setLabels(repoId, issueId, labels);
    }

    private List<Label> setLabels(String id2, String issueId, List<Label> labels) throws IOException {
        if (issueId == null) {
            throw new IllegalArgumentException("Issue id cannot be null");
        }
        if (issueId.length() == 0) {
            throw new IllegalArgumentException("Issue id cannot be empty");
        }
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id2);
        uri.append("/issues");
        uri.append('/').append(issueId);
        uri.append("/labels");
        return (List)this.client.put(uri.toString(), labels, new TypeToken<List<Label>>(){}.getType());
    }

    public Label createLabel(IRepositoryIdProvider repository, Label label) throws IOException {
        String repoId = this.getId(repository);
        return this.createLabel(repoId, label);
    }

    public Label createLabel(String user2, String repository, Label label) throws IOException {
        this.verifyRepository(user2, repository);
        String repoId = String.valueOf(user2) + '/' + repository;
        return this.createLabel(repoId, label);
    }

    private Label createLabel(String id2, Label label) throws IOException {
        if (label == null) {
            throw new IllegalArgumentException("Label cannot be null");
        }
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id2);
        uri.append("/labels");
        return (Label)this.client.post(uri.toString(), label, (Type)((Object)Label.class));
    }

    public Label getLabel(IRepositoryIdProvider repository, String label) throws IOException {
        String repoId = this.getId(repository);
        return this.getLabel(repoId, label);
    }

    public Label getLabel(String user2, String repository, String label) throws IOException {
        this.verifyRepository(user2, repository);
        String repoId = String.valueOf(user2) + '/' + repository;
        return this.getLabel(repoId, label);
    }

    private Label getLabel(String id2, String label) throws IOException {
        if (label == null) {
            throw new IllegalArgumentException("Label cannot be null");
        }
        if (label.length() == 0) {
            throw new IllegalArgumentException("Label cannot be empty");
        }
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id2);
        uri.append("/labels");
        uri.append('/').append(label);
        GitHubRequest request2 = this.createRequest();
        request2.setUri(uri);
        request2.setType((Type)((Object)Label.class));
        return (Label)this.client.get(request2).getBody();
    }

    public void deleteLabel(IRepositoryIdProvider repository, String label) throws IOException {
        String repoId = this.getId(repository);
        this.deleteLabel(repoId, label);
    }

    public void deleteLabel(String user2, String repository, String label) throws IOException {
        this.verifyRepository(user2, repository);
        String repoId = String.valueOf(user2) + '/' + repository;
        this.deleteLabel(repoId, label);
    }

    private void deleteLabel(String id2, String label) throws IOException {
        if (label == null) {
            throw new IllegalArgumentException("Label cannot be null");
        }
        if (label.length() == 0) {
            throw new IllegalArgumentException("Label cannot be empty");
        }
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id2);
        uri.append("/labels");
        uri.append('/').append(label);
        this.client.delete(uri.toString());
    }

    public Label editLabel(IRepositoryIdProvider repository, Label label) throws IOException {
        String repoId = this.getId(repository);
        if (label == null) {
            throw new IllegalArgumentException("Label cannot be null");
        }
        String name = label.getName();
        if (name == null) {
            throw new IllegalArgumentException("Label name cannot be null");
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException("Label name cannot be empty");
        }
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(repoId);
        uri.append("/labels");
        uri.append('/').append(name);
        return (Label)this.client.post(uri.toString(), label, (Type)((Object)Label.class));
    }
}

