/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.github.core.service;

import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.egit.github.core.IRepositoryIdProvider;
import org.eclipse.egit.github.core.Milestone;
import org.eclipse.egit.github.core.client.GitHubClient;
import org.eclipse.egit.github.core.client.GitHubRequest;
import org.eclipse.egit.github.core.client.PagedRequest;
import org.eclipse.egit.github.core.service.GitHubService;

public class MilestoneService
extends GitHubService {
    private static final String TITLE = "title";
    private static final String DESCRIPTION = "description";
    private static final String DUE_ON = "due_on";
    private static final String STATE = "state";

    public MilestoneService() {
    }

    public MilestoneService(GitHubClient client2) {
        super(client2);
    }

    public List<Milestone> getMilestones(IRepositoryIdProvider repository, String state) throws IOException {
        String repoId = this.getId(repository);
        return this.getMilestones(repoId, state);
    }

    public List<Milestone> getMilestones(String user2, String repository, String state) throws IOException {
        this.verifyRepository(user2, repository);
        String repoId = String.valueOf(user2) + '/' + repository;
        return this.getMilestones(repoId, state);
    }

    private List<Milestone> getMilestones(String id2, String state) throws IOException {
        String uri = "/repos/" + id2 + "/milestones";
        PagedRequest request2 = this.createPagedRequest();
        if (state != null) {
            request2.setParams(Collections.singletonMap(STATE, state));
        }
        request2.setUri(uri).setType(new TypeToken<List<Milestone>>(){}.getType());
        return this.getAll(request2);
    }

    public Milestone createMilestone(IRepositoryIdProvider repository, Milestone milestone) throws IOException {
        String repoId = this.getId(repository);
        return this.createMilestone(repoId, milestone);
    }

    public Milestone createMilestone(String user2, String repository, Milestone milestone) throws IOException {
        this.verifyRepository(user2, repository);
        String repoId = String.valueOf(user2) + '/' + repository;
        return this.createMilestone(repoId, milestone);
    }

    private Map<String, Object> createParams(Milestone milestone, boolean titleRequired) {
        Date date;
        LinkedHashMap<String, Object> params2 = new LinkedHashMap<String, Object>();
        String value2 = milestone.getTitle();
        if (titleRequired && value2 == null) {
            throw new IllegalArgumentException("Milestone title must not be null");
        }
        if (value2 != null) {
            params2.put(TITLE, value2);
        }
        if ((value2 = milestone.getState()) != null) {
            if (!"open".equals(value2) && !"closed".equals(value2)) {
                throw new IllegalArgumentException("Milestone state must be 'open' or 'closed', or null for default ('open')");
            }
            params2.put(STATE, value2);
        }
        if ((value2 = milestone.getDescription()) != null) {
            params2.put(DESCRIPTION, value2);
        }
        if ((date = milestone.getDueOn()) != null) {
            params2.put(DUE_ON, date);
        }
        if (params2.isEmpty()) {
            throw new IllegalArgumentException("Milestone operation requires at least one of title, description, state, or due date");
        }
        return params2;
    }

    private Milestone createMilestone(String id2, Milestone milestone) throws IOException {
        if (milestone == null) {
            throw new IllegalArgumentException("Milestone cannot be null");
        }
        String uri = "/repos/" + id2 + "/milestones";
        Map<String, Object> dto = this.createParams(milestone, true);
        return (Milestone)this.client.post(uri, dto, (Type)((Object)Milestone.class));
    }

    public Milestone getMilestone(IRepositoryIdProvider repository, int number) throws IOException {
        return this.getMilestone(repository, Integer.toString(number));
    }

    public Milestone getMilestone(IRepositoryIdProvider repository, String number) throws IOException {
        String repoId = this.getId(repository);
        return this.getMilestone(repoId, number);
    }

    public Milestone getMilestone(String user2, String repository, int number) throws IOException {
        return this.getMilestone(user2, repository, Integer.toString(number));
    }

    public Milestone getMilestone(String user2, String repository, String number) throws IOException {
        this.verifyRepository(user2, repository);
        String repoId = String.valueOf(user2) + '/' + repository;
        return this.getMilestone(repoId, number);
    }

    private Milestone getMilestone(String id2, String number) throws IOException {
        if (number == null || number.isEmpty()) {
            throw new IllegalArgumentException("Milestone cannot be null or empty");
        }
        String uri = "/repos/" + id2 + "/milestones" + '/' + number;
        GitHubRequest request2 = this.createRequest();
        request2.setUri(uri);
        request2.setType((Type)((Object)Milestone.class));
        return (Milestone)this.client.get(request2).getBody();
    }

    public void deleteMilestone(IRepositoryIdProvider repository, int milestone) throws IOException {
        this.deleteMilestone(repository, Integer.toString(milestone));
    }

    public void deleteMilestone(IRepositoryIdProvider repository, String milestone) throws IOException {
        String repoId = this.getId(repository);
        this.deleteMilestone(repoId, milestone);
    }

    public void deleteMilestone(String user2, String repository, int milestone) throws IOException {
        this.deleteMilestone(user2, repository, Integer.toString(milestone));
    }

    public void deleteMilestone(String user2, String repository, String milestone) throws IOException {
        this.verifyRepository(user2, repository);
        String repoId = String.valueOf(user2) + '/' + repository;
        this.deleteMilestone(repoId, milestone);
    }

    private void deleteMilestone(String id2, String milestone) throws IOException {
        if (milestone == null || milestone.isEmpty()) {
            throw new IllegalArgumentException("Milestone cannot be null or empty");
        }
        String uri = "/repos/" + id2 + "/milestones" + '/' + milestone;
        this.client.delete(uri);
    }

    public Milestone editMilestone(IRepositoryIdProvider repository, Milestone milestone) throws IOException {
        String repoId = this.getId(repository);
        if (milestone == null) {
            throw new IllegalArgumentException("Milestone cannot be null");
        }
        String uri = "/repos/" + repoId + "/milestones" + '/' + milestone.getNumber();
        Map<String, Object> dto = this.createParams(milestone, false);
        return (Milestone)this.client.post(uri, dto, (Type)((Object)Milestone.class));
    }
}

