/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.github.core.service;

import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.egit.github.core.Authorization;
import org.eclipse.egit.github.core.client.GitHubClient;
import org.eclipse.egit.github.core.client.GitHubRequest;
import org.eclipse.egit.github.core.client.PagedRequest;
import org.eclipse.egit.github.core.service.GitHubService;

public class OAuthService
extends GitHubService {
    public OAuthService() {
    }

    public OAuthService(GitHubClient client2) {
        super(client2);
    }

    public List<Authorization> getAuthorizations() throws IOException {
        PagedRequest request2 = this.createPagedRequest();
        request2.setUri("/authorizations");
        request2.setType(new TypeToken<List<Authorization>>(){}.getType());
        return this.getAll(request2);
    }

    public Authorization getAuthorization(int id2) throws IOException {
        GitHubRequest request2 = this.createRequest();
        StringBuilder uri = new StringBuilder("/authorizations");
        uri.append('/').append(id2);
        request2.setUri(uri);
        request2.setType((Type)((Object)Authorization.class));
        return (Authorization)this.client.get(request2).getBody();
    }

    public void deleteAuthorization(int id2) throws IOException {
        StringBuilder uri = new StringBuilder("/authorizations");
        uri.append('/').append(id2);
        this.client.delete(uri.toString());
    }

    public Authorization createAuthorization(Authorization authorization) throws IOException {
        return (Authorization)this.client.post("/authorizations", authorization, (Type)((Object)Authorization.class));
    }

    public Authorization addScopes(int id2, Collection<String> scopes) throws IOException {
        StringBuilder uri = new StringBuilder("/authorizations");
        uri.append('/').append(id2);
        Map<String, Collection<String>> params2 = Collections.singletonMap("add_scopes", scopes);
        return (Authorization)this.client.post(uri.toString(), params2, (Type)((Object)Authorization.class));
    }

    public Authorization removeScopes(int id2, Collection<String> scopes) throws IOException {
        StringBuilder uri = new StringBuilder("/authorizations");
        uri.append('/').append(id2);
        Map<String, Collection<String>> params2 = Collections.singletonMap("remove_scopes", scopes);
        return (Authorization)this.client.post(uri.toString(), params2, (Type)((Object)Authorization.class));
    }

    public Authorization setScopes(int id2, Collection<String> scopes) throws IOException {
        StringBuilder uri = new StringBuilder("/authorizations");
        uri.append('/').append(id2);
        Map<String, Collection<String>> params2 = Collections.singletonMap("scopes", scopes);
        return (Authorization)this.client.post(uri.toString(), params2, (Type)((Object)Authorization.class));
    }
}

