/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.github.core.service;

import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.egit.github.core.CommitComment;
import org.eclipse.egit.github.core.CommitFile;
import org.eclipse.egit.github.core.IRepositoryIdProvider;
import org.eclipse.egit.github.core.MergeStatus;
import org.eclipse.egit.github.core.PullRequest;
import org.eclipse.egit.github.core.PullRequestMarker;
import org.eclipse.egit.github.core.RepositoryCommit;
import org.eclipse.egit.github.core.client.GitHubClient;
import org.eclipse.egit.github.core.client.GitHubRequest;
import org.eclipse.egit.github.core.client.PageIterator;
import org.eclipse.egit.github.core.client.PagedRequest;
import org.eclipse.egit.github.core.service.GitHubService;

public class PullRequestService
extends GitHubService {
    public static final String PR_TITLE = "title";
    public static final String PR_BODY = "body";
    public static final String PR_BASE = "base";
    public static final String PR_HEAD = "head";
    public static final String PR_STATE = "state";

    public PullRequestService() {
    }

    public PullRequestService(GitHubClient client2) {
        super(client2);
    }

    public PullRequest getPullRequest(IRepositoryIdProvider repository, int id2) throws IOException {
        String repoId = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(repoId);
        uri.append("/pulls");
        uri.append('/').append(id2);
        GitHubRequest request2 = this.createRequest();
        request2.setUri(uri);
        request2.setType((Type)((Object)PullRequest.class));
        return (PullRequest)this.client.get(request2).getBody();
    }

    protected PagedRequest<PullRequest> createPullsRequest(IRepositoryIdProvider provider, String state, int start, int size2) {
        String id2 = this.getId(provider);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id2);
        uri.append("/pulls");
        PagedRequest<PullRequest> request2 = this.createPagedRequest(start, size2);
        request2.setUri(uri);
        if (state != null) {
            request2.setParams(Collections.singletonMap(PR_STATE, state));
        }
        request2.setType(new TypeToken<List<PullRequest>>(){}.getType());
        return request2;
    }

    public List<PullRequest> getPullRequests(IRepositoryIdProvider repository, String state) throws IOException {
        return this.getAll(this.pagePullRequests(repository, state));
    }

    public PageIterator<PullRequest> pagePullRequests(IRepositoryIdProvider repository, String state) {
        return this.pagePullRequests(repository, state, 100);
    }

    public PageIterator<PullRequest> pagePullRequests(IRepositoryIdProvider repository, String state, int size2) {
        return this.pagePullRequests(repository, state, 1, size2);
    }

    public PageIterator<PullRequest> pagePullRequests(IRepositoryIdProvider repository, String state, int start, int size2) {
        PagedRequest<PullRequest> request2 = this.createPullsRequest(repository, state, start, size2);
        return this.createPageIterator(request2);
    }

    private Map<String, String> createPrMap(PullRequest request2) {
        HashMap<String, String> params2 = new HashMap<String, String>();
        if (request2 != null) {
            String head;
            PullRequestMarker headMarker;
            String base;
            PullRequestMarker baseMarker;
            String body2;
            String title = request2.getTitle();
            if (title != null) {
                params2.put(PR_TITLE, title);
            }
            if ((body2 = request2.getBody()) != null) {
                params2.put(PR_BODY, body2);
            }
            if ((baseMarker = request2.getBase()) != null && (base = baseMarker.getLabel()) != null) {
                params2.put(PR_BASE, base);
            }
            if ((headMarker = request2.getHead()) != null && (head = headMarker.getLabel()) != null) {
                params2.put(PR_HEAD, head);
            }
        }
        return params2;
    }

    private Map<String, String> editPrMap(PullRequest request2) {
        String state;
        String body2;
        HashMap<String, String> params2 = new HashMap<String, String>();
        String title = request2.getTitle();
        if (title != null) {
            params2.put(PR_TITLE, title);
        }
        if ((body2 = request2.getBody()) != null) {
            params2.put(PR_BODY, body2);
        }
        if ((state = request2.getState()) != null) {
            params2.put(PR_STATE, state);
        }
        return params2;
    }

    public PullRequest createPullRequest(IRepositoryIdProvider repository, PullRequest request2) throws IOException {
        String id2 = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id2);
        uri.append("/pulls");
        Map<String, String> params2 = this.createPrMap(request2);
        return (PullRequest)this.client.post(uri.toString(), params2, (Type)((Object)PullRequest.class));
    }

    public PullRequest createPullRequest(IRepositoryIdProvider repository, int issueId, String head, String base) throws IOException {
        String id2 = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id2);
        uri.append("/pulls");
        HashMap<String, Object> params2 = new HashMap<String, Object>();
        params2.put("issue", issueId);
        params2.put(PR_HEAD, head);
        params2.put(PR_BASE, base);
        return (PullRequest)this.client.post(uri.toString(), params2, (Type)((Object)PullRequest.class));
    }

    public PullRequest editPullRequest(IRepositoryIdProvider repository, PullRequest request2) throws IOException {
        String id2 = this.getId(repository);
        if (request2 == null) {
            throw new IllegalArgumentException("Request cannot be null");
        }
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id2);
        uri.append("/pulls");
        uri.append('/').append(request2.getNumber());
        Map<String, String> params2 = this.editPrMap(request2);
        return (PullRequest)this.client.post(uri.toString(), params2, (Type)((Object)PullRequest.class));
    }

    public List<RepositoryCommit> getCommits(IRepositoryIdProvider repository, int id2) throws IOException {
        String repoId = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(repoId);
        uri.append("/pulls");
        uri.append('/').append(id2);
        uri.append("/commits");
        PagedRequest request2 = this.createPagedRequest();
        request2.setUri(uri);
        request2.setType(new TypeToken<List<RepositoryCommit>>(){}.getType());
        return this.getAll(request2);
    }

    public List<CommitFile> getFiles(IRepositoryIdProvider repository, int id2) throws IOException {
        String repoId = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(repoId);
        uri.append("/pulls");
        uri.append('/').append(id2);
        uri.append("/files");
        PagedRequest request2 = this.createPagedRequest();
        request2.setUri(uri);
        request2.setType(new TypeToken<List<CommitFile>>(){}.getType());
        return this.getAll(request2);
    }

    public boolean isMerged(IRepositoryIdProvider repository, int id2) throws IOException {
        String repoId = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(repoId);
        uri.append("/pulls");
        uri.append('/').append(id2);
        uri.append("/merge");
        return this.check(uri.toString());
    }

    public MergeStatus merge(IRepositoryIdProvider repository, int id2, String commitMessage) throws IOException {
        String repoId = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(repoId);
        uri.append("/pulls");
        uri.append('/').append(id2);
        uri.append("/merge");
        return (MergeStatus)this.client.put(uri.toString(), Collections.singletonMap("commit_message", commitMessage), (Type)((Object)MergeStatus.class));
    }

    public List<CommitComment> getComments(IRepositoryIdProvider repository, int id2) throws IOException {
        return this.getAll(this.pageComments(repository, id2));
    }

    public PageIterator<CommitComment> pageComments(IRepositoryIdProvider repository, int id2) {
        return this.pageComments(repository, id2, 100);
    }

    public PageIterator<CommitComment> pageComments(IRepositoryIdProvider repository, int id2, int size2) {
        return this.pageComments(repository, id2, 1, size2);
    }

    public PageIterator<CommitComment> pageComments(IRepositoryIdProvider repository, int id2, int start, int size2) {
        String repoId = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(repoId);
        uri.append("/pulls");
        uri.append('/').append(id2);
        uri.append("/comments");
        PagedRequest request2 = this.createPagedRequest(start, size2);
        request2.setUri(uri);
        request2.setType(new TypeToken<List<CommitComment>>(){}.getType());
        return this.createPageIterator(request2);
    }

    public CommitComment getComment(IRepositoryIdProvider repository, long commentId) throws IOException {
        String repoId = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(repoId);
        uri.append("/pulls");
        uri.append("/comments");
        uri.append('/').append(commentId);
        GitHubRequest request2 = this.createRequest();
        request2.setUri(uri);
        request2.setType((Type)((Object)CommitComment.class));
        return (CommitComment)this.client.get(request2).getBody();
    }

    public CommitComment createComment(IRepositoryIdProvider repository, int id2, CommitComment comment) throws IOException {
        String repoId = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(repoId);
        uri.append("/pulls");
        uri.append('/').append(id2);
        uri.append("/comments");
        return (CommitComment)this.client.post(uri.toString(), comment, (Type)((Object)CommitComment.class));
    }

    public CommitComment replyToComment(IRepositoryIdProvider repository, int pullRequestId, int commentId, String body2) throws IOException {
        String repoId = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(repoId);
        uri.append("/pulls");
        uri.append('/').append(pullRequestId);
        uri.append("/comments");
        HashMap<String, String> params2 = new HashMap<String, String>();
        params2.put("in_reply_to", Integer.toString(commentId));
        params2.put(PR_BODY, body2);
        return (CommitComment)this.client.post(uri.toString(), params2, (Type)((Object)CommitComment.class));
    }

    public CommitComment editComment(IRepositoryIdProvider repository, CommitComment comment) throws IOException {
        String repoId = this.getId(repository);
        if (comment == null) {
            throw new IllegalArgumentException("Comment cannot be null");
        }
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(repoId);
        uri.append("/pulls");
        uri.append("/comments");
        uri.append('/').append(comment.getId());
        return (CommitComment)this.client.post(uri.toString(), comment, (Type)((Object)CommitComment.class));
    }

    public void deleteComment(IRepositoryIdProvider repository, long commentId) throws IOException {
        String repoId = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(repoId);
        uri.append("/pulls");
        uri.append("/comments");
        uri.append('/').append(commentId);
        this.client.delete(uri.toString());
    }
}

