/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.github.core.service;

import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.util.List;
import org.eclipse.egit.github.core.IRepositoryIdProvider;
import org.eclipse.egit.github.core.Repository;
import org.eclipse.egit.github.core.User;
import org.eclipse.egit.github.core.client.GitHubClient;
import org.eclipse.egit.github.core.client.PageIterator;
import org.eclipse.egit.github.core.client.PagedRequest;
import org.eclipse.egit.github.core.service.GitHubService;

public class StargazerService
extends GitHubService {
    public StargazerService() {
    }

    public StargazerService(GitHubClient client2) {
        super(client2);
    }

    protected PagedRequest<User> createStargazerRequest(IRepositoryIdProvider repository, int start, int size2) {
        String id2 = this.getId(repository);
        PagedRequest<User> request2 = this.createPagedRequest(start, size2);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id2);
        uri.append("/stargazers");
        request2.setUri(uri);
        request2.setType(new TypeToken<List<User>>(){}.getType());
        return request2;
    }

    public List<User> getStargazers(IRepositoryIdProvider repository) throws IOException {
        PagedRequest<User> request2 = this.createStargazerRequest(repository, 1, 100);
        return this.getAll(request2);
    }

    public PageIterator<User> pageStargazers(IRepositoryIdProvider repository) {
        return this.pageStargazers(repository, 100);
    }

    public PageIterator<User> pageStargazers(IRepositoryIdProvider repository, int size2) {
        return this.pageStargazers(repository, 1, size2);
    }

    public PageIterator<User> pageStargazers(IRepositoryIdProvider repository, int start, int size2) {
        PagedRequest<User> request2 = this.createStargazerRequest(repository, start, size2);
        return this.createPageIterator(request2);
    }

    protected PagedRequest<Repository> createStarredRequest(String user2, int start, int size2) {
        if (user2 == null) {
            throw new IllegalArgumentException("User cannot be null");
        }
        if (user2.length() == 0) {
            throw new IllegalArgumentException("User cannot be empty");
        }
        PagedRequest<Repository> request2 = this.createPagedRequest(start, size2);
        StringBuilder uri = new StringBuilder("/users");
        uri.append('/').append(user2);
        uri.append("/starred");
        request2.setUri(uri);
        request2.setType(new TypeToken<List<Repository>>(){}.getType());
        return request2;
    }

    protected PagedRequest<Repository> createStarredRequest(int start, int size2) {
        PagedRequest<Repository> request2 = this.createPagedRequest(start, size2);
        request2.setUri("/user/starred");
        request2.setType(new TypeToken<List<Repository>>(){}.getType());
        return request2;
    }

    public List<Repository> getStarred(String user2) throws IOException {
        PagedRequest<Repository> request2 = this.createStarredRequest(user2, 1, 100);
        return this.getAll(request2);
    }

    public PageIterator<Repository> pageStarred(String user2) throws IOException {
        return this.pageStarred(user2, 100);
    }

    public PageIterator<Repository> pageStarred(String user2, int size2) throws IOException {
        return this.pageStarred(user2, 1, size2);
    }

    public PageIterator<Repository> pageStarred(String user2, int start, int size2) throws IOException {
        PagedRequest<Repository> request2 = this.createStarredRequest(user2, start, size2);
        return this.createPageIterator(request2);
    }

    public List<Repository> getStarred() throws IOException {
        PagedRequest<Repository> request2 = this.createStarredRequest(1, 100);
        return this.getAll(request2);
    }

    public PageIterator<Repository> pageStarred() throws IOException {
        return this.pageStarred(100);
    }

    public PageIterator<Repository> pageStarred(int size2) throws IOException {
        return this.pageStarred(1, size2);
    }

    public PageIterator<Repository> pageStarred(int start, int size2) throws IOException {
        PagedRequest<Repository> request2 = this.createStarredRequest(start, size2);
        return this.createPageIterator(request2);
    }

    public boolean isStarring(IRepositoryIdProvider repository) throws IOException {
        String id2 = this.getId(repository);
        StringBuilder uri = new StringBuilder("/user");
        uri.append("/starred");
        uri.append('/').append(id2);
        return this.check(uri.toString());
    }

    public void star(IRepositoryIdProvider repository) throws IOException {
        String id2 = this.getId(repository);
        StringBuilder uri = new StringBuilder("/user");
        uri.append("/starred");
        uri.append('/').append(id2);
        this.client.put(uri.toString());
    }

    public void unstar(IRepositoryIdProvider repository) throws IOException {
        String id2 = this.getId(repository);
        StringBuilder uri = new StringBuilder("/user");
        uri.append("/starred");
        uri.append('/').append(id2);
        this.client.delete(uri.toString());
    }
}

