/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.errors;

import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.ObjectId;

public class MissingObjectException
extends IOException {
    private static final long serialVersionUID = 1L;
    private final ObjectId missing;

    public MissingObjectException(ObjectId id2, String type2) {
        super(MessageFormat.format(JGitText.get().missingObject, type2, id2.name()));
        this.missing = id2.copy();
    }

    public MissingObjectException(ObjectId id2, int type2) {
        this(id2, Constants.typeString(type2));
    }

    public MissingObjectException(AbbreviatedObjectId id2, int type2) {
        super(MessageFormat.format(JGitText.get().missingObject, Constants.typeString(type2), id2.name()));
        this.missing = null;
    }

    public ObjectId getObjectId() {
        return this.missing;
    }
}

