/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.ketch;

import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;

public class LogIndex
extends ObjectId {
    private final long index;

    static LogIndex unknown(AnyObjectId id2) {
        return new LogIndex(id2, 0L);
    }

    private LogIndex(AnyObjectId id2, long index) {
        super(id2);
        this.index = index;
    }

    LogIndex nextIndex(AnyObjectId id2) {
        return new LogIndex(id2, this.index + 1L);
    }

    public long getIndex() {
        return this.index;
    }

    boolean isBefore(LogIndex c) {
        return this.index <= c.index;
    }

    public String describeForLog() {
        return String.format("%5d/%s", this.index, this.abbreviate(6).name());
    }

    @Override
    public String toString() {
        return String.format("LogId[%5d/%s]", this.index, this.name());
    }
}

