/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.io.IOException;
import org.eclipse.jgit.internal.storage.file.PackFile;
import org.eclipse.jgit.internal.storage.pack.StoredObjectRepresentation;
import org.eclipse.jgit.lib.ObjectId;

class LocalObjectRepresentation
extends StoredObjectRepresentation {
    PackFile pack;
    long offset;
    long length;
    private long baseOffset;
    private ObjectId baseId;

    LocalObjectRepresentation() {
    }

    static LocalObjectRepresentation newWhole(PackFile f, long p, long length2) {
        LocalObjectRepresentation r = new LocalObjectRepresentation(){

            @Override
            public int getFormat() {
                return 1;
            }
        };
        r.pack = f;
        r.offset = p;
        r.length = length2;
        return r;
    }

    static LocalObjectRepresentation newDelta(PackFile f, long p, long n, ObjectId base) {
        Delta r = new Delta();
        r.pack = f;
        r.offset = p;
        r.length = n;
        r.baseId = base;
        return r;
    }

    static LocalObjectRepresentation newDelta(PackFile f, long p, long n, long base) {
        Delta r = new Delta();
        r.pack = f;
        r.offset = p;
        r.length = n;
        r.baseOffset = base;
        return r;
    }

    @Override
    public int getWeight() {
        return (int)Math.min(this.length, Integer.MAX_VALUE);
    }

    @Override
    public ObjectId getDeltaBase() {
        if (this.baseId == null && this.getFormat() == 0) {
            try {
                this.baseId = this.pack.findObjectForOffset(this.baseOffset);
            }
            catch (IOException error2) {
                return null;
            }
        }
        return this.baseId;
    }

    private static final class Delta
    extends LocalObjectRepresentation {
        private Delta() {
        }

        @Override
        public int getFormat() {
            return 0;
        }
    }
}

