/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipException;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.LargeObjectException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.FileObjectDatabase;
import org.eclipse.jgit.internal.storage.file.WindowCursor;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.InflaterCache;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectStream;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.MutableInteger;
import org.eclipse.jgit.util.RawParseUtils;

public class UnpackedObject {
    private static final int BUFFER_SIZE = 8192;

    public static ObjectLoader parse(byte[] raw, AnyObjectId id2) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (WindowCursor wc = new WindowCursor(null);){
            return UnpackedObject.open(new ByteArrayInputStream(raw), null, id2, wc);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    static ObjectLoader open(InputStream in, File path, AnyObjectId id2, WindowCursor wc) throws IOException {
        try {
            in = UnpackedObject.buffer(in);
            in.mark(20);
            byte[] hdr = new byte[64];
            IO.readFully(in, hdr, 0, 2);
            if (UnpackedObject.isStandardFormat(hdr)) {
                in.reset();
                Inflater inf = wc.inflater();
                InflaterInputStream zIn = UnpackedObject.inflate(in, inf);
                int avail = UnpackedObject.readSome(zIn, hdr, 0, 64);
                if (avail < 5) {
                    throw new CorruptObjectException(id2, JGitText.get().corruptObjectNoHeader);
                }
                MutableInteger p = new MutableInteger();
                int type2 = Constants.decodeTypeString(id2, hdr, (byte)32, p);
                long size2 = RawParseUtils.parseLongBase10(hdr, p.value, p);
                if (size2 < 0L) {
                    throw new CorruptObjectException(id2, JGitText.get().corruptObjectNegativeSize);
                }
                if (hdr[p.value++] != 0) {
                    throw new CorruptObjectException(id2, JGitText.get().corruptObjectGarbageAfterSize);
                }
                if (path == null && Integer.MAX_VALUE < size2) {
                    LargeObjectException.ExceedsByteArrayLimit e = new LargeObjectException.ExceedsByteArrayLimit();
                    e.setObjectId(id2);
                    throw e;
                }
                if (size2 < (long)wc.getStreamFileThreshold() || path == null) {
                    byte[] data2 = new byte[(int)size2];
                    int n = avail - p.value;
                    if (n > 0) {
                        System.arraycopy(hdr, p.value, data2, 0, n);
                    }
                    IO.readFully(zIn, data2, n, data2.length - n);
                    UnpackedObject.checkValidEndOfStream(in, inf, id2, hdr);
                    return new ObjectLoader.SmallObject(type2, data2);
                }
                return new LargeObject(type2, size2, path, id2, wc.db);
            }
            UnpackedObject.readSome(in, hdr, 2, 18);
            int c = hdr[0] & 0xFF;
            int type3 = c >> 4 & 7;
            long size3 = c & 0xF;
            int shift = 4;
            int p = 1;
            while ((c & 0x80) != 0) {
                c = hdr[p++] & 0xFF;
                size3 += (long)(c & 0x7F) << shift;
                shift += 7;
            }
            switch (type3) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
                default: {
                    throw new CorruptObjectException(id2, JGitText.get().corruptObjectInvalidType);
                }
            }
            if (path == null && Integer.MAX_VALUE < size3) {
                LargeObjectException.ExceedsByteArrayLimit e = new LargeObjectException.ExceedsByteArrayLimit();
                e.setObjectId(id2);
                throw e;
            }
            if (size3 < (long)wc.getStreamFileThreshold() || path == null) {
                in.reset();
                IO.skipFully(in, p);
                Inflater inf = wc.inflater();
                InflaterInputStream zIn = UnpackedObject.inflate(in, inf);
                byte[] data3 = new byte[(int)size3];
                IO.readFully(zIn, data3, 0, data3.length);
                UnpackedObject.checkValidEndOfStream(in, inf, id2, hdr);
                return new ObjectLoader.SmallObject(type3, data3);
            }
            return new LargeObject(type3, size3, path, id2, wc.db);
        }
        catch (ZipException badStream) {
            CorruptObjectException coe = new CorruptObjectException(id2, JGitText.get().corruptObjectBadStream);
            coe.initCause(badStream);
            throw coe;
        }
    }

    static long getSize(InputStream in, AnyObjectId id2, WindowCursor wc) throws IOException {
        try {
            in = UnpackedObject.buffer(in);
            in.mark(20);
            byte[] hdr = new byte[64];
            IO.readFully(in, hdr, 0, 2);
            if (UnpackedObject.isStandardFormat(hdr)) {
                in.reset();
                Inflater inf = wc.inflater();
                InflaterInputStream zIn = UnpackedObject.inflate(in, inf);
                int avail = UnpackedObject.readSome(zIn, hdr, 0, 64);
                if (avail < 5) {
                    throw new CorruptObjectException(id2, JGitText.get().corruptObjectNoHeader);
                }
                MutableInteger p = new MutableInteger();
                Constants.decodeTypeString(id2, hdr, (byte)32, p);
                long size2 = RawParseUtils.parseLongBase10(hdr, p.value, p);
                if (size2 < 0L) {
                    throw new CorruptObjectException(id2, JGitText.get().corruptObjectNegativeSize);
                }
                return size2;
            }
            UnpackedObject.readSome(in, hdr, 2, 18);
            int c = hdr[0] & 0xFF;
            long size3 = c & 0xF;
            int shift = 4;
            int p = 1;
            while ((c & 0x80) != 0) {
                c = hdr[p++] & 0xFF;
                size3 += (long)(c & 0x7F) << shift;
                shift += 7;
            }
            return size3;
        }
        catch (ZipException badStream) {
            CorruptObjectException coe = new CorruptObjectException(id2, JGitText.get().corruptObjectBadStream);
            coe.initCause(badStream);
            throw coe;
        }
    }

    static void checkValidEndOfStream(InputStream in, Inflater inf, AnyObjectId id2, byte[] buf) throws IOException, CorruptObjectException {
        while (true) {
            int r;
            try {
                r = inf.inflate(buf);
            }
            catch (DataFormatException e) {
                CorruptObjectException coe = new CorruptObjectException(id2, JGitText.get().corruptObjectBadStream);
                coe.initCause(e);
                throw coe;
            }
            if (r != 0) {
                throw new CorruptObjectException(id2, JGitText.get().corruptObjectIncorrectLength);
            }
            if (inf.finished()) {
                if (inf.getRemaining() == 0 && in.read() == -1) break;
                throw new CorruptObjectException(id2, JGitText.get().corruptObjectBadStream);
            }
            if (!inf.needsInput()) {
                throw new CorruptObjectException(id2, JGitText.get().corruptObjectBadStream);
            }
            r = in.read(buf);
            if (r <= 0) {
                throw new CorruptObjectException(id2, JGitText.get().corruptObjectBadStream);
            }
            inf.setInput(buf, 0, r);
        }
    }

    static boolean isStandardFormat(byte[] hdr) {
        int fb = hdr[0] & 0xFF;
        return (fb & 0x8F) == 8 && (fb << 8 | hdr[1] & 0xFF) % 31 == 0;
    }

    static InputStream inflate(InputStream in, long size2, final ObjectId id2) {
        Inflater inf = InflaterCache.get();
        return new InflaterInputStream(in, inf, size2){
            private long remaining;
            {
                super($anonymous0, $anonymous1);
                this.remaining = l;
            }

            @Override
            public int read(byte[] b, int off, int cnt) throws IOException {
                try {
                    int r = super.read(b, off, cnt);
                    if (r > 0) {
                        this.remaining -= (long)r;
                    }
                    return r;
                }
                catch (ZipException badStream) {
                    CorruptObjectException coe = new CorruptObjectException(id2, JGitText.get().corruptObjectBadStream);
                    coe.initCause(badStream);
                    throw coe;
                }
            }

            @Override
            public void close() throws IOException {
                try {
                    if (this.remaining <= 0L) {
                        UnpackedObject.checkValidEndOfStream(this.in, this.inf, id2, new byte[64]);
                    }
                }
                finally {
                    InflaterCache.release(this.inf);
                    super.close();
                }
            }
        };
    }

    private static InflaterInputStream inflate(InputStream in, Inflater inf) {
        return new InflaterInputStream(in, inf, 8192);
    }

    static BufferedInputStream buffer(InputStream in) {
        return new BufferedInputStream(in, 8192);
    }

    static int readSome(InputStream in, byte[] hdr, int off, int cnt) throws IOException {
        int avail = 0;
        while (cnt > 0) {
            int n = in.read(hdr, off, cnt);
            if (n < 0) break;
            avail += n;
            off += n;
            cnt -= n;
        }
        return avail;
    }

    private static final class LargeObject
    extends ObjectLoader {
        private final int type;
        private final long size;
        private final File path;
        private final ObjectId id;
        private final FileObjectDatabase source;

        LargeObject(int type2, long size2, File path, AnyObjectId id2, FileObjectDatabase db) {
            this.type = type2;
            this.size = size2;
            this.path = path;
            this.id = id2.copy();
            this.source = db;
        }

        @Override
        public int getType() {
            return this.type;
        }

        @Override
        public long getSize() {
            return this.size;
        }

        @Override
        public boolean isLarge() {
            return true;
        }

        @Override
        public byte[] getCachedBytes() throws LargeObjectException {
            throw new LargeObjectException(this.id);
        }

        @Override
        public ObjectStream openStream() throws MissingObjectException, IOException {
            BufferedInputStream in;
            try {
                in = UnpackedObject.buffer(new FileInputStream(this.path));
            }
            catch (FileNotFoundException gone) {
                if (this.path.exists()) {
                    throw gone;
                }
                return this.source.open(this.id, this.type).openStream();
            }
            boolean ok = false;
            try {
                byte[] hdr = new byte[64];
                ((InputStream)in).mark(20);
                IO.readFully(in, hdr, 0, 2);
                if (UnpackedObject.isStandardFormat(hdr)) {
                    ((InputStream)in).reset();
                    in = UnpackedObject.buffer(UnpackedObject.inflate(in, this.size, this.id));
                    while (((InputStream)in).read() > 0) {
                    }
                } else {
                    UnpackedObject.readSome(in, hdr, 2, 18);
                    int c = hdr[0] & 0xFF;
                    int p = 1;
                    while ((c & 0x80) != 0) {
                        c = hdr[p++] & 0xFF;
                    }
                    ((InputStream)in).reset();
                    IO.skipFully(in, p);
                    in = UnpackedObject.buffer(UnpackedObject.inflate(in, this.size, this.id));
                }
                ok = true;
                ObjectStream.Filter filter2 = new ObjectStream.Filter(this.type, this.size, in);
                return filter2;
            }
            finally {
                if (!ok) {
                    ((InputStream)in).close();
                }
            }
        }
    }
}

