/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.pack;

import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.jgit.internal.storage.pack.DeltaCache;
import org.eclipse.jgit.internal.storage.pack.ObjectToPack;
import org.eclipse.jgit.storage.pack.PackConfig;

class ThreadSafeDeltaCache
extends DeltaCache {
    private final ReentrantLock lock = new ReentrantLock();

    ThreadSafeDeltaCache(PackConfig pc) {
        super(pc);
    }

    @Override
    boolean canCache(int length2, ObjectToPack src, ObjectToPack res) {
        this.lock.lock();
        try {
            boolean bl = super.canCache(length2, src, res);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    void credit(int reservedSize) {
        this.lock.lock();
        try {
            super.credit(reservedSize);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    DeltaCache.Ref cache(byte[] data2, int actLen, int reservedSize) {
        data2 = this.resize(data2, actLen);
        this.lock.lock();
        try {
            DeltaCache.Ref ref = super.cache(data2, actLen, reservedSize);
            return ref;
        }
        finally {
            this.lock.unlock();
        }
    }
}

