/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.reftable;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.util.NB;
import org.eclipse.jgit.util.io.CountingOutputStream;

class ReftableOutputStream
extends OutputStream {
    private final byte[] tmp = new byte[10];
    private final CountingOutputStream out;
    private final boolean alignBlocks;
    private Deflater deflater;
    private DeflaterOutputStream compressor;
    private int blockType;
    private int blockSize;
    private int blockStart;
    private byte[] blockBuf;
    private int cur;
    private long paddingUsed;

    ReftableOutputStream(OutputStream os, int bs, boolean align2) {
        this.blockSize = bs;
        this.blockBuf = new byte[bs];
        this.alignBlocks = align2;
        this.out = new CountingOutputStream(os);
    }

    void setBlockSize(int bs) {
        this.blockSize = bs;
    }

    @Override
    public void write(int b) {
        this.ensureBytesAvailableInBlockBuf(1);
        this.blockBuf[this.cur++] = (byte)b;
    }

    @Override
    public void write(byte[] b, int off, int cnt) {
        this.ensureBytesAvailableInBlockBuf(cnt);
        System.arraycopy(b, off, this.blockBuf, this.cur, cnt);
        this.cur += cnt;
    }

    int bytesWrittenInBlock() {
        return this.cur;
    }

    int bytesAvailableInBlock() {
        return this.blockSize - this.cur;
    }

    long paddingUsed() {
        return this.paddingUsed;
    }

    long size() {
        return this.out.getCount();
    }

    static int computeVarintSize(long val) {
        int n = 1;
        while ((val >>>= 7) != 0L) {
            --val;
            ++n;
        }
        return n;
    }

    void writeVarint(long val) {
        int n = this.tmp.length;
        this.tmp[--n] = (byte)(val & 0x7FL);
        while ((val >>>= 7) != 0L) {
            this.tmp[--n] = (byte)(0x80L | --val & 0x7FL);
        }
        this.write(this.tmp, n, this.tmp.length - n);
    }

    void writeInt16(int val) {
        this.ensureBytesAvailableInBlockBuf(2);
        NB.encodeInt16(this.blockBuf, this.cur, val);
        this.cur += 2;
    }

    void writeInt24(int val) {
        this.ensureBytesAvailableInBlockBuf(3);
        NB.encodeInt24(this.blockBuf, this.cur, val);
        this.cur += 3;
    }

    void writeId(ObjectId id2) {
        this.ensureBytesAvailableInBlockBuf(20);
        id2.copyRawTo(this.blockBuf, this.cur);
        this.cur += 20;
    }

    void writeVarintString(String s2) {
        this.writeVarintString(s2.getBytes(StandardCharsets.UTF_8));
    }

    void writeVarintString(byte[] msg) {
        this.writeVarint(msg.length);
        this.write(msg, 0, msg.length);
    }

    private void ensureBytesAvailableInBlockBuf(int cnt) {
        if (this.cur + cnt > this.blockBuf.length) {
            int n = Math.max(this.cur + cnt, this.blockBuf.length * 2);
            this.blockBuf = Arrays.copyOf(this.blockBuf, n);
        }
    }

    void flushFileHeader() throws IOException {
        if (this.cur == 24 && this.out.getCount() == 0L) {
            this.out.write(this.blockBuf, 0, this.cur);
            this.cur = 0;
        }
    }

    void beginBlock(byte type2) {
        this.blockType = type2;
        this.blockStart = this.cur;
        this.cur += 4;
    }

    void flushBlock() throws IOException {
        if (this.cur > this.blockSize && this.blockType != 105) {
            throw new IOException(JGitText.get().overflowedReftableBlock);
        }
        NB.encodeInt32(this.blockBuf, this.blockStart, this.blockType << 24 | this.cur);
        if (this.blockType == 103) {
            this.out.write(this.blockBuf, 0, 4);
            if (this.deflater != null) {
                this.deflater.reset();
            } else {
                this.deflater = new Deflater(9);
                this.compressor = new DeflaterOutputStream((OutputStream)this.out, this.deflater);
            }
            this.compressor.write(this.blockBuf, 4, this.cur - 4);
            this.compressor.finish();
        } else {
            this.out.write(this.blockBuf, 0, this.cur);
        }
        this.cur = 0;
        this.blockType = 0;
        this.blockStart = 0;
    }

    void padBetweenBlocksToNextBlock() throws IOException {
        long m3;
        if (this.alignBlocks && (m3 = this.size() % (long)this.blockSize) > 0L) {
            int pad = this.blockSize - (int)m3;
            this.ensureBytesAvailableInBlockBuf(pad);
            Arrays.fill(this.blockBuf, 0, pad, (byte)0);
            this.out.write(this.blockBuf, 0, pad);
            this.paddingUsed += (long)pad;
        }
    }

    int estimatePadBetweenBlocks(int currentBlockSize) {
        if (this.alignBlocks) {
            long m3 = (this.size() + (long)currentBlockSize) % (long)this.blockSize;
            return m3 > 0L ? this.blockSize - (int)m3 : 0;
        }
        return 0;
    }

    void finishFile() throws IOException {
        this.out.write(this.blockBuf, 0, this.cur);
        this.cur = 0;
        if (this.deflater != null) {
            this.deflater.end();
        }
    }
}

