/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.IOException;
import org.eclipse.jgit.lib.BranchConfig;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.RevWalkUtils;
import org.eclipse.jgit.revwalk.filter.RevFilter;

public class BranchTrackingStatus {
    private final String remoteTrackingBranch;
    private final int aheadCount;
    private final int behindCount;

    public static BranchTrackingStatus of(Repository repository, String branchName) throws IOException {
        String shortBranchName = Repository.shortenRefName(branchName);
        String fullBranchName = "refs/heads/" + shortBranchName;
        BranchConfig branchConfig = new BranchConfig(repository.getConfig(), shortBranchName);
        String trackingBranch = branchConfig.getTrackingBranch();
        if (trackingBranch == null) {
            return null;
        }
        Ref tracking = repository.exactRef(trackingBranch);
        if (tracking == null) {
            return null;
        }
        Ref local2 = repository.exactRef(fullBranchName);
        if (local2 == null) {
            return null;
        }
        Throwable throwable = null;
        Object var9_10 = null;
        try (RevWalk walk = new RevWalk(repository);){
            RevCommit localCommit = walk.parseCommit(local2.getObjectId());
            RevCommit trackingCommit = walk.parseCommit(tracking.getObjectId());
            walk.setRevFilter(RevFilter.MERGE_BASE);
            walk.markStart(localCommit);
            walk.markStart(trackingCommit);
            RevCommit mergeBase = walk.next();
            walk.reset();
            walk.setRevFilter(RevFilter.ALL);
            int aheadCount = RevWalkUtils.count(walk, localCommit, mergeBase);
            int behindCount = RevWalkUtils.count(walk, trackingCommit, mergeBase);
            return new BranchTrackingStatus(trackingBranch, aheadCount, behindCount);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private BranchTrackingStatus(String remoteTrackingBranch, int aheadCount, int behindCount) {
        this.remoteTrackingBranch = remoteTrackingBranch;
        this.aheadCount = aheadCount;
        this.behindCount = behindCount;
    }

    public String getRemoteTrackingBranch() {
        return this.remoteTrackingBranch;
    }

    public int getAheadCount() {
        return this.aheadCount;
    }

    public int getBehindCount() {
        return this.behindCount;
    }
}

