/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk;

import java.io.IOException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.revwalk.BlockRevQueue;
import org.eclipse.jgit.revwalk.FIFORevQueue;
import org.eclipse.jgit.revwalk.Generator;
import org.eclipse.jgit.revwalk.RevCommit;

class TopoSortGenerator
extends Generator {
    private static final int TOPO_DELAY = 32;
    private final FIFORevQueue pending;
    private final int outputType;

    TopoSortGenerator(Generator s2) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        super(s2.firstParent);
        RevCommit c;
        this.pending = new FIFORevQueue(this.firstParent);
        this.outputType = s2.outputType() | 8;
        s2.shareFreeList(this.pending);
        while ((c = s2.next()) != null) {
            RevCommit[] revCommitArray = c.parents;
            int n = c.parents.length;
            int n2 = 0;
            while (n2 < n) {
                RevCommit p = revCommitArray[n2];
                ++p.inDegree;
                if (this.firstParent) break;
                ++n2;
            }
            this.pending.add(c);
        }
    }

    @Override
    int outputType() {
        return this.outputType;
    }

    @Override
    void shareFreeList(BlockRevQueue q) {
        q.shareFreeList(this.pending);
    }

    @Override
    RevCommit next() throws MissingObjectException, IncorrectObjectTypeException, IOException {
        RevCommit c;
        while (true) {
            if ((c = this.pending.next()) == null) {
                return null;
            }
            if (c.inDegree <= 0) break;
            c.flags |= 0x20;
        }
        RevCommit[] revCommitArray = c.parents;
        int n = c.parents.length;
        int n2 = 0;
        while (n2 < n) {
            RevCommit p = revCommitArray[n2];
            if (--p.inDegree == 0 && (p.flags & 0x20) != 0) {
                p.flags &= 0xFFFFFFDF;
                this.pending.unpop(p);
            }
            if (this.firstParent) break;
            ++n2;
        }
        return c;
    }
}

