/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.xpp.impl.pullparser;

import java.io.IOException;
import java.io.Reader;
import java.util.Hashtable;
import org.gjt.xpp.XmlEndTag;
import org.gjt.xpp.XmlNode;
import org.gjt.xpp.XmlPullParser;
import org.gjt.xpp.XmlPullParserBufferControl;
import org.gjt.xpp.XmlPullParserEventPosition;
import org.gjt.xpp.XmlPullParserException;
import org.gjt.xpp.XmlStartTag;
import org.gjt.xpp.impl.pullparser.ElementContent;
import org.gjt.xpp.impl.tag.Attribute;
import org.gjt.xpp.impl.tag.PullParserRuntimeException;
import org.gjt.xpp.impl.tokenizer.Tokenizer;

public class PullParser
implements XmlPullParser,
XmlPullParserBufferControl,
XmlPullParserEventPosition {
    private static final boolean TRACE_SIZING = false;
    protected static final boolean USE_QNAMEBUF = false;
    protected static final boolean CHECK_ATTRIB_UNIQ = true;
    protected boolean emptyElement;
    protected boolean seenRootElement;
    protected String elContent;
    protected Tokenizer tokenizer = new Tokenizer();
    protected int eventStart;
    protected int eventEnd;
    protected byte state;
    protected byte token;
    protected boolean supportNs;
    protected boolean reportNsAttribs;
    protected Hashtable prefix2Ns = new Hashtable();
    protected int attrPosEnd;
    protected int attrPosSize;
    protected Attribute[] attrPos;
    protected int elStackDepth;
    protected int elStackSize;
    protected ElementContent[] elStack;

    public void setInput(Reader reader) {
        this.resetState();
        this.eventStart = 0;
        this.eventEnd = 0;
        this.tokenizer.setInput(reader);
    }

    public void setInput(char[] buf) {
        this.resetState();
        this.eventStart = 0;
        this.eventEnd = 0;
        this.tokenizer.setInput(buf, 0, buf.length);
    }

    public void setInput(char[] buf, int off, int len) throws XmlPullParserException {
        this.resetState();
        this.eventEnd = this.eventStart = off;
        this.tokenizer.setInput(buf, off, len);
    }

    public void reset() {
        this.tokenizer.reset();
        this.resetState();
    }

    public boolean isAllowedMixedContent() {
        return this.tokenizer.isAllowedMixedContent();
    }

    public void setAllowedMixedContent(boolean enable) {
        this.tokenizer.setAllowedMixedContent(enable);
    }

    public boolean isNamespaceAware() {
        return this.supportNs;
    }

    public void setNamespaceAware(boolean awareness) throws XmlPullParserException {
        if (this.elStackDepth > 0 || this.seenRootElement) {
            throw new XmlPullParserException("namespace support can only be set when not parsing");
        }
        this.supportNs = awareness;
    }

    public boolean isNamespaceAttributesReporting() {
        return this.reportNsAttribs;
    }

    public void setNamespaceAttributesReporting(boolean enable) {
        this.reportNsAttribs = enable;
    }

    public String getNamespaceUri() {
        if (this.state != 2 && this.state != 3) {
            throw new PullParserRuntimeException("no end or start tag available to read" + this.getPosDesc());
        }
        ElementContent el = this.elStack[this.getDepth() - 1];
        return el.uri;
    }

    public String getLocalName() {
        if (this.state != 2 && this.state != 3) {
            throw new PullParserRuntimeException("no end or start tag available to read" + this.getPosDesc());
        }
        ElementContent el = this.elStack[this.getDepth() - 1];
        return el.localName;
    }

    public String getPrefix() {
        if (this.state != 2 && this.state != 3) {
            throw new PullParserRuntimeException("no end or start tag available to read" + this.getPosDesc());
        }
        ElementContent el = this.elStack[this.getDepth() - 1];
        return el.prefix;
    }

    public String getRawName() {
        if (this.state != 2 && this.state != 3) {
            throw new PullParserRuntimeException("no end or start tag available to read" + this.getPosDesc());
        }
        ElementContent el = this.elStack[this.getDepth() - 1];
        return el.qName;
    }

    public String getQNameLocal(String qName) {
        int i = qName.lastIndexOf(58);
        return qName.substring(i + 1);
    }

    public String getQNameUri(String qName) throws XmlPullParserException {
        if (this.elStackDepth == 0) {
            throw new XmlPullParserException("parsing must be started to get uri from qname");
        }
        int i = qName.lastIndexOf(58);
        if (i > 0) {
            String prefix2 = qName.substring(0, i);
            return (String)this.prefix2Ns.get(prefix2);
        }
        return this.elStack[this.elStackDepth - 1].defaultNs;
    }

    public int getDepth() {
        return this.state != 3 ? this.elStackDepth : this.elStackDepth + 1;
    }

    public int getNamespacesLength(int depth) {
        if (depth <= 0) {
            throw new IllegalArgumentException("element depth must be bigger than zero");
        }
        int maxDepth = this.getDepth();
        if (depth > maxDepth) {
            throw new IllegalArgumentException("the depth " + depth + " that was passed for length of namespaces " + " can not be bigger than current depth of " + maxDepth);
        }
        ElementContent el = this.elStack[depth - 1];
        return el.prefixesEnd;
    }

    public void readNamespacesPrefixes(int depth, String[] prefixes, int off, int len) throws XmlPullParserException {
        if (depth <= 0) {
            throw new XmlPullParserException("element depth must be bigger than zero");
        }
        int maxDepth = this.getDepth();
        if (depth > maxDepth) {
            throw new XmlPullParserException("passed prefixes array of length " + depth + " can not be bigger than current depth of " + maxDepth);
        }
        ElementContent el = this.elStack[depth - 1];
        if (len > el.prefixesEnd) {
            throw new XmlPullParserException("number of prefixes to copy " + len + " is bigger than available " + el.prefixesEnd);
        }
        System.arraycopy(el.prefixes, 0, prefixes, off, len);
    }

    public void readNamespacesUris(int depth, String[] uris, int off, int len) throws XmlPullParserException {
        if (depth <= 0) {
            throw new XmlPullParserException("element depth must be bigger than zero");
        }
        int maxDepth = this.getDepth();
        if (depth > maxDepth) {
            throw new XmlPullParserException("passed namespace URIs array of length " + depth + " can not be bigger than current depth of " + maxDepth);
        }
        ElementContent el = this.elStack[depth - 1];
        if (len > el.prefixesEnd) {
            throw new XmlPullParserException("number of namespace URIs to copy " + len + " is bigger than available " + el.prefixesEnd);
        }
        System.arraycopy(el.namespaceURIs, 0, uris, off, len);
    }

    public String getPosDesc() {
        String desc;
        switch (this.state) {
            case 2: {
                desc = "START_TAG";
                break;
            }
            case 4: {
                desc = "CONTENT";
                break;
            }
            case 3: {
                desc = "END_TAG";
                break;
            }
            case 1: {
                desc = "END_DOCUMENT";
                break;
            }
            default: {
                desc = "UNKNONW_EVENT (" + this.state + ")";
            }
        }
        return this.tokenizer.getPosDesc() + " (parser state " + desc + ")";
    }

    public int getLineNumber() {
        return this.tokenizer.getLineNumber();
    }

    public int getColumnNumber() {
        return this.tokenizer.getColumnNumber();
    }

    public byte next() throws XmlPullParserException, IOException {
        this.eventEnd = this.eventStart = this.tokenizer.pos;
        if (this.emptyElement) {
            --this.elStackDepth;
            if (this.elStackDepth == 0) {
                this.seenRootElement = true;
            }
            this.emptyElement = false;
            this.state = 3;
            return 3;
        }
        Attribute ap3 = null;
        ElementContent el = null;
        block11: do {
            this.token = this.tokenizer.next();
            switch (this.token) {
                case 2: {
                    this.state = 1;
                    if (this.elStackDepth > 0) {
                        throw new XmlPullParserException("expected element end tag '" + this.elStack[this.elStackDepth - 1].qName + "' not end of document" + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
                    }
                    this.eventEnd = this.tokenizer.pos;
                    return this.state;
                }
                case 10: {
                    this.state = (byte)4;
                    if (this.elStackDepth > 0) {
                        this.elContent = null;
                        this.eventEnd = this.tokenizer.posEnd;
                        return this.state;
                    }
                    if (this.tokenizer.seenContent) {
                        throw new XmlPullParserException("only whitespace content allowed outside root element" + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
                    }
                    this.eventEnd = this.eventStart = this.tokenizer.pos;
                    break;
                }
                case 110: {
                    int i;
                    this.eventStart = this.tokenizer.posStart - 2;
                    this.state = (byte)3;
                    if (this.seenRootElement) {
                        throw new XmlPullParserException("no markup allowed outside root element" + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
                    }
                    --this.elStackDepth;
                    if (this.elStackDepth == 0) {
                        this.seenRootElement = true;
                    }
                    if (this.elStackDepth < 0) {
                        throw new XmlPullParserException("end tag without start stag" + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
                    }
                    el = this.elStack[this.elStackDepth];
                    String s2 = new String(this.tokenizer.buf, this.tokenizer.posStart, this.tokenizer.posEnd - this.tokenizer.posStart);
                    if (!s2.equals(this.elStack[this.elStackDepth].qName)) {
                        throw new XmlPullParserException("end tag name should be " + this.elStack[this.elStackDepth].qName + " not " + s2 + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
                    }
                    if (this.supportNs && el.prefixes != null) {
                        i = el.prefixesEnd - 1;
                        while (i >= 0) {
                            if (el.prefixPrevNs[i] != null) {
                                this.prefix2Ns.put(el.prefixes[i], el.prefixPrevNs[i]);
                            } else {
                                this.prefix2Ns.remove(el.prefixes[i]);
                            }
                            --i;
                        }
                    }
                    this.eventEnd = this.tokenizer.pos;
                    return this.state;
                }
                case 120: {
                    this.eventStart = this.tokenizer.posStart - 1;
                    this.state = (byte)2;
                    if (this.seenRootElement) {
                        throw new XmlPullParserException("no markup allowed outside root element" + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
                    }
                    this.emptyElement = false;
                    if (this.elStackDepth >= this.elStackSize) {
                        this.ensureCapacity(this.elStackDepth);
                    }
                    el = this.elStack[this.elStackDepth];
                    el.prefixesEnd = 0;
                    this.attrPosEnd = 0;
                    el.defaultNs = null;
                    el.qName = new String(this.tokenizer.buf, this.tokenizer.posStart, this.tokenizer.posEnd - this.tokenizer.posStart);
                    if (this.supportNs && this.tokenizer.posNsColon >= 0) {
                        if (this.tokenizer.nsColonCount > 1) {
                            throw new XmlPullParserException("only one colon allowed in prefixed element name" + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
                        }
                        el.prefix = el.qName.substring(0, this.tokenizer.posNsColon - this.tokenizer.posStart);
                        el.localName = el.qName.substring(this.tokenizer.posNsColon - this.tokenizer.posStart + 1);
                    } else {
                        el.prefix = null;
                        el.localName = el.qName;
                    }
                    el.uri = null;
                    ++this.elStackDepth;
                    break;
                }
                case 122: {
                    if (this.attrPosEnd >= this.attrPosSize) {
                        this.ensureAttribs(this.attrPosEnd + 1);
                    }
                    ap3 = this.attrPos[this.attrPosEnd];
                    ap3.qName = new String(this.tokenizer.buf, this.tokenizer.posStart, this.tokenizer.posEnd - this.tokenizer.posStart);
                    ap3.uri = null;
                    if (this.supportNs && this.tokenizer.posNsColon >= 0) {
                        if (this.tokenizer.nsColonCount > 1) {
                            throw new XmlPullParserException("only one colon allowed in prefixed attribute name" + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
                        }
                        ap3.prefix = ap3.qName.substring(0, this.tokenizer.posNsColon - this.tokenizer.posStart);
                        if (this.tokenizer.posEnd == this.tokenizer.posNsColon) {
                            throw new XmlPullParserException("xmlns: is not allowed to declare default namespace, use xmlns instead" + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
                        }
                        ap3.localName = ap3.qName.substring(this.tokenizer.posNsColon - this.tokenizer.posStart + 1);
                        break;
                    }
                    ap3.prefix = null;
                    ap3.localName = ap3.qName;
                    break;
                }
                case 127: {
                    int i;
                    ap3.value = this.tokenizer.parsedContent ? new String(this.tokenizer.pc, this.tokenizer.pcStart, this.tokenizer.pcEnd - this.tokenizer.pcStart) : new String(this.tokenizer.buf, this.tokenizer.posStart, this.tokenizer.posEnd - this.tokenizer.posStart);
                    if (this.supportNs) {
                        if ("xmlns".equals(ap3.prefix)) {
                            if (el.prefixesEnd >= el.prefixesSize) {
                                el.ensureCapacity(el.prefixesEnd);
                            }
                            if (ap3.value.length() == 0) {
                                throw new XmlPullParserException("the declared xmlns namespace for '" + ap3.localName + "' name " + " may not be empty" + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
                            }
                            el.prefixes[el.prefixesEnd] = ap3.localName;
                            el.namespaceURIs[el.prefixesEnd] = ap3.value;
                            el.prefixPrevNs[el.prefixesEnd] = (String)this.prefix2Ns.get(ap3.localName);
                            i = 0;
                            while (i < el.prefixesEnd) {
                                if (ap3.localName.equals(el.prefixes[i])) {
                                    throw new XmlPullParserException("duplicate xmlns declaration name '" + ap3.localName + "'" + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
                                }
                                ++i;
                            }
                            ++el.prefixesEnd;
                            this.prefix2Ns.put(ap3.localName, ap3.value);
                            if (!this.reportNsAttribs) continue block11;
                            ap3.xmlnsAttrib = true;
                            ++this.attrPosEnd;
                            break;
                        }
                        if ("xmlns".equals(ap3.qName)) {
                            if (el.defaultNs != null) {
                                throw new XmlPullParserException("default namespace was alredy declared by xmlns attribute" + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
                            }
                            el.defaultNs = ap3.value;
                            if (!this.reportNsAttribs) continue block11;
                            ap3.xmlnsAttrib = true;
                            ++this.attrPosEnd;
                            break;
                        }
                        ap3.xmlnsAttrib = false;
                        ++this.attrPosEnd;
                        break;
                    }
                    i = 0;
                    while (i < this.attrPosEnd) {
                        if (ap3.qName.equals(this.attrPos[i].qName)) {
                            throw new XmlPullParserException("duplicate attribute name '" + ap3.qName + "'" + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
                        }
                        ++i;
                    }
                    ap3.xmlnsAttrib = false;
                    ++this.attrPosEnd;
                    break;
                }
                case 111: {
                    this.emptyElement = true;
                    break;
                }
                case 112: {
                    if (this.supportNs) {
                        if (el.defaultNs == null) {
                            el.defaultNs = this.elStackDepth > 1 ? this.elStack[this.elStackDepth - 2].defaultNs : "";
                        }
                        if (el.prefix != null) {
                            el.uri = (String)this.prefix2Ns.get(el.prefix);
                            if (el.uri == null) {
                                throw new XmlPullParserException("no namespace for prefix '" + el.prefix + "'" + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
                            }
                        } else {
                            el.uri = el.defaultNs;
                            el.localName = el.qName;
                        }
                        int j = 0;
                        while (j < this.attrPosEnd) {
                            ap3 = this.attrPos[j];
                            if (!ap3.xmlnsAttrib && ap3.uri == null && ap3.prefix != null) {
                                ap3.uri = (String)this.prefix2Ns.get(ap3.prefix);
                                if (ap3.uri == null) {
                                    throw new XmlPullParserException("no namespace for prefix " + ap3.prefix + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
                                }
                            }
                            ++j;
                        }
                        int j2 = 1;
                        while (j2 < this.attrPosEnd) {
                            ap3 = this.attrPos[j2];
                            int i = 0;
                            while (i < j2) {
                                if (!ap3.xmlnsAttrib && !this.attrPos[i].xmlnsAttrib && ap3.localName.equals(this.attrPos[i].localName) && (ap3.uri != null && ap3.uri.equals(this.attrPos[i].uri) || ap3.uri == null && this.attrPos[i].uri == null)) {
                                    throw new XmlPullParserException("duplicate attribute name '" + ap3.qName + "'" + (ap3.uri != null ? " (with namespace '" + ap3.uri + "')" : "") + " and " + (ap3.uri != null ? " (with namespace '" + ap3.uri + "')" : "") + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
                                }
                                ++i;
                            }
                            ++j2;
                        }
                    } else {
                        el.prefix = null;
                        el.localName = el.qName;
                        el.uri = "";
                    }
                    this.eventEnd = this.tokenizer.pos;
                    return this.state;
                }
                case 50: {
                    throw new XmlPullParserException("<![DOCTYPE declarations not supported" + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
                }
                default: {
                    throw new XmlPullParserException("unknown token " + this.token + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
                }
            }
        } while (this.token != 112);
        throw new XmlPullParserException("invalid state of tokenizer token=" + this.token);
    }

    public byte getEventType() {
        return this.state;
    }

    public boolean isWhitespaceContent() throws XmlPullParserException {
        if (this.state != 4) {
            throw new XmlPullParserException("no content available to read");
        }
        return !this.tokenizer.seenContent;
    }

    public int getContentLength() throws XmlPullParserException {
        if (this.state != 4) {
            throw new XmlPullParserException("no content available");
        }
        return this.tokenizer.parsedContent ? this.tokenizer.pcEnd - this.tokenizer.pcStart : this.tokenizer.posEnd - this.tokenizer.posStart;
    }

    public String readContent() throws XmlPullParserException {
        if (this.state != 4) {
            throw new XmlPullParserException("no content available to read");
        }
        if (this.elContent == null) {
            this.elContent = this.tokenizer.parsedContent ? new String(this.tokenizer.pc, this.tokenizer.pcStart, this.tokenizer.pcEnd - this.tokenizer.pcStart) : new String(this.tokenizer.buf, this.tokenizer.posStart, this.tokenizer.posEnd - this.tokenizer.posStart);
        }
        return this.elContent;
    }

    public void readEndTag(XmlEndTag etag) throws XmlPullParserException {
        if (this.state != 3) {
            throw new XmlPullParserException("no end tag available to read" + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
        }
        ElementContent el = this.elStack[this.elStackDepth];
        etag.resetEndTag();
        etag.modifyTag(el.uri, el.localName, el.qName);
    }

    public void readStartTag(XmlStartTag stag) throws XmlPullParserException {
        if (this.state != 2) {
            throw new XmlPullParserException("no start tag available to read" + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
        }
        stag.resetStartTag();
        ElementContent el = this.elStack[this.elStackDepth - 1];
        stag.modifyTag(el.uri, el.localName, el.qName);
        stag.ensureAttributesCapacity(this.attrPosEnd);
        int i = 0;
        while (i < this.attrPosEnd) {
            Attribute ap3 = this.attrPos[i];
            stag.addAttribute(ap3.uri, ap3.localName, ap3.qName, ap3.value, ap3.xmlnsAttrib);
            ++i;
        }
    }

    public void readNodeWithoutChildren(XmlNode node) throws XmlPullParserException {
        this.readStartTag(node);
        if (this.supportNs) {
            ElementContent el = this.elStack[this.elStackDepth - 1];
            node.setDefaultNamespaceUri(el.defaultNs);
            node.addDeclaredNamespaces(el.prefixes, 0, el.prefixesEnd, el.namespaceURIs);
        }
    }

    public byte readNode(XmlNode node) throws XmlPullParserException, IOException {
        this.readNodeWithoutChildren(node);
        ElementContent el = this.elStack[this.elStackDepth - 1];
        int level = this.elStackDepth;
        while (true) {
            byte state = this.next();
            switch (state) {
                case 2: {
                    XmlNode child = node.newNode();
                    this.readNodeWithoutChildren(child);
                    node.appendChild(child);
                    el = this.elStack[this.elStackDepth - 1];
                    el.node = node;
                    node = child;
                    break;
                }
                case 4: {
                    node.appendChild(this.readContent());
                    break;
                }
                case 3: {
                    if (this.elStackDepth >= level) {
                        node = this.elStack[this.elStackDepth].node;
                        break;
                    }
                    return state;
                }
            }
        }
    }

    public byte skipNode() throws XmlPullParserException, IOException {
        if (this.state != 2) {
            throw new XmlPullParserException("start tag must be read before skiping subtree" + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
        }
        int level = 1;
        byte type2 = 3;
        while (level > 0) {
            type2 = this.next();
            switch (type2) {
                case 2: {
                    ++level;
                    break;
                }
                case 3: {
                    --level;
                }
            }
        }
        return type2;
    }

    public int getHardLimit() {
        return this.tokenizer.getHardLimit();
    }

    public void setHardLimit(int value2) throws XmlPullParserException {
        this.tokenizer.setHardLimit(value2);
    }

    public int getSoftLimit() {
        return this.tokenizer.getSoftLimit();
    }

    public void setSoftLimit(int value2) throws XmlPullParserException {
        this.tokenizer.setSoftLimit(value2);
    }

    public int getBufferShrinkOffset() {
        return this.tokenizer.getBufferShrinkOffset();
    }

    public void setBufferShrinkable(boolean shrinkable) throws XmlPullParserException {
        this.tokenizer.setBufferShrinkable(shrinkable);
    }

    public boolean isBufferShrinkable() {
        return this.tokenizer.isBufferShrinkable();
    }

    public int getEventStart() {
        return this.eventStart;
    }

    public int getEventEnd() {
        return this.eventEnd;
    }

    public char[] getEventBuffer() {
        return this.tokenizer.buf;
    }

    protected void ensureCapacity(int size2) {
        int newSize = 2 * size2;
        if (newSize == 0) {
            newSize = 8;
        }
        if (this.elStackSize < newSize) {
            ElementContent[] newStack = new ElementContent[newSize];
            if (this.elStack != null) {
                System.arraycopy(this.elStack, 0, newStack, 0, this.elStackSize);
            }
            int i = this.elStackSize;
            while (i < newSize) {
                newStack[i] = new ElementContent();
                ++i;
            }
            this.elStack = newStack;
            this.elStackSize = newSize;
        }
    }

    protected void ensureAttribs(int size2) {
        int newSize = 2 * size2;
        if (newSize == 0) {
            newSize = 8;
        }
        if (this.attrPosEnd < newSize) {
            Attribute[] newAttrPos = new Attribute[newSize];
            if (this.attrPos != null) {
                System.arraycopy(this.attrPos, 0, newAttrPos, 0, this.attrPosSize);
            }
            int i = this.attrPosSize;
            while (i < newSize) {
                newAttrPos[i] = new Attribute();
                ++i;
            }
            this.attrPos = newAttrPos;
            this.attrPosSize = newSize;
        }
    }

    protected void resetState() {
        this.tokenizer.paramNotifyDoctype = true;
        this.state = (byte)-1;
        this.token = (byte)-1;
        this.eventStart = -1;
        this.elStackDepth = 0;
        this.prefix2Ns.clear();
        this.prefix2Ns.put("xml", "http://www.w3.org/XML/1998/namespace");
        this.emptyElement = false;
        this.seenRootElement = false;
    }
}

