/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.xpp.impl.tokenizer;

import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import org.gjt.xpp.impl.tag.PullParserRuntimeException;
import org.gjt.xpp.impl.tokenizer.TokenizerBufferOverflowException;
import org.gjt.xpp.impl.tokenizer.TokenizerException;

public class Tokenizer {
    public static final byte END_DOCUMENT = 2;
    public static final byte CONTENT = 10;
    public static final byte CHARACTERS = 20;
    public static final byte CDSECT = 30;
    public static final byte COMMENT = 40;
    public static final byte DOCTYPE = 50;
    public static final byte PI = 60;
    public static final byte ENTITY_REF = 70;
    public static final byte CHAR_REF = 75;
    public static final byte ETAG_NAME = 110;
    public static final byte EMPTY_ELEMENT = 111;
    public static final byte STAG_END = 112;
    public static final byte STAG_NAME = 120;
    public static final byte ATTR_NAME = 122;
    public static final byte ATTR_CHARACTERS = 124;
    public static final byte ATTR_CONTENT = 127;
    public boolean paramNotifyCharacters;
    public boolean paramNotifyComment;
    public boolean paramNotifyCDSect;
    public boolean paramNotifyDoctype;
    public boolean paramNotifyPI;
    public boolean paramNotifyCharRef;
    public boolean paramNotifyEntityRef;
    public boolean paramNotifyAttValue;
    public char[] buf = new char[1024];
    public int pos;
    public int posStart;
    public int posEnd;
    public int posNsColon;
    public int nsColonCount;
    public boolean seenContent;
    public boolean parsedContent;
    public char[] pc = new char[1024];
    public int pcStart;
    public int pcEnd;
    private static final boolean NORMALIZE_LINE_BREAKS = true;
    private static final boolean TRACING = false;
    private static final boolean TRACE_SIZING = false;
    private boolean paramPC = true;
    private boolean paramNoMixContent = false;
    private boolean mixInElement = false;
    private boolean backtracking = false;
    private static final int BUF_SIZE = 1024;
    private int readChunkSize = 1024;
    private int loadFactor = 99;
    private int posSafe = this.loadFactor * 1024 / 100;
    private int softLimit = -1;
    private int hardLimit = -1;
    private int shrinkOffset = 0;
    private boolean shrinkable = true;
    private boolean reading = true;
    private Reader reader;
    private int bufStart;
    private int bufEnd;
    private int bufSize = 1024;
    private int posCol;
    private int posRow;
    private char prevCh;
    private char prevPrevCh;
    private char attrMarker;
    private char charRefValue;
    private boolean charRefHex;
    private boolean reachedEnd;
    private boolean seenStartTag;
    private byte previousState;
    private byte state;
    private static final byte STATE_INIT = 1;
    private static final byte STATE_FINISH = 6;
    private static final byte STATE_FINISHED = 7;
    private static final byte STATE_CONTENT_INIT = 10;
    private static final byte STATE_CONTENT_CONTINUED = 11;
    private static final byte STATE_CONTENT = 12;
    private static final byte STATE_SEEN_LT = 13;
    private static final byte STATE_SEEN_LT_BANG = 14;
    private static final byte STATE_CDSECT = 30;
    private static final byte STATE_CDSECT_BRACKET = 31;
    private static final byte STATE_CDSECT_BRACKET_BRACKET = 32;
    private static final byte STATE_COMMENT = 40;
    private static final byte STATE_COMMENT_DASH = 41;
    private static final byte STATE_COMMENT_DASH_DASH = 42;
    private static final byte STATE_DOCTYPE = 50;
    private static final byte STATE_DOCTYPE_BRACKET = 51;
    private static final byte STATE_DOCTYPE_BRACKET_BRACKET = 52;
    private static final byte STATE_PI = 60;
    private static final byte STATE_PI_END = 61;
    private static final byte STATE_SEEN_AMP = 70;
    private static final byte STATE_ENTITY_REF = 71;
    private static final byte STATE_CHAR_REF = 75;
    private static final byte STATE_CHAR_REF_DIGITS = 76;
    private static final byte STATE_SCAN_ETAG_NAME = 110;
    private static final byte STATE_SCAN_STAG_NAME = 120;
    private static final byte STATE_SCAN_STAG_GT = 121;
    private static final byte STATE_SCAN_ATTR_NAME = 122;
    private static final byte STATE_SCAN_ATTR_EQ = 123;
    private static final byte STATE_SCAN_ATTR_VALUE = 124;
    private static final byte STATE_SCAN_ATTR_VALUE_CONTINUE = 125;
    private static final byte STATE_SCAN_ATTR_VALUE_END = 126;
    private static final byte STATE_ATTR_VALUE_CONTENT = 127;

    public void reset() {
        if (!this.reading) {
            if (this.softLimit != -1) {
                this.resize(this.softLimit);
            } else {
                this.resize(1024);
            }
        }
        this.resetState();
    }

    private void resetState() {
        this.reading = true;
        this.bufSize = this.buf.length;
        this.bufEnd = 0;
        this.bufStart = 0;
        this.pos = 0;
        this.posStart = 0;
        this.posEnd = 0;
        this.posNsColon = -1;
        this.state = 1;
        this.prevCh = '\u0000';
        this.posRow = 1;
        this.posCol = 1;
        this.reachedEnd = false;
        this.pcStart = 0;
        this.pcEnd = 0;
        if (this.pc.length > 2048) {
            this.pc = new char[1024];
        }
        this.previousState = (byte)-1;
        this.backtracking = false;
        this.seenContent = false;
        this.shrinkOffset = 0;
    }

    public void setInput(Reader r) {
        this.reset();
        this.reading = true;
        this.reader = r;
        this.bufEnd = 0;
        this.bufStart = 0;
    }

    public void setInput(char[] data2) {
        this.setInput(data2, 0, data2.length);
    }

    public void setInput(char[] data2, int off, int len) {
        this.resetState();
        this.reading = false;
        this.buf = data2;
        this.bufStart = this.pos = off;
        this.bufSize = this.bufEnd = off + len;
    }

    public void setNotifyAll(boolean enable) {
        this.paramNotifyCharacters = enable;
        this.paramNotifyComment = enable;
        this.paramNotifyCDSect = enable;
        this.paramNotifyDoctype = enable;
        this.paramNotifyPI = enable;
        this.paramNotifyEntityRef = enable;
        this.paramNotifyCharRef = enable;
        this.paramNotifyAttValue = enable;
    }

    public void setParseContent(boolean enable) {
        this.paramPC = enable;
    }

    public boolean isAllowedMixedContent() {
        return !this.paramNoMixContent;
    }

    public void setAllowedMixedContent(boolean enable) {
        this.paramNoMixContent = !enable;
    }

    public int getSoftLimit() {
        return this.softLimit;
    }

    public void setSoftLimit(int value2) throws TokenizerException {
        if (!this.reading) {
            throw new TokenizerException("hard limit can not be set for char array input");
        }
        if (value2 != -1 && this.hardLimit != -1 && 2 * value2 > this.hardLimit) {
            throw new TokenizerException("soft limit can no tbe bigger than half of hard limitcurrent hard limit " + this.hardLimit);
        }
        this.softLimit = value2;
        this.posSafe = this.softLimit != -1 ? this.softLimit : (this.hardLimit != -1 ? this.hardLimit / 2 : this.loadFactor * this.bufSize / 100);
    }

    public int getHardLimit() {
        return this.hardLimit;
    }

    public void setHardLimit(int value2) throws TokenizerException {
        if (!this.reading) {
            throw new TokenizerException("hard limit can not be set for char array input");
        }
        if (this.state != 1 && value2 < this.hardLimit) {
            throw new TokenizerException("hard limit on buffer size can not be shrunk during parsing");
        }
        if (this.softLimit == -1 && value2 != -1) {
            throw new TokenizerException("soft limit must be set to non -1 before setting hard limit" + this.getPosDesc(), this.posRow, this.posCol - 1);
        }
        if (value2 != -1 && 2 * this.softLimit >= value2) {
            throw new TokenizerException("hard limit must be at least twice the size of soft limitcurrent soft limit " + this.softLimit + " and hard limit " + value2 + this.getPosDesc(), this.posRow, this.posCol - 1);
        }
        this.hardLimit = value2;
        if (this.shrinkable && this.softLimit != -1 && this.softLimit < this.bufSize) {
            this.resize(this.softLimit);
        }
    }

    public int getBufferShrinkOffset() {
        return this.shrinkOffset;
    }

    public void setBufferShrinkable(boolean shrinkable) throws TokenizerException {
        this.shrinkable = shrinkable;
    }

    public boolean isBufferShrinkable() {
        return this.shrinkable;
    }

    private static int findFragment(int bufStart, char[] b, int start, int end) {
        if (start < bufStart) {
            start = bufStart;
            if (start > end) {
                start = end;
            }
            return start;
        }
        if (end - start > 55) {
            start = end - 10;
        }
        int i = start + 1;
        while (--i > bufStart) {
            char c;
            if (end - i > 55 || (c = b[i]) == '<' && start - i > 10) break;
        }
        return i;
    }

    public String getPosDesc() {
        int start;
        String fragment = null;
        if (this.posStart <= this.posEnd && (start = Tokenizer.findFragment(this.bufStart, this.buf, this.posStart, this.posEnd)) < this.posEnd) {
            fragment = new String(this.buf, start, this.posEnd - start);
            if (start > this.bufStart) {
                fragment = "..." + fragment;
            }
        }
        return " at line " + this.posRow + " and column " + (this.posCol - 1) + (fragment != null ? " seen " + Tokenizer.printable(fragment) + "..." : "");
    }

    public int getLineNumber() {
        return this.posRow;
    }

    public int getColumnNumber() {
        return this.posCol - 1;
    }

    private static boolean compareCharArr(char[] a, char[] b, int bStart, int bEnd) {
        if (bEnd - bStart != a.length) {
            return false;
        }
        int i = bStart;
        int j = 0;
        while (i < bEnd) {
            if (a[j] != b[i]) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    private static String printableChar(char ch) {
        if (ch == '\n') {
            return "\\n";
        }
        if (ch == '\r') {
            return "\\r";
        }
        if (ch == '\t') {
            return "\\t";
        }
        if (ch < ' ') {
            return "\\u" + Character.digit(ch, 16) + "";
        }
        return "" + ch;
    }

    private static String printable(char ch) {
        return "'" + Tokenizer.printableChar(ch) + "'";
    }

    private static String printable(String s2) {
        int iN = s2.indexOf(10);
        int iR = s2.indexOf(13);
        int iT = s2.indexOf(9);
        if (iN != -1 || iR != -1 || iT != -1) {
            StringBuffer buf = new StringBuffer("\"");
            int i = 0;
            while (i < s2.length()) {
                buf.append(Tokenizer.printableChar(s2.charAt(i)));
                ++i;
            }
            buf.append("\"");
            s2 = buf.toString();
        }
        return s2;
    }

    private char readName(char ch) throws IOException, TokenizerException {
        this.posNsColon = -1;
        this.nsColonCount = 0;
        if (!Character.isLowerCase(ch) && !Character.isUpperCase(ch) && ch != ':' && ch != '_') {
            throw new TokenizerException("expected name start not " + Tokenizer.printable(ch) + this.getPosDesc(), this.posRow, this.posCol - 1);
        }
        do {
            if ((ch = this.more()) != ':') continue;
            this.posNsColon = this.pos - 1;
            ++this.nsColonCount;
        } while (Character.isLowerCase(ch) || Character.isUpperCase(ch) || Character.isDigit(ch) || ch == '.' || ch == '-' || ch == '_' || ch == ':');
        return ch;
    }

    private boolean isS(char ch) {
        return ch == ' ' || ch == '\n' || ch == '\t' || ch == '\r';
    }

    private char skipS(char ch) throws IOException, TokenizerException {
        while (ch == ' ' || ch == '\n' || ch == '\t' || ch == '\r') {
            ch = this.more();
        }
        return ch;
    }

    /*
     * Unable to fully structure code
     */
    private char readS(char ch) throws IOException, TokenizerException {
        if (this.isS(ch)) ** GOTO lbl4
        throw new TokenizerException("expected white space not " + ch + this.getPosDesc(), this.posRow, this.posCol - 1);
lbl-1000:
        // 1 sources

        {
            ch = this.more();
lbl4:
            // 2 sources

            ** while (ch == ' ' || ch == '\n' || ch == '\t' || ch == '\r')
        }
lbl5:
        // 1 sources

        return ch;
    }

    private char more() throws IOException, TokenizerException {
        char ch;
        if (this.backtracking) {
            this.backtracking = false;
            ++this.pos;
            ++this.posCol;
            return this.prevCh;
        }
        if (!this.reading) {
            if (this.pos == this.bufEnd - 1) {
                this.reachedEnd = true;
            }
            if (this.pos >= this.bufEnd) {
                throw new EOFException("no more data available");
            }
        } else {
            if (this.hardLimit != -1 && this.pos >= this.hardLimit - 1) {
                throw new TokenizerBufferOverflowException("reached hard limit on buffer size" + this.getPosDesc(), this.posRow, this.posCol - 1);
            }
            if (this.pos >= this.bufEnd - 1) {
                int chunkie;
                if (this.hardLimit != -1 && this.bufSize > this.hardLimit) {
                    throw new TokenizerBufferOverflowException("buffer size should never exceed hard limit" + this.getPosDesc(), this.posRow, this.posCol - 1);
                }
                int spaceLeft = this.bufSize - this.bufEnd;
                if (spaceLeft <= this.readChunkSize) {
                    int newSize = 2 * this.bufSize;
                    if (this.hardLimit == -1) {
                        if (newSize < this.softLimit) {
                            newSize = 2 * this.softLimit;
                        }
                        if (newSize < 4 * this.readChunkSize) {
                            newSize = 12 * this.readChunkSize;
                        }
                    } else if (newSize > this.hardLimit) {
                        if (this.bufEnd >= this.hardLimit) {
                            throw new TokenizerBufferOverflowException("buffer can not grow beyond hard limit" + this.getPosDesc(), this.posRow, this.posCol - 1);
                        }
                        newSize = this.hardLimit;
                    }
                    if (newSize - this.bufSize > 0) {
                        this.resize(newSize);
                    }
                }
                if (this.bufSize - this.bufEnd < (chunkie = this.readChunkSize)) {
                    chunkie = this.bufSize - this.bufEnd;
                }
                if (this.reader == null) {
                    throw new TokenizerException("to start parsing setInput() must be called!");
                }
                int bufRead = this.reader.read(this.buf, this.bufEnd, chunkie);
                if (bufRead == -1) {
                    if (this.reachedEnd) {
                        throw new TokenizerException("can't read more - reached end of stream (state=" + this.state + ")" + this.getPosDesc());
                    }
                    this.reachedEnd = true;
                }
                if (bufRead == 0) {
                    throw new TokenizerBufferOverflowException("can't read more data in buffer (read() returns 0 chars)" + this.getPosDesc());
                }
                this.bufEnd += bufRead;
            }
        }
        if ((ch = this.buf[this.pos++]) == '\n' || ch == '\r') {
            if (this.prevCh != '\r' || ch != '\n') {
                this.posCol = 2;
                ++this.posRow;
            }
        } else {
            ++this.posCol;
        }
        this.prevPrevCh = this.prevCh;
        this.prevCh = ch;
        return this.prevCh;
    }

    private void resize(int newSize) {
        char[] newBuf = new char[newSize];
        int end = this.bufEnd;
        if (end > newSize) {
            end = newSize;
            if (this.state != 1) {
                throw new PullParserRuntimeException("internal buffer may not be shrank during parsing" + this.getPosDesc());
            }
        }
        System.arraycopy(this.buf, 0, newBuf, 0, end);
        this.buf = newBuf;
        this.bufSize = newSize;
        if (this.softLimit == -1) {
            this.posSafe = this.loadFactor * this.bufSize / 100;
        }
    }

    private void ensurePC() {
        if (this.paramPC && this.pcEnd >= this.pc.length) {
            int newSize = 2 * this.pcEnd + 1;
            char[] newpc = new char[newSize];
            System.arraycopy(this.pc, 0, newpc, 0, this.pc.length);
            this.pc = newpc;
        }
    }

    private char less() {
        --this.pos;
        --this.posCol;
        this.backtracking = true;
        return this.prevPrevCh;
    }

    private void shrink(int posCut) {
        System.arraycopy(this.buf, posCut, this.buf, 0, this.bufEnd - posCut);
        this.shrinkOffset += posCut;
        this.bufEnd -= posCut;
        this.pos -= posCut;
        this.posStart -= posCut;
        this.posEnd -= posCut;
        this.posNsColon -= posCut;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte next() throws TokenizerException, IOException {
        if (this.state == 7) {
            throw new TokenizerException("attempt to read beyond end of input");
        }
        this.parsedContent = false;
        block32: while (true) {
            int len;
            if (this.reachedEnd) {
                if (this.state != 6) {
                    if (this.state != 12 && this.state != 10 && this.state != 11) {
                        throw new TokenizerException("unexpected end of stream (state=" + this.state + ")" + this.getPosDesc());
                    }
                    if (this.state == 10 || this.state == 11) {
                        if (this.state == 10) {
                            this.pcStart = 0;
                            this.pcEnd = 0;
                        }
                        this.posEnd = this.posStart = this.pos - 1;
                    }
                    this.state = (byte)6;
                    if (this.paramPC && (this.pcStart != this.pcEnd || this.posEnd != this.posStart)) {
                        boolean bl = this.parsedContent = this.pcEnd != this.pcStart;
                        if (!this.paramNoMixContent || !this.seenContent) {
                            return 10;
                        }
                        if (this.parsedContent) {
                            throw new TokenizerException("no element content allowed before end of stream" + this.getPosDesc());
                        }
                    }
                }
                this.state = (byte)7;
                return 2;
            }
            char ch = this.more();
            if (ch == '\r') {
                if (this.pcStart == this.pcEnd && this.posEnd > this.posStart) {
                    len = this.posEnd - this.posStart;
                    System.arraycopy(this.buf, this.posStart, this.pc, this.pcEnd, len);
                    this.pcEnd += len;
                }
            } else if (this.prevPrevCh == '\r' && ch == '\n') continue;
            switch (this.state) {
                case 1: {
                    if (ch == '\ufffe') {
                        throw new TokenizerException("first character in input was UNICODE noncharacter (0xFFFE)- input requires byte swapping");
                    }
                    if (ch == '\ufeff') {
                        this.state = (byte)10;
                        continue block32;
                    }
                }
                case 10: {
                    this.pcStart = 0;
                    this.pcEnd = 0;
                }
                case 11: {
                    this.posEnd = this.posStart = this.pos - 1;
                    this.state = (byte)12;
                }
                case 12: {
                    if (ch == '<') {
                        this.state = (byte)13;
                        if (!this.paramNotifyCharacters || this.posStart == this.posEnd) continue block32;
                        return 20;
                    }
                    if (ch == '&') {
                        if (this.paramPC && this.pcStart == this.pcEnd && this.posEnd > this.posStart) {
                            len = this.posEnd - this.posStart;
                            System.arraycopy(this.buf, this.posStart, this.pc, this.pcEnd, len);
                            this.pcEnd += len;
                        }
                        if (!this.seenContent) {
                            this.seenContent = true;
                            if (this.paramNoMixContent && !this.mixInElement) {
                                throw new TokenizerException("mixed content disallowed outside element" + this.getPosDesc(), this.posRow, this.posCol - 1);
                            }
                        }
                        this.state = (byte)70;
                        this.previousState = (byte)11;
                        this.posStart = this.pos - 1;
                        continue block32;
                    }
                    if (!this.seenContent && !this.isS(ch)) {
                        this.seenContent = true;
                        if (this.paramNoMixContent && !this.mixInElement) {
                            throw new TokenizerException("mixed content disallowed outside element, character " + Tokenizer.printable(ch) + " (" + ch + ")" + this.getPosDesc(), this.posRow, this.posCol - 1);
                        }
                    }
                    this.posEnd = this.pos;
                    if (this.paramPC && (this.pcStart != this.pcEnd || ch == '\r')) {
                        if (ch == '\r') {
                            if (this.pcEnd >= this.pc.length) {
                                this.ensurePC();
                            }
                            this.pc[this.pcEnd++] = 10;
                        } else {
                            if (this.pcEnd >= this.pc.length) {
                                this.ensurePC();
                            }
                            this.pc[this.pcEnd++] = ch;
                        }
                    }
                    if (!this.paramNotifyCharacters || !this.reachedEnd) continue block32;
                    return 20;
                }
                case 13: {
                    if (ch == '!') {
                        this.state = (byte)14;
                    } else if (ch == '?') {
                        this.state = (byte)60;
                    } else {
                        boolean prevMixSeenContent = this.seenContent;
                        boolean prevMixInElement = this.mixInElement;
                        if (ch == '/') {
                            this.state = (byte)110;
                            this.mixInElement = false;
                        } else {
                            this.state = (byte)120;
                            if (this.paramNoMixContent && this.seenContent) {
                                throw new TokenizerException("mixed content disallowed inside element and before start tag" + this.getPosDesc(), this.posRow, this.posCol - 1);
                            }
                            this.mixInElement = true;
                        }
                        if (this.paramPC && (this.pcStart != this.pcEnd || this.posEnd != this.posStart || this.state == 110 && this.seenStartTag) && (!this.paramNoMixContent || prevMixSeenContent || this.paramNoMixContent && this.state == 110 && this.seenStartTag)) {
                            boolean bl = this.parsedContent = this.pcEnd != this.pcStart;
                            if (!this.parsedContent && this.posEnd == this.posStart) continue block32;
                            return 10;
                        }
                    }
                    if (this.paramPC && this.state != 120 && this.state != 110 && this.pcStart == this.pcEnd && this.posEnd > this.posStart) {
                        len = this.posEnd - this.posStart;
                        System.arraycopy(this.buf, this.posStart, this.pc, this.pcEnd, len);
                        this.pcEnd += len;
                    }
                    this.posStart = this.pos;
                    continue block32;
                }
                case 14: {
                    if (ch == '-') {
                        ch = this.more();
                        if (ch != '-') {
                            throw new TokenizerException("expected - for start of comment <!-- not " + ch + this.getPosDesc(), this.posRow, this.posCol - 1);
                        }
                        this.state = (byte)40;
                        this.posStart = this.pos;
                        continue block32;
                    }
                    if (ch == '[') {
                        ch = this.more();
                        if (ch != 'C') {
                            throw new TokenizerException("expected <![CDATA" + this.getPosDesc(), this.posRow, this.posCol - 1);
                        }
                        ch = this.more();
                        if (ch != 'D') {
                            throw new TokenizerException("expected <![CDATA" + this.getPosDesc(), this.posRow, this.posCol - 1);
                        }
                        ch = this.more();
                        if (ch != 'A') {
                            throw new TokenizerException("expected <![CDATA" + this.getPosDesc(), this.posRow, this.posCol - 1);
                        }
                        ch = this.more();
                        if (ch != 'T') {
                            throw new TokenizerException("expected <![CDATA" + this.getPosDesc(), this.posRow, this.posCol - 1);
                        }
                        ch = this.more();
                        if (ch != 'A') {
                            throw new TokenizerException("expected <![CDATA" + this.getPosDesc(), this.posRow, this.posCol - 1);
                        }
                        ch = this.more();
                        if (ch != '[') {
                            throw new TokenizerException("expected <![CDATA" + this.getPosDesc(), this.posRow, this.posCol - 1);
                        }
                        this.posStart = this.pos;
                        if (!this.seenContent) {
                            this.seenContent = true;
                            if (this.paramNoMixContent && !this.mixInElement) {
                                throw new TokenizerException("mixed content disallowed outside element" + this.getPosDesc(), this.posRow, this.posCol - 1);
                            }
                        }
                        this.state = (byte)30;
                        continue block32;
                    }
                    if (ch != 'D') throw new TokenizerException("unknown markup after <! " + Tokenizer.printableChar(ch) + this.getPosDesc(), this.posRow, this.posCol - 1);
                    ch = this.more();
                    if (ch != 'O') {
                        throw new TokenizerException("expected <![DOCTYPE" + this.getPosDesc(), this.posRow, this.posCol - 1);
                    }
                    ch = this.more();
                    if (ch != 'C') {
                        throw new TokenizerException("expected <![DOCTYPE" + this.getPosDesc(), this.posRow, this.posCol - 1);
                    }
                    ch = this.more();
                    if (ch != 'T') {
                        throw new TokenizerException("expected <![DOCTYPE" + this.getPosDesc(), this.posRow, this.posCol - 1);
                    }
                    ch = this.more();
                    if (ch != 'Y') {
                        throw new TokenizerException("expected <![DOCTYPE" + this.getPosDesc(), this.posRow, this.posCol - 1);
                    }
                    ch = this.more();
                    if (ch != 'P') {
                        throw new TokenizerException("expected <![DOCTYPE" + this.getPosDesc(), this.posRow, this.posCol - 1);
                    }
                    ch = this.more();
                    if (ch != 'E') {
                        throw new TokenizerException("expected <![DOCTYPE" + this.getPosDesc(), this.posRow, this.posCol - 1);
                    }
                    this.posStart = this.pos;
                    this.state = (byte)50;
                    continue block32;
                }
                case 70: {
                    this.posStart = this.pos - 2;
                    if (ch == '#') {
                        this.state = (byte)75;
                        continue block32;
                    }
                    this.state = (byte)71;
                }
                case 71: {
                    if (ch != ';') continue block32;
                    this.state = this.previousState;
                    this.posEnd = this.pos;
                    if (this.paramPC) {
                        int j = this.pos - 1;
                        int i = this.posStart + 1;
                        int len2 = j - i;
                        if (len2 == 2 && this.buf[i] == 'l' && this.buf[i + 1] == 't') {
                            if (this.pcEnd >= this.pc.length) {
                                this.ensurePC();
                            }
                            this.pc[this.pcEnd++] = 60;
                        } else if (len2 == 3 && this.buf[i] == 'a' && this.buf[i + 1] == 'm' && this.buf[i + 2] == 'p') {
                            if (this.pcEnd >= this.pc.length) {
                                this.ensurePC();
                            }
                            this.pc[this.pcEnd++] = 38;
                        } else if (len2 == 2 && this.buf[i] == 'g' && this.buf[i + 1] == 't') {
                            if (this.pcEnd >= this.pc.length) {
                                this.ensurePC();
                            }
                            this.pc[this.pcEnd++] = 62;
                        } else if (len2 == 4 && this.buf[i] == 'a' && this.buf[i + 1] == 'p' && this.buf[i + 2] == 'o' && this.buf[i + 3] == 's') {
                            if (this.pcEnd >= this.pc.length) {
                                this.ensurePC();
                            }
                            this.pc[this.pcEnd++] = 39;
                        } else if (len2 == 4 && this.buf[i] == 'q' && this.buf[i + 1] == 'u' && this.buf[i + 2] == 'o' && this.buf[i + 3] == 't') {
                            if (this.pcEnd >= this.pc.length) {
                                this.ensurePC();
                            }
                            this.pc[this.pcEnd++] = 34;
                        } else {
                            String s2 = new String(this.buf, i, j - i);
                            throw new TokenizerException("undefined entity " + s2 + this.getPosDesc(), this.posRow, this.posCol - 1);
                        }
                    }
                    if (!this.paramNotifyEntityRef) continue block32;
                    return 70;
                }
                case 75: {
                    this.charRefValue = '\u0000';
                    this.state = (byte)76;
                    if (ch == 'x') {
                        this.charRefHex = true;
                        continue block32;
                    }
                    this.charRefHex = false;
                }
                case 76: {
                    if (ch == ';') {
                        if (this.paramPC) {
                            if (this.pcEnd >= this.pc.length) {
                                this.ensurePC();
                            }
                            this.pc[this.pcEnd++] = this.charRefValue;
                        }
                        this.state = this.previousState;
                        this.posEnd = this.pos;
                        if (!this.paramNotifyCharRef) continue block32;
                        return 75;
                    }
                    if (ch >= '0' && ch <= '9') {
                        if (this.charRefHex) {
                            this.charRefValue = (char)(this.charRefValue * 16 + (ch - 48));
                            continue block32;
                        }
                        this.charRefValue = (char)(this.charRefValue * 10 + (ch - 48));
                        continue block32;
                    }
                    if (this.charRefHex && ch >= 'A' && ch <= 'F') {
                        this.charRefValue = (char)(this.charRefValue * 16 + (ch - 65 + 10));
                        continue block32;
                    }
                    if (!this.charRefHex || ch < 'a' || ch > 'f') throw new TokenizerException("character reference may not contain " + Tokenizer.printable(ch) + this.getPosDesc(), this.posRow, this.posCol - 1);
                    this.charRefValue = (char)(this.charRefValue * 16 + (ch - 97 + 10));
                    continue block32;
                }
                case 110: {
                    this.seenStartTag = false;
                    this.seenContent = false;
                    this.posStart = this.pos - 1;
                    ch = this.readName(ch);
                    this.posEnd = this.pos - 1;
                    ch = this.skipS(ch);
                    if (ch != '>') {
                        throw new TokenizerException("expected > for end tag not " + Tokenizer.printable(ch) + this.getPosDesc(), this.posRow, this.posCol - 1);
                    }
                    this.state = (byte)10;
                    return 110;
                }
                case 120: {
                    if (this.shrinkable && this.reading && this.pos > 2 && this.pos > this.posSafe) {
                        this.shrink(this.pos - 2);
                    }
                    this.seenStartTag = true;
                    this.seenContent = false;
                    ch = this.less();
                    this.posStart = this.pos - 1;
                    ch = this.readName(ch);
                    this.posEnd = this.pos - 1;
                    ch = this.less();
                    this.state = (byte)122;
                    this.pcStart = 0;
                    this.pcEnd = 0;
                    return 120;
                }
                case 121: {
                    if (ch != '>') throw new TokenizerException("expected > for end of start tag not " + Tokenizer.printable(ch) + this.getPosDesc(), this.posRow, this.posCol - 1);
                    this.state = (byte)10;
                    this.posStart = this.pos - 1;
                    this.posEnd = this.pos;
                    return 112;
                }
                case 122: {
                    this.pcStart = this.pcEnd;
                    boolean seenSBeforeAttrName = this.isS(ch);
                    ch = this.skipS(ch);
                    if (ch == '/') {
                        this.state = (byte)121;
                        this.posStart = this.pos - 1;
                        this.posEnd = this.pos;
                        this.mixInElement = false;
                        this.seenStartTag = false;
                        return 111;
                    }
                    if (ch == '>') {
                        this.state = (byte)10;
                        this.posStart = this.pos - 1;
                        this.posEnd = this.pos;
                        return 112;
                    }
                    if (!seenSBeforeAttrName) {
                        throw new TokenizerException("white space expected before attribute name and not " + Tokenizer.printable(ch) + this.getPosDesc(), this.posRow, this.posCol - 1);
                    }
                    this.posStart = this.pos - 1;
                    ch = this.readName(ch);
                    this.posEnd = this.pos - 1;
                    ch = this.less();
                    this.state = (byte)123;
                    return 122;
                }
                case 123: {
                    ch = this.skipS(ch);
                    if (ch != '=') {
                        throw new TokenizerException("expected = after attribute name not " + Tokenizer.printable(ch) + this.getPosDesc(), this.posRow, this.posCol - 1);
                    }
                    this.state = (byte)124;
                    continue block32;
                }
                case 124: {
                    ch = this.skipS(ch);
                    if (ch != '\'' && ch != '\"') {
                        throw new TokenizerException("attribute value must start with double quote or apostrophe not " + Tokenizer.printable(ch) + this.getPosDesc(), this.posRow, this.posCol - 1);
                    }
                    this.attrMarker = ch;
                    this.state = (byte)125;
                    this.posEnd = this.posStart = this.pos;
                    this.pcEnd = this.pcStart;
                    continue block32;
                }
                case 125: {
                    this.state = (byte)126;
                }
                case 126: {
                    if (ch == this.attrMarker) {
                        this.state = this.paramPC ? (byte)127 : (byte)122;
                        if (!this.paramNotifyAttValue) continue block32;
                        return 124;
                    }
                    if (ch == '&') {
                        if (this.paramPC && this.pcEnd == this.pcStart && this.posEnd > this.posStart) {
                            len = this.posEnd - this.posStart;
                            System.arraycopy(this.buf, this.posStart, this.pc, this.pcEnd, len);
                            this.pcEnd += len;
                        }
                        this.state = (byte)70;
                        this.previousState = (byte)125;
                        if (!this.paramNotifyAttValue) continue block32;
                        return 124;
                    }
                    if (ch == '<') {
                        throw new TokenizerException("attribute value can not contain " + ch + this.getPosDesc(), this.posRow, this.posCol - 1);
                    }
                    if (this.paramPC && (this.pcStart != this.pcEnd || ch == '\t' || ch == '\n' || ch == '\r')) {
                        if (this.pcStart == this.pcEnd && this.posEnd > this.posStart) {
                            len = this.posEnd - this.posStart;
                            System.arraycopy(this.buf, this.posStart, this.pc, this.pcEnd, len);
                            this.pcEnd += len;
                        }
                        if (ch == '\t' || ch == '\n' || ch == '\r') {
                            if (this.pcEnd >= this.pc.length) {
                                this.ensurePC();
                            }
                            this.pc[this.pcEnd++] = 32;
                            continue block32;
                        }
                        if (this.pcEnd >= this.pc.length) {
                            this.ensurePC();
                        }
                        this.pc[this.pcEnd++] = ch;
                        continue block32;
                    }
                    this.posEnd = this.pos;
                    continue block32;
                }
                case 127: {
                    ch = this.less();
                    this.parsedContent = this.pcEnd != this.pcStart;
                    this.state = (byte)122;
                    return 127;
                }
                case 30: {
                    if (ch != ']') continue block32;
                    this.state = (byte)31;
                    continue block32;
                }
                case 31: {
                    if (ch == ']') {
                        this.state = (byte)32;
                        continue block32;
                    }
                    this.state = (byte)30;
                    continue block32;
                }
                case 32: {
                    if (ch == '>') {
                        this.state = (byte)11;
                        this.posEnd = this.pos - 3;
                        if (this.paramPC && this.posEnd > this.posStart) {
                            len = this.posEnd - this.posStart;
                            System.arraycopy(this.buf, this.posStart, this.pc, this.pcEnd, len);
                            this.pcEnd += len;
                        }
                        if (!this.paramNotifyCDSect) continue block32;
                        return 30;
                    }
                    this.state = (byte)30;
                    continue block32;
                }
                case 40: {
                    if (ch != '-') continue block32;
                    this.state = (byte)41;
                    continue block32;
                }
                case 41: {
                    if (ch == '-') {
                        this.state = (byte)42;
                        continue block32;
                    }
                    this.state = (byte)40;
                    continue block32;
                }
                case 42: {
                    if (ch == '>') {
                        this.state = (byte)11;
                        this.posEnd = this.pos - 3;
                        if (!this.paramNotifyComment) continue block32;
                        return 40;
                    }
                    this.state = (byte)40;
                    continue block32;
                }
                case 50: {
                    if (ch == '[') {
                        this.state = (byte)51;
                        continue block32;
                    }
                    if (ch != '>') continue block32;
                    this.state = (byte)11;
                    this.posEnd = this.pos - 1;
                    if (!this.paramNotifyDoctype) continue block32;
                    return 50;
                }
                case 51: {
                    if (ch != ']') continue block32;
                    this.state = (byte)52;
                    continue block32;
                }
                case 52: {
                    ch = this.skipS(ch);
                    if (ch != '>') throw new TokenizerException("expected > for DOCTYPE end not " + ch + this.getPosDesc(), this.posRow, this.posCol - 1);
                    this.state = (byte)11;
                    this.posEnd = this.pos - 1;
                    if (!this.paramNotifyDoctype) continue block32;
                    return 50;
                }
                case 60: {
                    if (ch != '?') continue block32;
                    this.state = (byte)61;
                    continue block32;
                }
                case 61: {
                    if (ch != '>') continue block32;
                    this.state = (byte)11;
                    this.posEnd = this.pos - 2;
                    if (this.paramNotifyPI) return 60;
                    continue block32;
                }
            }
            break;
        }
        throw new TokenizerException("invalid internal state " + this.state + this.getPosDesc(), this.posRow, this.posCol - 1);
    }
}

