/*
 * Decompiled with CFR 0.152.
 */
package org.jaxen.function;

import java.util.List;
import org.jaxen.Context;
import org.jaxen.Function;
import org.jaxen.FunctionCallException;
import org.jaxen.Navigator;

public class NameFunction
implements Function {
    public Object call(Context context, List args2) throws FunctionCallException {
        if (args2.size() == 0) {
            return NameFunction.evaluate(context.getNodeSet(), context.getNavigator());
        }
        if (args2.size() == 1) {
            return NameFunction.evaluate(args2, context.getNavigator());
        }
        throw new FunctionCallException("name() requires zero or one argument.");
    }

    public static String evaluate(List list2, Navigator nav) throws FunctionCallException {
        if (!list2.isEmpty()) {
            Object first2 = list2.get(0);
            if (first2 instanceof List) {
                return NameFunction.evaluate((List)first2, nav);
            }
            if (nav.isElement(first2)) {
                return nav.getElementQName(first2);
            }
            if (nav.isAttribute(first2)) {
                return nav.getAttributeQName(first2);
            }
            if (nav.isProcessingInstruction(first2)) {
                return nav.getProcessingInstructionTarget(first2);
            }
            if (nav.isNamespace(first2)) {
                return nav.getNamespacePrefix(first2);
            }
            if (nav.isDocument(first2)) {
                return "";
            }
            if (nav.isComment(first2)) {
                return "";
            }
            if (nav.isText(first2)) {
                return "";
            }
            throw new FunctionCallException("The argument to the name function must be a node-set");
        }
        return "";
    }
}

