/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.action;

import ch.qos.logback.core.joran.action.Action;
import ch.qos.logback.core.joran.spi.ActionException;
import ch.qos.logback.core.joran.spi.InterpretationContext;
import ch.qos.logback.core.model.ImplicitModel;
import ch.qos.logback.core.model.Model;
import java.util.Stack;
import org.xml.sax.Attributes;

public class ImplicitModelAction
extends Action {
    Stack<ImplicitModel> currentImplicitModelStack = new Stack();

    @Override
    public void begin(InterpretationContext interpretationContext, String name, Attributes attributes) throws ActionException {
        String implicitClassName;
        ImplicitModel currentImplicitModel = new ImplicitModel();
        currentImplicitModel.setTag(name);
        String className = attributes.getValue("class");
        if (className == null && (implicitClassName = interpretationContext.getDefaultNestedComponentRegistry().findDefaultComponentTypeByTag(name)) != null) {
            this.addInfo("Assuming default class name [" + implicitClassName + "] for tag [" + name + "]");
            className = implicitClassName;
        }
        currentImplicitModel.setClassName(className);
        this.currentImplicitModelStack.push(currentImplicitModel);
        interpretationContext.pushModel(currentImplicitModel);
    }

    @Override
    public void body(InterpretationContext ec, String body2) {
        ImplicitModel implicitModel = this.currentImplicitModelStack.peek();
        implicitModel.addText(body2);
    }

    @Override
    public void end(InterpretationContext interpretationContext, String name) throws ActionException {
        Model otherImplicitModel;
        ImplicitModel implicitModel = this.currentImplicitModelStack.peek();
        if (implicitModel != (otherImplicitModel = interpretationContext.popModel())) {
            this.addError(implicitModel + " does not match " + otherImplicitModel);
            return;
        }
        Model parentModel = interpretationContext.peekModel();
        parentModel.addSubModel(implicitModel);
        this.currentImplicitModelStack.pop();
    }
}

